/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.collect.ImmutableSortedSet;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.AssignmentHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CExpressionVisitorWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CompositeField;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DeferredAllocation;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Expression;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerApproximatingVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

class DynamicMemoryHandler {
    private static final String CALLOC_FUNCTION = "calloc";
    private static final char MALLOC_INDEX_SEPARATOR = '#';
    private final CToFormulaConverterWithPointerAliasing conv;
    private final TypeHandlerWithPointerAliasing typeHandler;
    private final CFAEdge edge;
    private final SSAMap.SSAMapBuilder ssa;
    private final PointerTargetSetBuilder pts;
    private final Constraints constraints;
    private final ErrorConditions errorConditions;
    private final MemoryRegionManager regionMgr;

    DynamicMemoryHandler(CToFormulaConverterWithPointerAliasing pConv, CFAEdge pEdge, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions, MemoryRegionManager pRegionMgr) {
        this.conv = pConv;
        this.typeHandler = pConv.typeHandler;
        this.edge = pEdge;
        this.ssa = pSsa;
        this.pts = pPts;
        this.constraints = pConstraints;
        this.errorConditions = pErrorConditions;
        this.regionMgr = pRegionMgr;
    }

    Expression.Value handleDynamicMemoryFunction(CFunctionCallExpression e, String functionName, CExpressionVisitorWithPointerAliasing expressionVisitor) throws UnrecognizedCodeException, InterruptedException {
        if (this.conv.options.isSuccessfulAllocFunctionName(functionName) || this.conv.options.isSuccessfulZallocFunctionName(functionName)) {
            return Expression.Value.ofValue(this.handleSuccessfulMemoryAllocation(functionName, e.getParameterExpressions(), e));
        }
        if (this.conv.options.isMemoryAllocationFunction(functionName) || this.conv.options.isMemoryAllocationFunctionWithZeroing(functionName)) {
            return Expression.Value.ofValue(this.handleMemoryAllocation(e, functionName));
        }
        if (this.conv.options.isMemoryFreeFunction(functionName)) {
            return this.handleMemoryFree(e, expressionVisitor);
        }
        throw new AssertionError((Object)("Unknown memory allocation function " + functionName));
    }

    private Formula handleMemoryAllocation(CFunctionCallExpression e, String functionName) throws UnrecognizedCodeException, InterruptedException {
        String delegateFunctionName;
        boolean isZeroing = this.conv.options.isMemoryAllocationFunctionWithZeroing(functionName);
        List<CExpression> parameters = e.getParameterExpressions();
        if (functionName.equals(CALLOC_FUNCTION) && parameters.size() == 2) {
            CExpression param0 = parameters.get(0);
            CExpression param1 = parameters.get(1);
            CBinaryExpressionBuilder builder = new CBinaryExpressionBuilder(this.conv.machineModel, (LogManager)this.conv.logger);
            CBinaryExpression multiplication = builder.buildBinaryExpression(param0, param1, CBinaryExpression.BinaryOperator.MULTIPLY);
            Long value0 = DynamicMemoryHandler.tryEvaluateExpression(param0);
            Long value1 = DynamicMemoryHandler.tryEvaluateExpression(param1);
            if (value0 != null && value1 != null) {
                long result = AbstractExpressionValueVisitor.calculateBinaryOperation(new NumericValue(value0), new NumericValue(value1), multiplication, this.conv.machineModel, this.conv.logger).asLong(multiplication.getExpressionType());
                CIntegerLiteralExpression newParam = new CIntegerLiteralExpression(param0.getFileLocation(), multiplication.getExpressionType(), BigInteger.valueOf(result));
                parameters = Collections.singletonList(newParam);
            } else {
                parameters = Collections.singletonList(multiplication);
            }
        } else if (parameters.size() != 1) {
            if (parameters.size() > 1 && this.conv.options.hasSuperfluousParameters(functionName)) {
                parameters = Collections.singletonList(parameters.get(0));
            } else {
                throw new UnrecognizedCodeException(String.format("Memory allocation function %s() called with %d parameters instead of 1", functionName, parameters.size()), this.edge, e);
            }
        }
        String string = delegateFunctionName = !isZeroing ? this.conv.options.getSuccessfulAllocFunctionName() : this.conv.options.getSuccessfulZallocFunctionName();
        if (!this.conv.options.makeMemoryAllocationsAlwaysSucceed()) {
            Formula nondet = this.conv.makeFreshVariable(functionName, CPointerType.POINTER_TO_VOID, this.ssa);
            return this.conv.bfmgr.ifThenElse(this.conv.bfmgr.not(this.conv.fmgr.makeEqual(nondet, this.conv.nullPointer)), this.handleSuccessfulMemoryAllocation(delegateFunctionName, parameters, e), this.conv.nullPointer);
        }
        return this.handleSuccessfulMemoryAllocation(delegateFunctionName, parameters, e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Formula handleSuccessfulMemoryAllocation(String functionName, List<CExpression> parameters, CFunctionCallExpression e) throws UnrecognizedCodeException, InterruptedException {
        Formula address;
        String newBase;
        CType newType;
        if (parameters.size() != 1) {
            if (parameters.size() <= 1 || !this.conv.options.hasSuperfluousParameters(functionName)) throw new UnrecognizedCodeException(String.format("Memory allocation function %s() called with %d parameters instead of 1", functionName, parameters.size()), this.edge, e);
            parameters = Collections.singletonList(parameters.get(0));
        }
        CExpression parameter = parameters.get(0);
        Long size = null;
        if (DynamicMemoryHandler.isSizeof(parameter)) {
            newType = this.getSizeofType(parameter);
        } else if (DynamicMemoryHandler.isSizeofMultiple(parameter)) {
            CBinaryExpression product = (CBinaryExpression)parameter;
            CType operand1Type = this.getSizeofType(product.getOperand1());
            CType operand2Type = this.getSizeofType(product.getOperand2());
            if (operand1Type != null) {
                newType = new CArrayType(false, false, operand1Type, product.getOperand2());
            } else {
                if (operand2Type == null) throw new UnrecognizedCodeException("Can't determine type for internal memory allocation", this.edge, e);
                newType = new CArrayType(false, false, operand2Type, product.getOperand1());
            }
        } else {
            size = DynamicMemoryHandler.tryEvaluateExpression(parameter);
            if (!this.conv.options.revealAllocationTypeFromLHS() && !this.conv.options.deferUntypedAllocations()) {
                CExpression length;
                if (size == null) {
                    size = this.conv.options.defaultAllocationSize();
                    length = new CIntegerLiteralExpression(parameter.getFileLocation(), parameter.getExpressionType(), BigInteger.valueOf(size));
                } else {
                    length = parameter;
                }
                newType = new CArrayType(false, false, CVoidType.VOID, length);
            } else {
                newType = null;
            }
        }
        Formula sizeExp = this.conv.makeCast(parameter.getExpressionType(), this.conv.machineModel.getPointerDiffType(), this.conv.buildTerm(parameter, this.edge, this.edge.getPredecessor().getFunctionName(), this.ssa, this.pts, this.constraints, this.errorConditions), this.constraints, this.edge);
        if (newType != null) {
            newBase = this.makeAllocVariableName(functionName, newType, this.pts.getFreshAllocationId());
            address = this.makeAllocation(this.conv.options.isSuccessfulZallocFunctionName(functionName), newType, newBase, sizeExp);
        } else {
            newBase = this.makeAllocVariableName(functionName, CVoidType.VOID, this.pts.getFreshAllocationId());
            this.pts.addTemporaryDeferredAllocation(this.conv.options.isSuccessfulZallocFunctionName(functionName), Optional.ofNullable(size).map(s -> new CIntegerLiteralExpression(parameter.getFileLocation(), parameter.getExpressionType(), BigInteger.valueOf(s))), sizeExp, newBase);
            address = this.conv.makeConstant(PointerTargetSet.getBaseName(newBase), CPointerType.POINTER_TO_VOID);
            this.constraints.addConstraint(this.conv.fmgr.makeGreaterThan(address, this.conv.fmgr.makeNumber(this.typeHandler.getPointerType(), 0L), true));
        }
        if (!this.errorConditions.isEnabled()) return address;
        this.constraints.addConstraint(this.conv.fmgr.makeEqual(this.conv.makeBaseAddressOfTerm(address), address));
        return address;
    }

    private Expression.Value handleMemoryFree(CFunctionCallExpression e, CExpressionVisitorWithPointerAliasing expressionVisitor) throws UnrecognizedCodeException {
        List<CExpression> parameters = e.getParameterExpressions();
        if (parameters.size() != 1) {
            throw new UnrecognizedCodeException(String.format("free() called with %d parameters", parameters.size()), this.edge, e);
        }
        if (this.errorConditions.isEnabled()) {
            Formula operand = expressionVisitor.asValueFormula(parameters.get(0).accept(expressionVisitor), this.typeHandler.getSimplifiedType(parameters.get(0)));
            BooleanFormula validFree = this.conv.fmgr.makeEqual(operand, this.conv.nullPointer);
            for (String base : this.pts.getAllBases()) {
                Formula baseF = this.conv.makeBaseAddress(PointerTargetSet.getBaseName(base), CPointerType.POINTER_TO_VOID);
                validFree = this.conv.bfmgr.or(validFree, this.conv.fmgr.makeEqual(operand, baseF));
            }
            this.errorConditions.addInvalidFreeCondition(this.conv.bfmgr.not(validFree));
        }
        return Expression.Value.nondetValue();
    }

    private Formula makeAllocation(boolean isZeroing, CType type, String base, Formula size) throws UnrecognizedCodeException, InterruptedException {
        Formula result = this.conv.makeBaseAddress(base, type);
        if (isZeroing) {
            AssignmentHandler assignmentHandler = new AssignmentHandler(this.conv, this.edge, base, this.ssa, this.pts, this.constraints, this.errorConditions, this.regionMgr);
            BooleanFormula initialization = assignmentHandler.makeDestructiveAssignment(type, CNumericTypes.SIGNED_CHAR, Expression.Location.AliasedLocation.ofAddress(result), Expression.Value.ofValue(this.conv.fmgr.makeNumber(this.conv.getFormulaTypeFromCType(CNumericTypes.SIGNED_CHAR), 0L)), true, null);
            this.constraints.addConstraint(initialization);
        }
        this.pts.addBase(base, type, size, this.constraints);
        if (isZeroing) {
            this.addAllFields(type);
        }
        return result;
    }

    private void addAllFields(CType type) {
        if (type instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)type;
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                if (!this.conv.isRelevantField(compositeType, memberDeclaration)) continue;
                this.pts.addField(CompositeField.of(compositeType, memberDeclaration));
                CType memberType = this.typeHandler.getSimplifiedType(memberDeclaration);
                this.addAllFields(memberType);
            }
        } else if (type instanceof CArrayType) {
            CType elementType = CTypeUtils.checkIsSimplified(((CArrayType)type).getType());
            this.addAllFields(elementType);
        }
    }

    private String makeAllocVariableName(String functionName, CType type, int allocationId) {
        return "#" + functionName + "_" + this.typeHandler.getPointerAccessNameForType(type) + "#" + allocationId;
    }

    static boolean isAllocVariableName(String name) {
        return name.charAt(0) == '#' && name.lastIndexOf(35) > 2;
    }

    private static @Nullable Long tryEvaluateExpression(CExpression e) {
        if (e instanceof CIntegerLiteralExpression) {
            return ((CIntegerLiteralExpression)e).getValue().longValueExact();
        }
        return null;
    }

    private static boolean isSizeof(CExpression e) {
        return e instanceof CUnaryExpression && ((CUnaryExpression)e).getOperator() == CUnaryExpression.UnaryOperator.SIZEOF || e instanceof CTypeIdExpression && ((CTypeIdExpression)e).getOperator() == CTypeIdExpression.TypeIdOperator.SIZEOF;
    }

    private static boolean isSizeofMultiple(CExpression e) {
        return e instanceof CBinaryExpression && ((CBinaryExpression)e).getOperator() == CBinaryExpression.BinaryOperator.MULTIPLY && (DynamicMemoryHandler.isSizeof(((CBinaryExpression)e).getOperand1()) || DynamicMemoryHandler.isSizeof(((CBinaryExpression)e).getOperand2()));
    }

    private @Nullable CType getSizeofType(CExpression e) {
        if (e instanceof CUnaryExpression && ((CUnaryExpression)e).getOperator() == CUnaryExpression.UnaryOperator.SIZEOF) {
            return this.typeHandler.getSimplifiedType(((CUnaryExpression)e).getOperand());
        }
        if (e instanceof CTypeIdExpression && ((CTypeIdExpression)e).getOperator() == CTypeIdExpression.TypeIdOperator.SIZEOF) {
            return this.typeHandler.simplifyType(((CTypeIdExpression)e).getType());
        }
        return null;
    }

    private CType refineType(CType type, CIntegerLiteralExpression sizeLiteral) {
        assert (sizeLiteral.getValue() != null);
        long size = sizeLiteral.getValue().longValueExact();
        long typeSize = this.conv.getSizeof(type);
        if (type instanceof CArrayType) {
            if (typeSize != size) {
                this.conv.logger.logf(Level.WARNING, "Array size of the revealed type differs form the allocation size: %s : %d != %d", new Object[]{type, typeSize, size});
            }
            return type;
        }
        long n = size / typeSize;
        long remainder = size % typeSize;
        if (n == 0L || remainder != 0L) {
            this.conv.logger.logf(Level.WARNING, "Can't refine allocation type, but the sizes differ: %s : %d != %d", new Object[]{type, typeSize, size});
            return type;
        }
        return new CArrayType(false, false, type, new CIntegerLiteralExpression(sizeLiteral.getFileLocation(), sizeLiteral.getExpressionType(), BigInteger.valueOf(n)));
    }

    private static CType unwrapPointers(CType type) {
        if (type instanceof CPointerType) {
            return DynamicMemoryHandler.unwrapPointers(((CPointerType)type).getType());
        }
        return type;
    }

    private CType getAllocationType(CType type, Optional<CIntegerLiteralExpression> sizeLiteral) {
        if (type instanceof CPointerType) {
            CType tt = DynamicMemoryHandler.unwrapPointers(type);
            return sizeLiteral.map(s -> this.refineType(tt, (CIntegerLiteralExpression)s)).orElse(tt);
        }
        if (type instanceof CArrayType) {
            return sizeLiteral.map(s -> this.refineType(type, (CIntegerLiteralExpression)s)).orElse(type);
        }
        throw new IllegalArgumentException("Either pointer or array type expected");
    }

    private void handleDeferredAllocationTypeRevelation(String pointer, CType type) throws UnrecognizedCodeException, InterruptedException {
        for (DeferredAllocation d : this.pts.removeDeferredAllocations(pointer)) {
            this.makeAllocation(d.isZeroed(), this.getAllocationType(type, d.getSize()), d.getBase(), d.getSizeExpression());
        }
    }

    void handleDeferredAllocationsInAssignment(CLeftHandSide lhs, CRightHandSide rhs, Expression rhsExpression, CType lhsType, Map<String, CType> lhsLearnedPointerTypes, Map<String, CType> rhsLearnedPointerTypes) throws UnrecognizedCodeException, InterruptedException {
        boolean isAllocation = false;
        if ((this.conv.options.revealAllocationTypeFromLHS() || this.conv.options.deferUntypedAllocations()) && rhs instanceof CFunctionCallExpression && !rhsExpression.isNondetValue() && rhsExpression.isValue()) {
            Set<String> rhsVariables = this.conv.fmgr.extractVariableNames(rhsExpression.asValue().getValue());
            for (String mangledVariable : rhsVariables) {
                String nameWithoutIndex = FormulaManagerView.parseName(mangledVariable).getFirst();
                if (PointerTargetSet.isBaseName(nameWithoutIndex)) {
                    assert (FormulaManagerView.parseName(mangledVariable).getSecond().isEmpty());
                    String variable = PointerTargetSet.getBase(nameWithoutIndex);
                    if (!this.pts.isTemporaryDeferredAllocationPointer(variable)) continue;
                    if (!isAllocation) {
                        if (CExpressionVisitorWithPointerAliasing.isRevealingType(lhsType)) {
                            this.handleDeferredAllocationTypeRevelation(variable, lhsType);
                        } else {
                            Optional<String> lhsPointer = lhs.accept(new PointerApproximatingVisitor(this.typeHandler, this.edge));
                            lhsPointer.ifPresent(s -> {
                                this.pts.removeDeferredAllocationPointer((String)s).forEach(_d -> this.handleDeferredAllocationPointerRemoval(s));
                                this.pts.addDeferredAllocationPointer((String)s, variable);
                                this.pts.removeDeferredAllocationPointer(variable).forEach(_d -> this.handleDeferredAllocationPointerRemoval(variable));
                            });
                            if (!lhsPointer.isPresent()) {
                                this.conv.logger.logfOnce(Level.WARNING, "Can't start tracking deferred allocation -- can't approximate this LHS: %s (here: %s)", new Object[]{lhs, this.edge});
                                this.pts.removeDeferredAllocationPointer(variable).forEach(_d -> this.handleDeferredAllocationPointerRemoval(variable));
                            }
                        }
                        isAllocation = true;
                        continue;
                    }
                    throw new UnrecognizedCodeException("Can't handle ambiguous allocation", this.edge, rhs);
                }
                assert (!this.pts.isTemporaryDeferredAllocationPointer(mangledVariable));
            }
        }
        if (this.conv.options.deferUntypedAllocations() && !isAllocation) {
            this.handleDeferredAllocationsInAssignment(lhs, rhs, lhsType, lhsLearnedPointerTypes, rhsLearnedPointerTypes);
        }
    }

    private void handleDeferredAllocationsInAssignment(CLeftHandSide lhs, CRightHandSide rhs, CType lhsType, Map<String, CType> lhsLearnedPointerTypes, Map<String, CType> rhsLearnedPointerTypes) throws UnrecognizedCodeException, InterruptedException {
        Optional<String> s;
        CPointerType rType;
        if (!(lhsType instanceof CPointerType) && !(lhsType instanceof CArrayType)) {
            return;
        }
        CType lType = this.typeHandler.simplifyType(lhsType);
        CType cType = rType = rhs != null ? this.typeHandler.getSimplifiedType(rhs) : CPointerType.POINTER_TO_VOID;
        Optional<Object> toHandle = rhs != null && CExpressionVisitorWithPointerAliasing.isRevealingType(lType) ? Optional.of(Pair.of(rhs, lType)) : (CExpressionVisitorWithPointerAliasing.isRevealingType(rType) ? Optional.of(Pair.of(lhs, rType)) : Optional.empty());
        PointerApproximatingVisitor pointerApproximatingVisitor = new PointerApproximatingVisitor(this.typeHandler, this.edge);
        for (Map.Entry<String, CType> entry : lhsLearnedPointerTypes.entrySet()) {
            this.handleDeferredAllocationTypeRevelation(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, CType> entry : rhsLearnedPointerTypes.entrySet()) {
            this.handleDeferredAllocationTypeRevelation(entry.getKey(), entry.getValue());
        }
        if (toHandle.isPresent() && (s = ((CRightHandSide)((Pair)toHandle.orElseThrow()).getFirst()).accept(pointerApproximatingVisitor)).isPresent() && !lhsLearnedPointerTypes.containsKey(s.orElseThrow()) && !rhsLearnedPointerTypes.containsKey(s.orElseThrow())) {
            this.handleDeferredAllocationTypeRevelation(s.orElseThrow(), (CType)((Pair)toHandle.orElseThrow()).getSecond());
        }
        if (lhs instanceof CIdExpression) {
            this.pts.removeDeferredAllocationPointer(((CIdExpression)lhs).getDeclaration().getQualifiedName()).forEach(_d -> this.handleDeferredAllocationPointerRemoval(lhs));
        } else {
            Optional<String> lhsPointer = lhs.accept(pointerApproximatingVisitor);
            if (lhsPointer.isPresent() && this.pts.canRemoveDeferredAllocationPointer(lhsPointer.orElseThrow())) {
                this.pts.removeDeferredAllocationPointer(lhsPointer.orElseThrow());
            }
        }
        Optional<String> l = lhs.accept(pointerApproximatingVisitor);
        if (l.isPresent() && rhs != null) {
            rhs.accept(pointerApproximatingVisitor).ifPresent(r -> this.pts.addDeferredAllocationPointer((String)l.orElseThrow(), (String)r));
        }
    }

    void handleDeferredAllocationsInAssume(CExpression e, Map<String, CType> learnedPointerTypes) throws UnrecognizedCodeException, InterruptedException {
        for (Map.Entry<String, CType> entry : learnedPointerTypes.entrySet()) {
            this.handleDeferredAllocationTypeRevelation(entry.getKey(), entry.getValue());
        }
    }

    private void handleDeferredAllocationPointerRemoval(Object pointer) {
        this.conv.logger.logfOnce(Level.WARNING, "%s: Assignment to the void* pointer %s produces garbage or the memory pointed by it is unused: %s", new Object[]{this.edge.getFileLocation(), pointer, this.edge.getDescription()});
    }

    void handleDeferredAllocationInFunctionExit(String function) {
        for (String v : CFAUtils.filterVariablesOfFunction((NavigableSet<String>)ImmutableSortedSet.copyOf(this.pts.getDeferredAllocationPointers()), function)) {
            if (this.pts.removeDeferredAllocationPointer(v).isEmpty()) continue;
            this.conv.logger.logfOnce(Level.WARNING, "%s: Destroying the void* pointer %s produces garbage or the memory pointed by it is unused: %s", new Object[]{this.edge.getFileLocation(), v, this.edge.getDescription()});
        }
    }
}

