/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.InlineMe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegion;
import org.sosy_lab.java_smt.api.Formula;

abstract class Expression {
    Expression() {
    }

    boolean isLocation() {
        return this instanceof Location;
    }

    boolean isValue() {
        return this instanceof Value;
    }

    boolean isNondetValue() {
        return this == Value.nondet;
    }

    boolean isAliasedLocation() {
        return this.isLocation() && this.asLocation().isAliased();
    }

    boolean isUnaliasedLocation() {
        return this.isLocation() && !this.asLocation().isAliased();
    }

    abstract Location asLocation();

    abstract Location.AliasedLocation asAliasedLocation();

    abstract Location.UnaliasedLocation asUnaliasedLocation();

    abstract Value asValue();

    abstract Kind getKind();

    static enum Kind {
        ALIASED_LOCATION,
        UNALIASED_LOCATION,
        DET_VALUE,
        NONDET;

    }

    static class Value
    extends Expression {
        private final @Nullable Formula value;
        private static final Value nondet = new Nondet();

        static Value ofValueOrNondet(@Nullable Formula value) {
            return value == null ? Value.nondetValue() : Value.ofValue(value);
        }

        static Value ofValue(Formula value) {
            return new Value((Formula)Preconditions.checkNotNull((Object)value));
        }

        static Value nondetValue() {
            return nondet;
        }

        Value(@Nullable Formula value) {
            this.value = value;
        }

        @Nullable Formula getValue() {
            return this.value;
        }

        boolean isNondet() {
            return false;
        }

        @Override
        Kind getKind() {
            return Kind.DET_VALUE;
        }

        @Override
        @Deprecated
        final Location asLocation() {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        final Location.AliasedLocation asAliasedLocation() {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        final Location.UnaliasedLocation asUnaliasedLocation() {
            throw new IllegalStateException();
        }

        @Override
        @Deprecated
        @InlineMe(replacement="this")
        final Value asValue() {
            return this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }

        public boolean equals(Object pOther) {
            if (!(pOther instanceof Value)) {
                return false;
            }
            Value otherValue = (Value)pOther;
            if (this instanceof Nondet || otherValue instanceof Nondet) {
                return false;
            }
            return this.getValue().equals((Object)otherValue.getValue());
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        private static class Nondet
        extends Value {
            private Nondet() {
                super(null);
            }

            @Override
            boolean isNondet() {
                return true;
            }

            @Override
            Kind getKind() {
                return Kind.NONDET;
            }

            @Override
            public String toString() {
                return MoreObjects.toStringHelper((Object)this).toString();
            }
        }
    }

    static abstract class Location
    extends Expression {
        Location() {
        }

        boolean isAliased() {
            return this instanceof AliasedLocation;
        }

        @Override
        @Deprecated
        @InlineMe(replacement="this")
        final Location asLocation() {
            return this;
        }

        @Override
        final Value asValue() {
            throw new IllegalStateException();
        }

        abstract AliasedLocation asAliased();

        abstract UnaliasedLocation asUnaliased();

        static final class UnaliasedLocation
        extends Location {
            private final String variableName;

            static UnaliasedLocation ofVariableName(String variableName) {
                return new UnaliasedLocation((String)Preconditions.checkNotNull((Object)variableName));
            }

            private UnaliasedLocation(String variableName) {
                this.variableName = variableName;
            }

            String getVariableName() {
                return this.variableName;
            }

            @Override
            Kind getKind() {
                return Kind.UNALIASED_LOCATION;
            }

            @Override
            @Deprecated
            AliasedLocation asAliased() {
                throw new IllegalStateException();
            }

            @Override
            @Deprecated
            AliasedLocation asAliasedLocation() {
                throw new IllegalStateException();
            }

            @Override
            @Deprecated
            @InlineMe(replacement="this")
            UnaliasedLocation asUnaliased() {
                return this;
            }

            @Override
            @Deprecated
            @InlineMe(replacement="this")
            UnaliasedLocation asUnaliasedLocation() {
                return this;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("variable", (Object)this.variableName).toString();
            }
        }

        static final class AliasedLocation
        extends Location {
            private final Formula address;
            private final @Nullable MemoryRegion region;

            static AliasedLocation ofAddress(Formula address) {
                return new AliasedLocation((Formula)Preconditions.checkNotNull((Object)address));
            }

            static AliasedLocation ofAddressWithRegion(Formula address, MemoryRegion region) {
                return new AliasedLocation((Formula)Preconditions.checkNotNull((Object)address), (MemoryRegion)Preconditions.checkNotNull((Object)region));
            }

            private AliasedLocation(Formula address) {
                this(address, null);
            }

            private AliasedLocation(Formula address, @Nullable MemoryRegion region) {
                this.address = address;
                this.region = region;
            }

            Formula getAddress() {
                return this.address;
            }

            @Override
            Kind getKind() {
                return Kind.ALIASED_LOCATION;
            }

            @Override
            @Deprecated
            @InlineMe(replacement="this")
            AliasedLocation asAliased() {
                return this;
            }

            @Override
            @Deprecated
            @InlineMe(replacement="this")
            AliasedLocation asAliasedLocation() {
                return this;
            }

            @Override
            @Deprecated
            UnaliasedLocation asUnaliased() {
                throw new IllegalStateException();
            }

            @Override
            @Deprecated
            UnaliasedLocation asUnaliasedLocation() {
                throw new IllegalStateException();
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).toString();
            }

            @Nullable MemoryRegion getMemoryRegion() {
                return this.region;
            }
        }
    }
}

