/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import java.util.OptionalLong;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetPattern;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;

class LvalueToPointerTargetPatternVisitor
extends DefaultCExpressionVisitor<PointerTargetPattern.PointerTargetPatternBuilder, UnrecognizedCodeException> {
    private final TypeHandlerWithPointerAliasing typeHandler;
    private final PointerTargetSetBuilder pts;
    private final CFAEdge cfaEdge;

    LvalueToPointerTargetPatternVisitor(TypeHandlerWithPointerAliasing pTypeHandler, CFAEdge pCfaEdge, PointerTargetSetBuilder pPts) {
        this.typeHandler = pTypeHandler;
        this.cfaEdge = pCfaEdge;
        this.pts = pPts;
    }

    @Override
    protected PointerTargetPattern.PointerTargetPatternBuilder visitDefault(CExpression e) throws UnrecognizedCodeException {
        throw new UnrecognizedCodeException("Illegal expression in lhs", this.cfaEdge, e);
    }

    @Override
    public PointerTargetPattern.PointerTargetPatternBuilder visit(CArraySubscriptExpression e) throws UnrecognizedCodeException {
        CType containerType;
        CExpression arrayExpression = e.getArrayExpression();
        PointerTargetPattern.PointerTargetPatternBuilder result = arrayExpression.accept(new PointerTargetEvaluatingVisitor());
        if (result == null) {
            result = PointerTargetPattern.PointerTargetPatternBuilder.any();
        }
        if ((containerType = this.typeHandler.getSimplifiedType(arrayExpression)) instanceof CArrayType || containerType instanceof CPointerType) {
            CType elementType;
            if (containerType instanceof CPointerType) {
                elementType = ((CPointerType)containerType).getType();
                containerType = new CArrayType(containerType.isConst(), containerType.isVolatile(), elementType, null);
            } else {
                elementType = ((CArrayType)containerType).getType();
            }
            result.shift(containerType);
            Long index = LvalueToPointerTargetPatternVisitor.tryEvaluateExpression(e.getSubscriptExpression());
            if (index != null) {
                result.setProperOffset(index * this.typeHandler.getSizeof(elementType));
            }
            return result;
        }
        throw new UnrecognizedCodeException("Array expression has incompatible type", this.cfaEdge, e);
    }

    @Override
    public PointerTargetPattern.PointerTargetPatternBuilder visit(CCastExpression e) throws UnrecognizedCodeException {
        return e.getOperand().accept(this);
    }

    @Override
    public PointerTargetPattern.PointerTargetPatternBuilder visit(CFieldReference e) throws UnrecognizedCodeException {
        CExpression ownerExpression = (e = e.withExplicitPointerDereference()).getFieldOwner();
        PointerTargetPattern.PointerTargetPatternBuilder result = ownerExpression.accept(this);
        if (result != null) {
            CType containerType = this.typeHandler.getSimplifiedType(ownerExpression);
            if (containerType instanceof CCompositeType) {
                assert (((CCompositeType)containerType).getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composites!";
                OptionalLong offset = this.typeHandler.getOffset((CCompositeType)containerType, e.getFieldName());
                if (!offset.isPresent()) {
                    return null;
                }
                result.shift(containerType, offset.orElseThrow());
                return result;
            }
            throw new UnrecognizedCodeException("Field owner expression has incompatible type", this.cfaEdge, e);
        }
        return null;
    }

    @Override
    public PointerTargetPattern.PointerTargetPatternBuilder visit(CIdExpression e) throws UnrecognizedCodeException {
        CType expressionType = this.typeHandler.getSimplifiedType(e);
        String name = e.getDeclaration().getQualifiedName();
        if (!this.pts.isActualBase(name) && !CTypeUtils.containsArray(expressionType, e.getDeclaration())) {
            return null;
        }
        return PointerTargetPattern.PointerTargetPatternBuilder.forBase(name);
    }

    @Override
    public PointerTargetPattern.PointerTargetPatternBuilder visit(CUnaryExpression e) throws UnrecognizedCodeException {
        switch (e.getOperator()) {
            case AMPER: 
            case MINUS: 
            case TILDE: 
            case SIZEOF: {
                throw new UnrecognizedCodeException("Illegal unary operator", this.cfaEdge, e);
            }
        }
        throw new UnrecognizedCodeException("Unhandled unary operator", this.cfaEdge, e);
    }

    @Override
    public PointerTargetPattern.PointerTargetPatternBuilder visit(CPointerExpression e) throws UnrecognizedCodeException {
        CExpression operand = e.getOperand();
        CType type = this.typeHandler.getSimplifiedType(operand);
        PointerTargetPattern.PointerTargetPatternBuilder result = e.getOperand().accept(new PointerTargetEvaluatingVisitor());
        if (type instanceof CPointerType) {
            if (result != null) {
                result.clear();
                return result;
            }
            return PointerTargetPattern.PointerTargetPatternBuilder.any();
        }
        if (type instanceof CArrayType) {
            if (result != null) {
                result.shift(type, 0L);
                return result;
            }
            return PointerTargetPattern.PointerTargetPatternBuilder.any();
        }
        throw new UnrecognizedCodeException("Dereferencing non-pointer expression", this.cfaEdge, e);
    }

    private static @Nullable Long tryEvaluateExpression(CExpression e) {
        if (e instanceof CIntegerLiteralExpression) {
            return ((CIntegerLiteralExpression)e).getValue().longValueExact();
        }
        return null;
    }

    private class PointerTargetEvaluatingVisitor
    extends DefaultCExpressionVisitor<PointerTargetPattern.PointerTargetPatternBuilder, UnrecognizedCodeException> {
        private PointerTargetEvaluatingVisitor() {
        }

        @Override
        protected PointerTargetPattern.PointerTargetPatternBuilder visitDefault(CExpression e) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public PointerTargetPattern.PointerTargetPatternBuilder visit(CBinaryExpression e) throws UnrecognizedCodeException {
            CExpression operand1 = e.getOperand1();
            CExpression operand2 = e.getOperand2();
            switch (e.getOperator()) {
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: 
                case DIVIDE: 
                case EQUALS: 
                case GREATER_EQUAL: 
                case GREATER_THAN: 
                case LESS_EQUAL: 
                case LESS_THAN: 
                case MODULO: 
                case MULTIPLY: 
                case NOT_EQUALS: 
                case SHIFT_LEFT: 
                case SHIFT_RIGHT: {
                    return null;
                }
                case MINUS: {
                    PointerTargetPattern.PointerTargetPatternBuilder result = operand1.accept(this);
                    if (result != null) {
                        Long offset = LvalueToPointerTargetPatternVisitor.tryEvaluateExpression(operand2);
                        Long oldOffset = result.getProperOffset();
                        if (offset != null && oldOffset != null && offset < oldOffset) {
                            result.setProperOffset(oldOffset - offset);
                        } else {
                            result.retainBase();
                        }
                        return result;
                    }
                    return null;
                }
                case PLUS: {
                    Long offset;
                    PointerTargetPattern.PointerTargetPatternBuilder result = operand1.accept(this);
                    if (result == null) {
                        result = operand2.accept(this);
                        offset = LvalueToPointerTargetPatternVisitor.tryEvaluateExpression(operand1);
                    } else {
                        offset = LvalueToPointerTargetPatternVisitor.tryEvaluateExpression(operand2);
                    }
                    if (result != null) {
                        Long remaining = result.getRemainingOffset(LvalueToPointerTargetPatternVisitor.this.typeHandler);
                        if (offset != null && remaining != null && offset < remaining) {
                            assert (result.getProperOffset() != null) : "Unexpected nondet proper offset";
                            result.setProperOffset(result.getProperOffset() + offset);
                        } else {
                            result.retainBase();
                        }
                        return result;
                    }
                    return null;
                }
            }
            throw new UnrecognizedCodeException("Unhandled binary operator", LvalueToPointerTargetPatternVisitor.this.cfaEdge, e);
        }

        @Override
        public PointerTargetPattern.PointerTargetPatternBuilder visit(CCastExpression e) throws UnrecognizedCodeException {
            return e.getOperand().accept(this);
        }

        @Override
        public PointerTargetPattern.PointerTargetPatternBuilder visit(CIdExpression e) throws UnrecognizedCodeException {
            CType expressionType = LvalueToPointerTargetPatternVisitor.this.typeHandler.getSimplifiedType(e);
            String name = e.getDeclaration().getQualifiedName();
            if (!LvalueToPointerTargetPatternVisitor.this.pts.isBase(name, expressionType) && !CTypeUtils.containsArray(expressionType, e.getDeclaration())) {
                return null;
            }
            return PointerTargetPattern.PointerTargetPatternBuilder.forBase(name);
        }

        @Override
        public PointerTargetPattern.PointerTargetPatternBuilder visit(CUnaryExpression e) throws UnrecognizedCodeException {
            CExpression operand = e.getOperand();
            switch (e.getOperator()) {
                case AMPER: {
                    return operand.accept(LvalueToPointerTargetPatternVisitor.this);
                }
                case MINUS: 
                case TILDE: {
                    return null;
                }
                case SIZEOF: {
                    throw new UnrecognizedCodeException("Illegal unary operator", LvalueToPointerTargetPatternVisitor.this.cfaEdge, e);
                }
            }
            throw new UnrecognizedCodeException("Unrecognized unary operator", LvalueToPointerTargetPatternVisitor.this.cfaEdge, e);
        }

        @Override
        public PointerTargetPattern.PointerTargetPatternBuilder visit(CPointerExpression e) throws UnrecognizedCodeException {
            return null;
        }
    }
}

