/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;

@Immutable
public final class PointerTarget
implements Serializable {
    final String base;
    final @Nullable CType containerType;
    final long properOffset;
    final long containerOffset;
    private static final long serialVersionUID = -1258065871533686442L;

    PointerTarget(String base, @Nullable CType containerType, long properOffset, long containerOffset) {
        this.base = base;
        this.containerType = containerType;
        this.properOffset = properOffset;
        this.containerOffset = containerOffset;
    }

    String getBase() {
        return this.base;
    }

    public String getBaseName() {
        return PointerTargetSet.getBaseName(this.base);
    }

    public long getOffset() {
        return this.containerOffset + this.properOffset;
    }

    long getProperOffset() {
        assert (this.containerType != null) : "The target's offset is ill-defined";
        return this.properOffset;
    }

    boolean isBase() {
        return this.containerType == null;
    }

    @Nullable CType getContainerType() {
        return this.containerType;
    }

    long getContainerOffset() {
        assert (this.containerType != null) : "The target's container offset is ill-defined";
        return this.containerOffset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PointerTarget)) {
            return false;
        }
        PointerTarget o = (PointerTarget)other;
        return this.properOffset == o.properOffset && this.containerOffset == o.containerOffset && this.base.equals(o.base) && (this.containerType != null ? o.containerType != null && this.containerType.getCanonicalType().equals(o.containerType.getCanonicalType()) : o.containerType == null);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.containerOffset, this.properOffset);
    }

    public String toString() {
        return String.format("(Base: %s, type: %s, prop. offset: %d, cont. offset: %d)", this.base, this.containerType, this.properOffset, this.containerOffset);
    }
}

