/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.LvalueToPointerTargetPatternVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;

class PointerTargetPattern
implements Serializable,
Predicate<PointerTarget> {
    private final @Nullable String base;
    private final @Nullable CType containerType;
    private final @Nullable Long properOffset;
    private final @Nullable Long containerOffset;
    private static final long serialVersionUID = -2918663736813010025L;

    private PointerTargetPattern(@Nullable String pBase, @Nullable CType pContainerType, @Nullable Long pProperOffset, @Nullable Long pContainerOffset) {
        this.base = pBase;
        this.containerType = pContainerType;
        this.properOffset = pProperOffset;
        this.containerOffset = pContainerOffset;
    }

    static PointerTargetPattern any() {
        return new PointerTargetPattern(null, null, null, null);
    }

    static PointerTargetPattern forBase(String base) {
        return new PointerTargetPattern(base, null, 0L, 0L);
    }

    static Predicate<PointerTarget> forRange(String base, long startOffset, long size) {
        return new RangePointerTargetPattern(base, startOffset, size);
    }

    static PointerTargetPattern forLeftHandSide(CLeftHandSide lhs, TypeHandlerWithPointerAliasing pTypeHandler, CFAEdge pCfaEdge, PointerTargetSetBuilder pPts) throws UnrecognizedCodeException {
        LvalueToPointerTargetPatternVisitor v = new LvalueToPointerTargetPatternVisitor(pTypeHandler, pCfaEdge, pPts);
        return lhs.accept(v).build();
    }

    Predicate<PointerTarget> withRange(long size) {
        assert (this.containerOffset != null && this.properOffset != null) : "Starting address is inexact";
        return PointerTargetPattern.forRange(this.base, this.containerOffset + this.properOffset, size);
    }

    boolean matches(PointerTarget target) {
        if (this.properOffset != null && this.properOffset != target.properOffset) {
            return false;
        }
        if (this.containerOffset != null && this.containerOffset != target.containerOffset) {
            return false;
        }
        if (this.base != null && !this.base.equals(target.base)) {
            return false;
        }
        if (this.containerType != null && !this.containerType.equals(target.containerType)) {
            if (!(this.containerType instanceof CArrayType) || !(target.containerType instanceof CArrayType)) {
                return false;
            }
            return ((CArrayType)this.containerType).getType().equals(((CArrayType)target.containerType).getType());
        }
        return true;
    }

    @Deprecated
    public boolean apply(PointerTarget pInput) {
        return this.matches(pInput);
    }

    boolean isExact() {
        return this.base != null && this.containerOffset != null && this.properOffset != null;
    }

    boolean isSemiExact() {
        return this.containerOffset != null && this.properOffset != null;
    }

    PointerTarget asPointerTarget() {
        Preconditions.checkArgument((boolean)this.isExact());
        return new PointerTarget(this.base, this.containerType, this.properOffset, this.containerOffset);
    }

    static class PointerTargetPatternBuilder {
        private @Nullable String base = null;
        private @Nullable CType containerType = null;
        private @Nullable Long properOffset = null;
        private @Nullable Long containerOffset = null;

        private PointerTargetPatternBuilder() {
        }

        static PointerTargetPatternBuilder any() {
            return new PointerTargetPatternBuilder();
        }

        static PointerTargetPatternBuilder forBase(String pBase) {
            PointerTargetPatternBuilder result = new PointerTargetPatternBuilder();
            result.base = pBase;
            result.properOffset = 0L;
            result.containerOffset = 0L;
            return result;
        }

        private PointerTargetPattern build() {
            return new PointerTargetPattern(this.base, this.containerType, this.properOffset, this.containerOffset);
        }

        void setProperOffset(long properOffset) {
            this.properOffset = properOffset;
        }

        @Nullable Long getProperOffset() {
            return this.properOffset;
        }

        @Nullable Long getRemainingOffset(TypeHandlerWithPointerAliasing typeHandler) {
            if (this.containerType != null && this.containerOffset != null && this.properOffset != null) {
                return typeHandler.getSizeof(this.containerType) - this.properOffset;
            }
            return null;
        }

        void shift(CType pContainerType) {
            this.containerType = pContainerType;
            if (this.containerOffset != null) {
                this.containerOffset = this.properOffset != null ? Long.valueOf(this.containerOffset + this.properOffset) : null;
            }
            this.properOffset = null;
        }

        void shift(CType pContainerType, long pProperOffset) {
            this.shift(pContainerType);
            this.properOffset = pProperOffset;
        }

        void retainBase() {
            this.containerType = null;
            this.properOffset = null;
            this.containerOffset = null;
        }

        void clear() {
            this.base = null;
            this.containerType = null;
            this.properOffset = null;
            this.containerOffset = null;
        }
    }

    private static class RangePointerTargetPattern
    implements Predicate<PointerTarget> {
        private final String base;
        private final long startOffset;
        private final long endOffset;

        private RangePointerTargetPattern(String pBase, long pStartOffset, long pSize) {
            this.base = pBase;
            this.startOffset = pStartOffset;
            this.endOffset = pStartOffset + pSize;
        }

        public boolean apply(PointerTarget target) {
            long offset = target.containerOffset + target.properOffset;
            if (offset < this.startOffset || offset >= this.endOffset) {
                return false;
            }
            return this.base == null || this.base.equals(target.base);
        }
    }
}

