/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CompositeField;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DeferredAllocation;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DynamicMemoryHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.Formula;

@Immutable
public final class PointerTargetSet
implements Serializable {
    private static final PointerTargetSet EMPTY_INSTANCE = new PointerTargetSet((PersistentSortedMap<String, CType>)PathCopyingPersistentTreeMap.of(), (PersistentSortedMap<CompositeField, Boolean>)PathCopyingPersistentTreeMap.of(), (PersistentList<Pair<String, DeferredAllocation>>)PersistentLinkedList.of(), (PersistentSortedMap<String, PersistentList<PointerTarget>>)PathCopyingPersistentTreeMap.of(), (PersistentList<Formula>)PersistentLinkedList.of(), 0);
    private static final Joiner joiner = Joiner.on((String)" ");
    private final PersistentSortedMap<String, CType> bases;
    private final PersistentSortedMap<CompositeField, Boolean> fields;
    private final PersistentList<Pair<String, DeferredAllocation>> deferredAllocations;
    private final PersistentSortedMap<String, PersistentList<PointerTarget>> targets;
    private final PersistentList<Formula> highestAllocatedAddresses;
    private final int allocationCount;
    private static final String BASE_PREFIX = "__ADDRESS_OF_";
    private static final long serialVersionUID = 2102505458322248624L;

    static String getBaseName(String name) {
        return BASE_PREFIX + name;
    }

    public static boolean isBaseName(String name) {
        return name.startsWith(BASE_PREFIX);
    }

    public static String getBase(String baseName) {
        assert (PointerTargetSet.isBaseName(baseName));
        return baseName.substring(BASE_PREFIX.length());
    }

    public static boolean isMallocBase(String baseName) {
        assert (PointerTargetSet.isBaseName(baseName));
        return DynamicMemoryHandler.isAllocVariableName(PointerTargetSet.getBase(baseName));
    }

    PersistentList<PointerTarget> getAllTargets(String regionName) {
        return (PersistentList)this.targets.getOrDefault((Object)regionName, (Object)PersistentLinkedList.of());
    }

    public static PointerTargetSet emptyPointerTargetSet() {
        return EMPTY_INSTANCE;
    }

    boolean isEmpty() {
        return this.bases.isEmpty() && this.fields.isEmpty() && this.deferredAllocations.isEmpty() && this.highestAllocatedAddresses.isEmpty() && this.allocationCount == 0;
    }

    public String toString() {
        return joiner.join((Iterable)this.bases.entrySet()) + " " + joiner.join((Iterable)this.fields.entrySet());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bases.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.deferredAllocations.hashCode();
        result = 31 * result + this.highestAllocatedAddresses.hashCode();
        result = 31 * result + Integer.hashCode(this.allocationCount);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PointerTargetSet)) {
            return false;
        }
        PointerTargetSet other = (PointerTargetSet)obj;
        return this.bases.equals(other.bases) && this.fields.equals(other.fields) && this.deferredAllocations.equals(other.deferredAllocations) && this.highestAllocatedAddresses.equals(other.getHighestAllocatedAddresses()) && this.allocationCount == other.allocationCount;
    }

    PointerTargetSet(PersistentSortedMap<String, CType> bases, PersistentSortedMap<CompositeField, Boolean> fields, PersistentList<Pair<String, DeferredAllocation>> deferredAllocations, PersistentSortedMap<String, PersistentList<PointerTarget>> targets, PersistentList<Formula> pHighestAllocatedAddresess, int pAllocationCount) {
        this.bases = bases;
        this.fields = fields;
        this.deferredAllocations = deferredAllocations;
        this.targets = targets;
        this.highestAllocatedAddresses = pHighestAllocatedAddresess;
        this.allocationCount = pAllocationCount;
        if (this.isEmpty()) assert (targets.isEmpty());
    }

    public PersistentSortedMap<String, CType> getBases() {
        return this.bases;
    }

    public boolean isActualBase(String name) {
        return this.bases.containsKey((Object)name) && !PointerTargetSetManager.isFakeBaseType((CType)this.bases.get((Object)name));
    }

    PersistentSortedMap<CompositeField, Boolean> getFields() {
        return this.fields;
    }

    PersistentList<Pair<String, DeferredAllocation>> getDeferredAllocations() {
        return this.deferredAllocations;
    }

    PersistentSortedMap<String, PersistentList<PointerTarget>> getTargets() {
        return this.targets;
    }

    PersistentList<Formula> getHighestAllocatedAddresses() {
        return this.highestAllocatedAddresses;
    }

    int getAllocationCount() {
        return this.allocationCount;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("Proxy required");
    }

    public boolean hasEmptyDeferredAllocationsSet() {
        return this.deferredAllocations.isEmpty();
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 8022025017590667769L;
        private final PersistentSortedMap<String, CType> bases;
        private final PersistentSortedMap<CompositeField, Boolean> fields;
        private final List<Pair<String, DeferredAllocation>> deferredAllocations;
        private final Map<String, List<PointerTarget>> targets;
        private final List<String> highestAllocatedAddresses;
        private final int allocationCount;

        private SerializationProxy(PointerTargetSet pts) {
            this.bases = pts.bases;
            this.fields = pts.fields;
            this.deferredAllocations = new ArrayList<Pair<String, DeferredAllocation>>((Collection<Pair<String, DeferredAllocation>>)pts.deferredAllocations);
            this.targets = new HashMap<String, List<PointerTarget>>(Maps.transformValues(pts.targets, ArrayList::new));
            FormulaManagerView mgr = GlobalInfo.getInstance().getPredicateFormulaManagerView();
            this.highestAllocatedAddresses = new ArrayList<String>(Lists.transform(pts.highestAllocatedAddresses, mgr::dumpArbitraryFormula));
            this.allocationCount = pts.allocationCount;
        }

        private Object readResolve() {
            FormulaManagerView mgr = GlobalInfo.getInstance().getPredicateFormulaManagerView();
            PersistentLinkedList highestAllocatedAddressesFormulas = PersistentLinkedList.copyOf((List)Lists.transform(this.highestAllocatedAddresses, mgr::parseArbitraryFormula));
            return new PointerTargetSet(this.bases, this.fields, (PersistentList<Pair<String, DeferredAllocation>>)PersistentLinkedList.copyOf(this.deferredAllocations), (PersistentSortedMap<String, PersistentList<PointerTarget>>)PathCopyingPersistentTreeMap.copyOf((Map)Maps.transformValues(this.targets, PersistentLinkedList::copyOf)), (PersistentList<Formula>)highestAllocatedAddressesFormulas, this.allocationCount);
        }
    }
}

