/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CompositeField;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DeferredAllocation;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegion;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.java_smt.api.Formula;

public interface PointerTargetSetBuilder {
    public void prepareBase(String var1, CType var2, @Nullable Formula var3, Constraints var4);

    public void shareBase(String var1, CType var2);

    public void addBase(String var1, CType var2, @Nullable Formula var3, Constraints var4);

    public boolean tracksField(CompositeField var1);

    public boolean addField(CompositeField var1);

    public void addEssentialFields(List<CompositeField> var1);

    public void addTemporaryDeferredAllocation(boolean var1, Optional<CIntegerLiteralExpression> var2, Formula var3, String var4);

    public void addDeferredAllocationPointer(String var1, String var2);

    public ImmutableSet<DeferredAllocation> removeDeferredAllocationPointer(String var1);

    public boolean canRemoveDeferredAllocationPointer(String var1);

    public ImmutableSet<DeferredAllocation> removeDeferredAllocations(String var1);

    public ImmutableSet<String> getDeferredAllocationPointers();

    public boolean isTemporaryDeferredAllocationPointer(String var1);

    public boolean isDeferredAllocationPointer(String var1);

    public boolean isActualBase(String var1);

    public boolean isPreparedBase(String var1);

    public boolean isBase(String var1, CType var2);

    public NavigableSet<String> getAllBases();

    public PersistentList<PointerTarget> getAllTargets(MemoryRegion var1);

    public Iterable<PointerTarget> getMatchingTargets(MemoryRegion var1, Predicate<PointerTarget> var2);

    public Iterable<PointerTarget> getNonMatchingTargets(MemoryRegion var1, Predicate<PointerTarget> var2);

    public int getFreshAllocationId();

    public PointerTargetSet build();

    public static enum DummyPointerTargetSetBuilder implements PointerTargetSetBuilder
    {
        INSTANCE;


        @Override
        public void prepareBase(String pName, CType pType, @Nullable Formula pSize, Constraints constraints) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shareBase(String pName, CType pType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addBase(String pName, CType pType, @Nullable Formula pSize, Constraints constraints) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tracksField(CompositeField pField) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addField(CompositeField pField) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addEssentialFields(List<CompositeField> pFields) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addTemporaryDeferredAllocation(boolean pIsZeroed, Optional<CIntegerLiteralExpression> pSize, Formula pSizeExp, String pBase) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addDeferredAllocationPointer(String pNewPointer, String pOriginalPointer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<DeferredAllocation> removeDeferredAllocationPointer(String pPointer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<DeferredAllocation> removeDeferredAllocations(String pPointer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<String> getDeferredAllocationPointers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTemporaryDeferredAllocationPointer(String pPointerVariable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDeferredAllocationPointer(String pPointerVariable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isActualBase(String pName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPreparedBase(String pName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isBase(String pName, CType pType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<String> getAllBases() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PersistentList<PointerTarget> getAllTargets(MemoryRegion region) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<PointerTarget> getMatchingTargets(MemoryRegion region, Predicate<PointerTarget> pPattern) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<PointerTarget> getNonMatchingTargets(MemoryRegion region, Predicate<PointerTarget> pPattern) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getFreshAllocationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PointerTargetSet build() {
            return PointerTargetSet.emptyPointerTargetSet();
        }

        @Override
        public boolean canRemoveDeferredAllocationPointer(String pPointer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class RealPointerTargetSetBuilder
    implements PointerTargetSetBuilder {
        private final TypeHandlerWithPointerAliasing typeHandler;
        private final PointerTargetSetManager ptsMgr;
        private final FormulaEncodingWithPointerAliasingOptions options;
        private final MemoryRegionManager regionMgr;
        private PersistentSortedMap<String, CType> bases;
        private PersistentSortedMap<CompositeField, Boolean> fields;
        private PersistentList<Pair<String, DeferredAllocation>> deferredAllocations;
        private PersistentSortedMap<String, PersistentList<PointerTarget>> targets;
        private PersistentList<Formula> highestAllocatedAddresses;
        private int allocationCount;

        public RealPointerTargetSetBuilder(PointerTargetSet pointerTargetSet, TypeHandlerWithPointerAliasing pTypeHandler, PointerTargetSetManager pPtsMgr, FormulaEncodingWithPointerAliasingOptions pOptions, MemoryRegionManager pRegionMgr) {
            this.bases = pointerTargetSet.getBases();
            this.fields = pointerTargetSet.getFields();
            this.deferredAllocations = pointerTargetSet.getDeferredAllocations();
            this.targets = pointerTargetSet.getTargets();
            this.highestAllocatedAddresses = pointerTargetSet.getHighestAllocatedAddresses();
            this.allocationCount = pointerTargetSet.getAllocationCount();
            this.typeHandler = pTypeHandler;
            this.ptsMgr = pPtsMgr;
            this.options = pOptions;
            this.regionMgr = pRegionMgr;
        }

        private void addTargets(String name, CType type) {
            this.targets = this.ptsMgr.addToTargets(name, null, type, null, 0L, 0L, this.targets, this.fields);
        }

        @Override
        public void prepareBase(String name, CType type, @Nullable Formula sizeExp, Constraints constraints) {
            CTypeUtils.checkIsSimplified(type);
            if (this.bases.containsKey((Object)name)) {
                return;
            }
            long size = type.hasKnownConstantSize() ? this.typeHandler.getSizeof(type) : 0L;
            this.bases = this.bases.putAndCopy((Object)name, (Object)PointerTargetSetManager.getFakeBaseType(size));
            this.makeNextBaseAddressInequality(name, type, sizeExp, constraints);
        }

        @Override
        public void shareBase(String name, CType type) {
            CTypeUtils.checkIsSimplified(type);
            if (type instanceof CElaboratedType) {
                assert (((CElaboratedType)type).getRealType() == null) : "Elaborated type " + type + " that was not simplified but could have been.";
            } else {
                this.addTargets(name, type);
            }
            this.bases = this.bases.putAndCopy((Object)name, (Object)type);
        }

        @Override
        public void addBase(String name, CType type, @Nullable Formula size, Constraints constraints) {
            CTypeUtils.checkIsSimplified(type);
            if (this.bases.containsKey((Object)name)) {
                return;
            }
            this.addTargets(name, type);
            this.bases = this.bases.putAndCopy((Object)name, (Object)type);
            this.makeNextBaseAddressInequality(name, type, size, constraints);
        }

        private void makeNextBaseAddressInequality(String newBase, CType type, @Nullable Formula allocationSize, Constraints constraints) {
            this.highestAllocatedAddresses = this.ptsMgr.makeBaseAddressConstraints(newBase, type, allocationSize, this.highestAllocatedAddresses, constraints);
        }

        @Override
        public boolean tracksField(CompositeField field) {
            return this.fields.containsKey((Object)field);
        }

        private void addTargets(String base, CType cType, long properOffset, long containerOffset, CompositeField field) {
            block4: {
                block5: {
                    CTypeUtils.checkIsSimplified(cType);
                    if (cType instanceof CElaboratedType) break block4;
                    if (!(cType instanceof CArrayType)) break block5;
                    CArrayType arrayType = (CArrayType)cType;
                    int length = CTypeUtils.getArrayLength(arrayType, this.options);
                    long offset = 0L;
                    for (int i = 0; i < length; ++i) {
                        this.addTargets(base, arrayType.getType(), offset, containerOffset + properOffset, field);
                        offset += this.typeHandler.getSizeof(arrayType.getType());
                    }
                    break block4;
                }
                if (!(cType instanceof CCompositeType)) break block4;
                CCompositeType compositeType = (CCompositeType)cType;
                assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
                boolean isTargetComposite = compositeType.equals(field.getOwnerType());
                for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                    OptionalLong offset = this.typeHandler.getOffset(compositeType, memberDeclaration);
                    if (!offset.isPresent()) continue;
                    if (this.tracksField(CompositeField.of(compositeType, memberDeclaration))) {
                        this.addTargets(base, memberDeclaration.getType(), offset.orElseThrow(), containerOffset + properOffset, field);
                    }
                    if (!isTargetComposite || !memberDeclaration.equals(field.getFieldDeclaration())) continue;
                    MemoryRegion newRegion = this.regionMgr.makeMemoryRegion(compositeType, memberDeclaration);
                    this.targets = this.ptsMgr.addToTargets(base, newRegion, memberDeclaration.getType(), compositeType, offset.orElseThrow(), containerOffset + properOffset, this.targets, this.fields);
                }
            }
        }

        @Override
        public boolean addField(CompositeField field) {
            if (this.tracksField(field)) {
                return true;
            }
            PersistentSortedMap<String, PersistentList<PointerTarget>> oldTargets = this.targets;
            for (Map.Entry baseEntry : this.bases.entrySet()) {
                this.addTargets((String)baseEntry.getKey(), (CType)baseEntry.getValue(), 0L, 0L, field);
            }
            this.fields = this.fields.putAndCopy((Object)field, (Object)true);
            return oldTargets != this.targets;
        }

        private void shallowRemoveField(CompositeField field) {
            this.fields = this.fields.removeAndCopy((Object)field);
        }

        @Override
        public void addEssentialFields(List<CompositeField> pFields) {
            Predicate isNewField = compositeField -> !this.tracksField((CompositeField)compositeField);
            Comparator simpleTypedFieldsFirst = (field1, field2) -> {
                int isField1Simple = this.typeHandler.getSimplifiedType(field1.getFieldDeclaration()) instanceof CCompositeType ? 1 : 0;
                int isField2Simple = this.typeHandler.getSimplifiedType(field2.getFieldDeclaration()) instanceof CCompositeType ? 1 : 0;
                return isField1Simple - isField2Simple;
            };
            ImmutableList typedFields = FluentIterable.from(pFields).filter(isNewField).toSortedList(simpleTypedFieldsFirst);
            if (typedFields.isEmpty()) {
                return;
            }
            HashSet<CompositeField> done = new HashSet<CompositeField>();
            ArrayList<CompositeField> currentChain = new ArrayList<CompositeField>();
            for (CompositeField field : typedFields) {
                if (done.contains(field)) continue;
                currentChain.clear();
                CompositeField current = field;
                block1: do {
                    currentChain.add(current);
                    for (CompositeField parentField : typedFields) {
                        if (done.contains(parentField) || !this.typeHandler.getSimplifiedType(parentField.getFieldDeclaration()).equals(current.getOwnerType())) continue;
                        current = parentField;
                        continue block1;
                    }
                } while (!Objects.equals(current, currentChain.get(currentChain.size() - 1)));
                boolean useful = false;
                for (int i = currentChain.size() - 1; i >= 0; --i) {
                    CompositeField f = (CompositeField)currentChain.get(i);
                    done.add(f);
                    useful |= this.addField(f);
                }
                if (useful) continue;
                for (CompositeField f : currentChain) {
                    this.shallowRemoveField(f);
                }
            }
        }

        @Override
        public void addTemporaryDeferredAllocation(boolean isZeroed, Optional<CIntegerLiteralExpression> size, Formula sizeExp, String base) {
            Pair<String, DeferredAllocation> p = Pair.of(base, new DeferredAllocation(base, size, sizeExp, isZeroed));
            if (!this.deferredAllocations.contains(p)) {
                this.deferredAllocations = this.deferredAllocations.with(p);
            }
        }

        @Override
        public void addDeferredAllocationPointer(String newPointer, String originalPointer) {
            HashSet<Pair<String, DeferredAllocation>> cache = new HashSet<Pair<String, DeferredAllocation>>((Collection<Pair<String, DeferredAllocation>>)this.deferredAllocations);
            this.deferredAllocations.stream().filter(p -> ((String)p.getFirst()).equals(originalPointer)).forEachOrdered(p -> {
                Pair<String, DeferredAllocation> pp = Pair.of(newPointer, (DeferredAllocation)p.getSecond());
                if (!cache.contains(pp)) {
                    this.deferredAllocations = this.deferredAllocations.with(pp);
                }
            });
        }

        @Override
        public boolean canRemoveDeferredAllocationPointer(String pointer) {
            Set result = this.deferredAllocations.stream().filter(p -> ((String)p.getFirst()).equals(pointer)).map(Pair::getSecond).collect(Collectors.toCollection(HashSet::new));
            if (result.isEmpty()) {
                return true;
            }
            this.deferredAllocations.forEach(p -> {
                if (!((String)p.getFirst()).equals(pointer)) {
                    result.remove(p.getSecond());
                }
            });
            return result.isEmpty();
        }

        @Override
        public ImmutableSet<DeferredAllocation> removeDeferredAllocationPointer(String pointer) {
            Set result = this.deferredAllocations.stream().filter(p -> ((String)p.getFirst()).equals(pointer)).map(Pair::getSecond).collect(Collectors.toCollection(HashSet::new));
            this.deferredAllocations = (PersistentList)this.deferredAllocations.stream().filter(p -> !((String)p.getFirst()).equals(pointer)).collect(PersistentLinkedList.toPersistentLinkedList());
            this.deferredAllocations.forEach(p -> result.remove(p.getSecond()));
            return ImmutableSet.copyOf((Collection)result);
        }

        @Override
        public ImmutableSet<DeferredAllocation> removeDeferredAllocations(String pointer) {
            ImmutableSet result = FluentIterable.from(this.deferredAllocations).filter(p -> ((String)p.getFirst()).equals(pointer)).transform(Pair::getSecond).toSet();
            this.deferredAllocations = (PersistentList)this.deferredAllocations.stream().filter(p -> !result.contains(p.getSecond())).collect(PersistentLinkedList.toPersistentLinkedList());
            return result;
        }

        @Override
        public ImmutableSet<String> getDeferredAllocationPointers() {
            return Collections3.transformedImmutableSetCopy(this.deferredAllocations, Pair::getFirst);
        }

        @Override
        public boolean isTemporaryDeferredAllocationPointer(String pointer) {
            return this.deferredAllocations.stream().anyMatch(p -> ((String)p.getFirst()).equals(pointer) && ((DeferredAllocation)p.getSecond()).getBase().equals(pointer));
        }

        @Override
        public boolean isDeferredAllocationPointer(String pointer) {
            return this.deferredAllocations.stream().anyMatch(p -> ((String)p.getFirst()).equals(pointer));
        }

        @Override
        public boolean isActualBase(String name) {
            return this.bases.containsKey((Object)name) && !PointerTargetSetManager.isFakeBaseType((CType)this.bases.get((Object)name));
        }

        @Override
        public boolean isPreparedBase(String name) {
            return this.bases.containsKey((Object)name);
        }

        @Override
        public boolean isBase(String name, CType type) {
            CTypeUtils.checkIsSimplified(type);
            CType baseType = (CType)this.bases.get((Object)name);
            return baseType != null && baseType.equals(type);
        }

        @Override
        public NavigableSet<String> getAllBases() {
            return this.bases.keySet();
        }

        @Override
        public PersistentList<PointerTarget> getAllTargets(MemoryRegion region) {
            return (PersistentList)this.targets.getOrDefault((Object)this.regionMgr.getPointerAccessName(region), (Object)PersistentLinkedList.of());
        }

        @Override
        public Iterable<PointerTarget> getMatchingTargets(MemoryRegion region, Predicate<PointerTarget> pattern) {
            return FluentIterable.from(this.getAllTargets(region)).filter(pattern);
        }

        @Override
        public Iterable<PointerTarget> getNonMatchingTargets(MemoryRegion region, Predicate<PointerTarget> pattern) {
            return FluentIterable.from(this.getAllTargets(region)).filter(Predicates.not(pattern));
        }

        @Override
        public PointerTargetSet build() {
            PointerTargetSet result = new PointerTargetSet(this.bases, this.fields, this.deferredAllocations, this.targets, this.highestAllocatedAddresses, this.allocationCount);
            if (result.isEmpty()) {
                return PointerTargetSet.emptyPointerTargetSet();
            }
            return result;
        }

        @Override
        public int getFreshAllocationId() {
            this.allocationCount = Math.incrementExact(this.allocationCount);
            return this.allocationCount;
        }
    }
}

