/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CheckReturnValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.CopyOnWriteSortedMap;
import org.sosy_lab.common.collect.MapsDifference;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.collect.PersistentSortedMaps;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMapMerger;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CompositeField;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DeferredAllocation;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DynamicMemoryHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegion;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeapWithArrays;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeapWithByteArray;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeapWithUninterpretedFunctionCalls;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;

class PointerTargetSetManager {
    private static final String UNITED_BASE_UNION_TAG_PREFIX = "__VERIFIER_base_union_of_";
    private static final String UNITED_BASE_FIELD_NAME_PREFIX = "__VERIFIER_united_base_field";
    private final ShutdownNotifier shutdownNotifier;
    private final CToFormulaConverterWithPointerAliasing conv;
    private final FormulaEncodingWithPointerAliasingOptions options;
    private final FormulaManagerView formulaManager;
    private final BooleanFormulaManagerView bfmgr;
    private final TypeHandlerWithPointerAliasing typeHandler;
    private final MemoryRegionManager regionMgr;
    private final SMTHeap heap;

    static CType getFakeBaseType(long size) {
        return CTypeUtils.checkIsSimplified(new CArrayType(false, false, CVoidType.VOID, new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.SIGNED_CHAR, BigInteger.valueOf(size))));
    }

    static boolean isFakeBaseType(CType type) {
        return type instanceof CArrayType && ((CArrayType)type).getType() instanceof CVoidType;
    }

    private static String getUnitedFieldBaseName(int index) {
        return UNITED_BASE_FIELD_NAME_PREFIX + index;
    }

    PointerTargetSetManager(CToFormulaConverterWithPointerAliasing pConv, FormulaEncodingWithPointerAliasingOptions pOptions, FormulaManagerView pFormulaManager, TypeHandlerWithPointerAliasing pTypeHandler, ShutdownNotifier pShutdownNotifier, MemoryRegionManager pRegionMgr) {
        this.conv = pConv;
        this.options = pOptions;
        this.formulaManager = pFormulaManager;
        this.bfmgr = this.formulaManager.getBooleanFormulaManager();
        this.typeHandler = pTypeHandler;
        this.shutdownNotifier = pShutdownNotifier;
        this.regionMgr = pRegionMgr;
        this.heap = pOptions.useByteArrayForHeap() ? new SMTHeapWithByteArray(pFormulaManager, pTypeHandler.getPointerType(), pConv.machineModel) : (pOptions.useArraysForHeap() ? new SMTHeapWithArrays(pFormulaManager, pTypeHandler.getPointerType()) : new SMTHeapWithUninterpretedFunctionCalls(pFormulaManager));
    }

    <I extends Formula, V extends Formula> V makePointerDereference(String targetName, FormulaType<V> targetType, int ssaIndex, I address) {
        return this.heap.makePointerDereference(targetName, targetType, ssaIndex, address);
    }

    <I extends Formula, E extends Formula> E makePointerDereference(String targetName, FormulaType<E> targetType, I address) {
        return this.heap.makePointerDereference(targetName, targetType, address);
    }

    <I extends Formula, E extends Formula> BooleanFormula makePointerAssignment(String targetName, FormulaType<?> pTargetType, int oldIndex, int newIndex, I address, E value) {
        return this.heap.makePointerAssignment(targetName, pTargetType, oldIndex, newIndex, address, value);
    }

    SSAMapMerger.MergeResult<PointerTargetSet> mergePointerTargetSets(PointerTargetSet pts1, PointerTargetSet pts2, SSAMap.SSAMapBuilder ssa) throws InterruptedException {
        if (pts1.isEmpty() && pts2.isEmpty()) {
            return SSAMapMerger.MergeResult.trivial(PointerTargetSet.emptyPointerTargetSet(), this.bfmgr);
        }
        Constraints mergeConstraints1 = new Constraints(this.bfmgr);
        Constraints mergeConstraints2 = new Constraints(this.bfmgr);
        PersistentList<Formula> highestAllocatedAddresses1 = pts1.getHighestAllocatedAddresses();
        PersistentList<Formula> highestAllocatedAddresses2 = pts2.getHighestAllocatedAddresses();
        final CopyOnWriteSortedMap basesOnlyPts1 = CopyOnWriteSortedMap.copyOf((PersistentSortedMap)PathCopyingPersistentTreeMap.of());
        final CopyOnWriteSortedMap basesOnlyPts2 = CopyOnWriteSortedMap.copyOf((PersistentSortedMap)PathCopyingPersistentTreeMap.of());
        PersistentSortedMap mergedBases = PersistentSortedMaps.merge(pts1.getBases(), pts2.getBases(), (Equivalence)Equivalence.equals(), (PersistentSortedMaps.MergeConflictHandler)BaseUnitingConflictHandler.INSTANCE, (MapsDifference.Visitor)new MapsDifference.DefaultVisitor<String, CType>(){

            public void leftValueOnly(String pKey, CType pLeftValue) {
                basesOnlyPts1.put((Object)pKey, (Object)pLeftValue);
            }

            public void rightValueOnly(String pKey, CType pRightValue) {
                basesOnlyPts2.put((Object)pKey, (Object)pRightValue);
            }

            public void differingValues(String pKey, CType pLeftValue, CType pRightValue) {
                if (PointerTargetSetManager.isFakeBaseType(pLeftValue) && !(pRightValue instanceof CElaboratedType)) {
                    basesOnlyPts2.put((Object)pKey, (Object)pRightValue);
                } else if (PointerTargetSetManager.isFakeBaseType(pRightValue) && !(pLeftValue instanceof CElaboratedType)) {
                    basesOnlyPts1.put((Object)pKey, (Object)pLeftValue);
                }
            }
        });
        this.shutdownNotifier.shutdownIfNecessary();
        highestAllocatedAddresses2 = this.makeBaseAddressConstraintsForMergedBases((Map<String, CType>)basesOnlyPts1.getSnapshot(), pts2.getBases().keySet(), highestAllocatedAddresses2, mergeConstraints2);
        highestAllocatedAddresses1 = this.makeBaseAddressConstraintsForMergedBases((Map<String, CType>)basesOnlyPts2.getSnapshot(), pts1.getBases().keySet(), highestAllocatedAddresses1, mergeConstraints1);
        final CopyOnWriteSortedMap fieldsOnlyPts1 = CopyOnWriteSortedMap.copyOf((PersistentSortedMap)PathCopyingPersistentTreeMap.of());
        final CopyOnWriteSortedMap fieldsOnlyPts2 = CopyOnWriteSortedMap.copyOf((PersistentSortedMap)PathCopyingPersistentTreeMap.of());
        PersistentSortedMap mergedFields = PersistentSortedMaps.merge(pts1.getFields(), pts2.getFields(), (Equivalence)Equivalence.equals(), (PersistentSortedMaps.MergeConflictHandler)PersistentSortedMaps.getExceptionMergeConflictHandler(), (MapsDifference.Visitor)new MapsDifference.DefaultVisitor<CompositeField, Boolean>(){

            public void leftValueOnly(CompositeField pKey, Boolean pLeftValue) {
                fieldsOnlyPts1.put((Object)pKey, (Object)pLeftValue);
            }

            public void rightValueOnly(CompositeField pKey, Boolean pRightValue) {
                fieldsOnlyPts2.put((Object)pKey, (Object)pRightValue);
            }
        });
        this.shutdownNotifier.shutdownIfNecessary();
        PersistentSortedMap<String, PersistentList<PointerTarget>> mergedTargets = PersistentSortedMaps.merge(pts1.getTargets(), pts2.getTargets(), (key, list1, list2) -> PointerTargetSetManager.mergeLists(list1, list2));
        this.shutdownNotifier.shutdownIfNecessary();
        mergedTargets = this.addAllTargets(mergedTargets, (PersistentSortedMap<String, CType>)basesOnlyPts2.getSnapshot(), (PersistentSortedMap<CompositeField, Boolean>)fieldsOnlyPts1.getSnapshot());
        mergedTargets = this.addAllTargets(mergedTargets, (PersistentSortedMap<String, CType>)basesOnlyPts1.getSnapshot(), (PersistentSortedMap<CompositeField, Boolean>)fieldsOnlyPts2.getSnapshot());
        PersistentList<Pair<String, DeferredAllocation>> mergedDeferredAllocations = PointerTargetSetManager.mergeLists(pts1.getDeferredAllocations(), pts2.getDeferredAllocations());
        this.shutdownNotifier.shutdownIfNecessary();
        PersistentList<Formula> highestAllocatedAddresses = PointerTargetSetManager.mergeLists(highestAllocatedAddresses1, highestAllocatedAddresses2);
        int allocationCount = Math.max(pts1.getAllocationCount(), pts2.getAllocationCount());
        PointerTargetSet resultPTS = new PointerTargetSet((PersistentSortedMap<String, CType>)mergedBases, (PersistentSortedMap<CompositeField, Boolean>)mergedFields, mergedDeferredAllocations, mergedTargets, highestAllocatedAddresses, allocationCount);
        ArrayList<CompositeField> sharedFields = new ArrayList<CompositeField>();
        this.makeValueImportConstraints((PersistentSortedMap<String, CType>)basesOnlyPts1.getSnapshot(), sharedFields, ssa, mergeConstraints2);
        this.makeValueImportConstraints((PersistentSortedMap<String, CType>)basesOnlyPts2.getSnapshot(), sharedFields, ssa, mergeConstraints1);
        if (!sharedFields.isEmpty()) {
            PointerTargetSetBuilder.RealPointerTargetSetBuilder resultPTSBuilder = new PointerTargetSetBuilder.RealPointerTargetSetBuilder(resultPTS, this.typeHandler, this, this.options, this.regionMgr);
            for (CompositeField sharedField : sharedFields) {
                resultPTSBuilder.addField(sharedField);
            }
            resultPTS = resultPTSBuilder.build();
        }
        return new SSAMapMerger.MergeResult<PointerTargetSet>(resultPTS, mergeConstraints1.get(), mergeConstraints2.get(), this.bfmgr.makeTrue());
    }

    static <T> PersistentList<T> mergeLists(PersistentList<T> list1, PersistentList<T> list2) {
        PersistentList biggerList;
        PersistentList<T> smallerList;
        int size2;
        if (list1 == list2) {
            return list1;
        }
        int size1 = list1.size();
        if (size1 == (size2 = list2.size()) && list1.equals(list2)) {
            return list1;
        }
        if (size1 > size2) {
            smallerList = list2;
            biggerList = list1;
        } else {
            smallerList = list1;
            biggerList = list2;
        }
        HashSet<T> fromBigger = new HashSet<T>(biggerList);
        PersistentList result = biggerList;
        for (Object target : FluentIterable.from(smallerList).filter(Predicates.not((Predicate)Predicates.in(fromBigger)))) {
            result = result.with(target);
        }
        return result;
    }

    private PersistentList<Formula> makeBaseAddressConstraintsForMergedBases(Map<String, CType> pBases, Set<String> pIgnoredBases, PersistentList<Formula> highestAllocatedAddresses, Constraints pConstraints) {
        for (Map.Entry<String, CType> base : pBases.entrySet()) {
            String baseName = base.getKey();
            if (pIgnoredBases.contains(baseName) || DynamicMemoryHandler.isAllocVariableName(baseName)) continue;
            highestAllocatedAddresses = this.makeBaseAddressConstraints(baseName, base.getValue(), null, highestAllocatedAddresses, pConstraints);
        }
        return highestAllocatedAddresses;
    }

    PersistentList<Formula> makeBaseAddressConstraints(String pNewBase, CType pType, @Nullable Formula pAllocationSize, PersistentList<Formula> pHighestAllocatedAddresses, Constraints pConstraints) {
        if (!this.options.trackFunctionPointers() && CTypes.isFunctionPointer(pType)) {
            return pHighestAllocatedAddresses;
        }
        FormulaType<?> pointerType = this.typeHandler.getPointerType();
        Object newBaseFormula = this.formulaManager.makeVariableWithoutSSAIndex(pointerType, PointerTargetSet.getBaseName(pNewBase));
        if (pHighestAllocatedAddresses.isEmpty()) {
            pConstraints.addConstraint(this.makeGreaterZero((Formula)newBaseFormula));
        } else {
            for (Formula oldAddress : pHighestAllocatedAddresses) {
                pConstraints.addConstraint(this.formulaManager.makeGreaterThan(newBaseFormula, oldAddress, true));
            }
        }
        if (!pType.isIncomplete()) {
            pConstraints.addConstraint(this.formulaManager.makeModularCongruence(newBaseFormula, this.formulaManager.makeNumber(pointerType, 0L), this.typeHandler.getAlignof(pType), false));
        }
        long typeSize = pType.hasKnownConstantSize() ? this.typeHandler.getSizeof(pType) : (long)this.options.defaultAllocationSize();
        Object typeSizeF = this.formulaManager.makeNumber(pointerType, typeSize);
        Object newBasePlusTypeSize = this.formulaManager.makePlus(newBaseFormula, typeSizeF);
        pConstraints.addConstraint(this.makeGreaterZero((Formula)newBasePlusTypeSize));
        PersistentLinkedList highestAllocatedAddresses = PersistentLinkedList.of(newBasePlusTypeSize);
        if (pAllocationSize != null && !pAllocationSize.equals(this.formulaManager.makeNumber(pointerType, typeSize))) {
            Formula basePlusAllocationSize = this.formulaManager.makePlus(newBaseFormula, pAllocationSize);
            pConstraints.addConstraint(this.makeGreaterZero(basePlusAllocationSize));
            highestAllocatedAddresses = highestAllocatedAddresses.with((Object)basePlusAllocationSize);
        }
        return highestAllocatedAddresses;
    }

    private BooleanFormula makeGreaterZero(Formula f) {
        return this.formulaManager.makeGreaterThan(f, this.formulaManager.makeNumber(this.typeHandler.getPointerType(), 0L), true);
    }

    private void makeValueImportConstraints(PersistentSortedMap<String, CType> newBases, List<CompositeField> sharedFields, SSAMap.SSAMapBuilder ssaBuilder, Constraints constraints) {
        for (Map.Entry base : newBases.entrySet()) {
            if (this.options.isDynamicAllocVariableName((String)base.getKey()) || CTypeUtils.containsArrayOutsideFunctionParameter((CType)base.getValue())) continue;
            Formula baseVar = this.conv.makeBaseAddress((String)base.getKey(), (CType)base.getValue());
            this.conv.addValueImportConstraints(baseVar, (String)base.getKey(), (CType)base.getValue(), sharedFields, ssaBuilder, constraints, null);
        }
    }

    @CheckReturnValue
    PersistentSortedMap<String, PersistentList<PointerTarget>> addToTargets(String base, @Nullable MemoryRegion region, CType cType, @Nullable CType containerType, long properOffset, long containerOffset, PersistentSortedMap<String, PersistentList<PointerTarget>> targets, PersistentSortedMap<CompositeField, Boolean> fields) {
        CTypeUtils.checkIsSimplified(cType);
        if (cType instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)cType;
            int length = CTypeUtils.getArrayLength(arrayType, this.options);
            long offset = 0L;
            for (int i = 0; i < length; ++i) {
                targets = this.addToTargets(base, null, arrayType.getType(), arrayType, offset, containerOffset + properOffset, targets, fields);
                offset += this.typeHandler.getSizeof(arrayType.getType());
            }
        } else if (cType instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)cType;
            assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                OptionalLong offset = this.typeHandler.getOffset(compositeType, memberDeclaration);
                if (!offset.isPresent() || !fields.containsKey((Object)CompositeField.of(compositeType, memberDeclaration))) continue;
                MemoryRegion newRegion = this.regionMgr.makeMemoryRegion(compositeType, memberDeclaration);
                targets = this.addToTargets(base, newRegion, memberDeclaration.getType(), compositeType, offset.orElseThrow(), containerOffset + properOffset, targets, fields);
            }
        } else {
            MemoryRegion newRegion = region;
            if (newRegion == null) {
                newRegion = this.regionMgr.makeMemoryRegion(cType);
            }
            String regionName = this.regionMgr.getPointerAccessName(newRegion);
            PersistentList targetsForRegion = (PersistentList)targets.getOrDefault((Object)regionName, (Object)PersistentLinkedList.of());
            targets = targets.putAndCopy((Object)regionName, (Object)targetsForRegion.with((Object)new PointerTarget(base, containerType, properOffset, containerOffset)));
        }
        return targets;
    }

    @CheckReturnValue
    private PersistentSortedMap<String, PersistentList<PointerTarget>> addAllTargets(PersistentSortedMap<String, PersistentList<PointerTarget>> targets, PersistentSortedMap<String, CType> bases, PersistentSortedMap<CompositeField, Boolean> fields) {
        for (Map.Entry entry : bases.entrySet()) {
            String name = (String)entry.getKey();
            CType type = CTypeUtils.checkIsSimplified((CType)entry.getValue());
            targets = this.addToTargets(name, null, type, null, 0L, 0L, targets, fields);
        }
        return targets;
    }

    private static enum BaseUnitingConflictHandler implements PersistentSortedMaps.MergeConflictHandler<String, CType>
    {
        INSTANCE;


        public CType resolveConflict(String key, CType type1, CType type2) {
            if (PointerTargetSetManager.isFakeBaseType(type1) || type1.isIncomplete()) {
                return type2;
            }
            if (PointerTargetSetManager.isFakeBaseType(type2) || type2.isIncomplete()) {
                return type1;
            }
            int currentFieldIndex = 0;
            ImmutableList.Builder membersBuilder = ImmutableList.builder();
            HashSet<CType> seenMembers = new HashSet<CType>();
            if (BaseUnitingConflictHandler.isAlreadyMergedCompositeType(type1)) {
                for (CCompositeType.CCompositeTypeMemberDeclaration innerType : ((CCompositeType)type1).getMembers()) {
                    membersBuilder.add((Object)innerType);
                    seenMembers.add(innerType.getType());
                    ++currentFieldIndex;
                }
            } else {
                membersBuilder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(type1, PointerTargetSetManager.getUnitedFieldBaseName(currentFieldIndex)));
                seenMembers.add(type1);
                ++currentFieldIndex;
            }
            if (BaseUnitingConflictHandler.isAlreadyMergedCompositeType(type2)) {
                for (CCompositeType.CCompositeTypeMemberDeclaration innerType : ((CCompositeType)type2).getMembers()) {
                    if (!seenMembers.add(innerType.getType())) continue;
                    membersBuilder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(innerType.getType(), PointerTargetSetManager.getUnitedFieldBaseName(currentFieldIndex)));
                    ++currentFieldIndex;
                }
            } else if (seenMembers.add(type2)) {
                membersBuilder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(type2, PointerTargetSetManager.getUnitedFieldBaseName(currentFieldIndex)));
            }
            ImmutableList members = membersBuilder.build();
            String varName = PointerTargetSetManager.UNITED_BASE_UNION_TAG_PREFIX + Joiner.on((String)"_and_").join(Iterables.transform((Iterable)members, m -> m.getType().toString().replace(" ", "_")));
            return new CCompositeType(false, false, CComplexType.ComplexTypeKind.UNION, (List<CCompositeType.CCompositeTypeMemberDeclaration>)members, varName, varName);
        }

        private static boolean isAlreadyMergedCompositeType(CType type) {
            if (type instanceof CCompositeType) {
                CCompositeType compositeType = (CCompositeType)type;
                return compositeType.getKind() == CComplexType.ComplexTypeKind.UNION && !compositeType.getMembers().isEmpty() && compositeType.getMembers().get(0).getName().equals(PointerTargetSetManager.getUnitedFieldBaseName(0));
            }
            return false;
        }
    }
}

