/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.truth.TruthJUnit;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeapWithArrays;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeapWithByteArray;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeapWithUninterpretedFunctionCalls;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.java_smt.api.FormulaType;

@RunWith(value=Parameterized.class)
public abstract class SMTHeapBasedTest0
extends SolverViewBasedTest0 {
    protected SMTHeap heap;

    @Before
    public final void initSMTHeap() {
        FormulaType.BitvectorType pointerType = FormulaType.getBitvectorTypeWithSize((int)this.modelToUse().getSizeofPtrInBits());
        switch (this.heapToUse()) {
            case UF: {
                this.heap = new SMTHeapWithUninterpretedFunctionCalls(this.mgrv);
                break;
            }
            case ARRAYS: {
                this.heap = new SMTHeapWithArrays(this.mgrv, (FormulaType<?>)pointerType);
                break;
            }
            case SINGLE_BYTE_ARRAY: {
                this.heap = new SMTHeapWithByteArray(this.mgrv, (FormulaType<?>)pointerType, this.modelToUse());
            }
        }
    }

    protected void requireSingleByteArrayHeap() {
        TruthJUnit.assume().withMessage("SMT Heap %s does not use Single Byte Array", new Object[]{this.heapToUse()}).that((Comparable)((Object)this.heapToUse())).isEqualTo((Object)HeapOptions.SINGLE_BYTE_ARRAY);
    }

    protected void requireArraysHeap() {
        TruthJUnit.assume().withMessage("SMT Heap %s  does not use Arrays", new Object[]{this.heapToUse()}).that((Comparable)((Object)this.heapToUse())).isEqualTo((Object)HeapOptions.ARRAYS);
    }

    protected void requireUFHeap() {
        TruthJUnit.assume().withMessage("SMT Heap %s does not use UF", new Object[]{this.heapToUse()}).that((Comparable)((Object)this.heapToUse())).isEqualTo((Object)HeapOptions.UF);
    }

    protected abstract HeapOptions heapToUse();

    protected abstract MachineModel modelToUse();

    protected static enum HeapOptions {
        UF,
        SINGLE_BYTE_ARRAY,
        ARRAYS;

    }
}

