/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.collect.Lists;
import com.google.common.truth.TruthJUnit;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeapBasedTest0;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.SolverException;

@Ignore
@RunWith(value=Parameterized.class)
public class SMTHeapReadAndWriteTest
extends SMTHeapBasedTest0 {
    private static final String TEST_TARGET_PRE = "testTarget";
    private static final String TEST_VAR_NAME_PRE = "var";
    private static final int TEST_ADDRESS = 1234;
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverUnderTest;
    @Parameterized.Parameter(value=1)
    public MachineModel model;
    @Parameterized.Parameter(value=2)
    public SMTHeapBasedTest0.HeapOptions heapToUse;
    private int index;

    @Parameterized.Parameters(name="smtSolver= {0}, machineModel={1}, heapEncoding={2}")
    public static List<Object[]> data() {
        return Lists.transform((List)Lists.cartesianProduct((List[])new List[]{Arrays.asList(SolverContextFactory.Solvers.values()), Arrays.asList(MachineModel.values()), Arrays.asList(SMTHeapBasedTest0.HeapOptions.values())}), List::toArray);
    }

    @Before
    public void init() {
        this.requireBitvectors();
        this.requireArrays();
        TruthJUnit.assume().withMessage("Solver %s does not support arrays of bitvectors", new Object[]{this.solverToUse()}).that((Comparable)this.solverToUse()).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.index = 0;
    }

    @Test
    public void test1BitVector() throws InterruptedException, SolverException {
        this.testWrittenValueIsEquisatisfiableToReadValue(1, 1L);
    }

    @Test
    public void test3BitVector() throws InterruptedException, SolverException {
        this.testWrittenValueIsEquisatisfiableToReadValue(3, 5L);
    }

    @Test
    public void test8BitVector() throws InterruptedException, SolverException {
        this.testWrittenValueIsEquisatisfiableToReadValue(8, 17L);
    }

    @Test
    public void test16BitVector() throws InterruptedException, SolverException {
        this.testWrittenValueIsEquisatisfiableToReadValue(16, 4386L);
    }

    @Test
    public void test32BitVector() throws InterruptedException, SolverException {
        this.testWrittenValueIsEquisatisfiableToReadValue(32, 0x112233L);
    }

    @Test
    public void test64BitVector() throws InterruptedException, SolverException {
        this.testWrittenValueIsEquisatisfiableToReadValue(64, 1234605616436508552L);
    }

    @Test
    public void testMixedBitVectors() throws InterruptedException, SolverException {
        this.testWrittenValueIsEquisatisfiableToReadValue(8, 17L);
        this.testWrittenValueIsEquisatisfiableToReadValue(16, 4386L);
        this.testWrittenValueIsEquisatisfiableToReadValue(32, 0x112233L);
        this.testWrittenValueIsEquisatisfiableToReadValue(64, 1234605616436508552L);
    }

    @Test
    public void testReadPrefix() throws InterruptedException, SolverException {
        this.requireSingleByteArrayHeap();
        BooleanFormula wroteArrayFormula = this.storeBitVector(this.bvmgr.makeBitvector(8, 37L));
        BooleanFormula readResultFormula = this.readBitVector(3);
        BooleanFormula atom = this.mgrv.assignment(this.bvmgr.makeVariable(3, "var3"), this.bvmgr.makeBitvector(3, 5L));
        this.assertThatFormula(this.bmgr.and(wroteArrayFormula, readResultFormula)).isEquisatisfiableTo(atom);
    }

    @Test
    public void testOverwritePrefix() throws InterruptedException, SolverException {
        this.requireSingleByteArrayHeap();
        BooleanFormula wroteArrayFormula = this.storeBitVector(this.bvmgr.makeBitvector(8, 169L));
        BooleanFormula wroteArrayFormula2 = this.storeBitVector(this.bvmgr.makeBitvector(4, 6L));
        BooleanFormula readResultFormula = this.readBitVector(8);
        BooleanFormula atom = this.mgrv.assignment(this.bvmgr.makeVariable(8, "var8"), this.bvmgr.makeBitvector(8, 166L));
        this.assertThatFormula(this.bmgr.and(new BooleanFormula[]{wroteArrayFormula, wroteArrayFormula2, readResultFormula})).isEquisatisfiableTo(atom);
    }

    private void testWrittenValueIsEquisatisfiableToReadValue(int length, long pValue) throws SolverException, InterruptedException {
        BitvectorFormula value = this.bvmgr.makeBitvector(length, pValue);
        BooleanFormula atom = this.mgrv.assignment(this.bvmgr.makeVariable(length, TEST_VAR_NAME_PRE + length), value);
        BooleanFormula wroteArrayFormula = this.storeBitVector(value);
        BooleanFormula readResultFormula = this.readBitVector(length);
        this.assertThatFormula(this.bmgr.and(wroteArrayFormula, readResultFormula)).isEquisatisfiableTo(atom);
    }

    private BooleanFormula storeBitVector(BitvectorFormula value) {
        int length = this.bvmgr.getLength(value);
        String targetName = this.getHeapSymbolName(length);
        FormulaType.BitvectorType pTargetType = FormulaType.getBitvectorTypeWithSize((int)length);
        BitvectorFormula address = this.bvmgr.makeBitvector(this.model.getSizeofPtrInBits(), 1234L);
        return this.heap.makePointerAssignment(targetName, (FormulaType<?>)pTargetType, this.index, ++this.index, address, value);
    }

    private BooleanFormula readBitVector(int length) {
        String targetName = this.getHeapSymbolName(length);
        FormulaType.BitvectorType pTargetType = FormulaType.getBitvectorTypeWithSize((int)length);
        BitvectorFormula address = this.bvmgr.makeBitvector(this.model.getSizeofPtrInBits(), 1234L);
        BitvectorFormula valueFormula = (BitvectorFormula)this.heap.makePointerDereference(targetName, pTargetType, this.index, address);
        return this.mgrv.assignment(this.bvmgr.makeVariable(length, TEST_VAR_NAME_PRE + length), valueFormula);
    }

    private String getHeapSymbolName(int length) {
        switch (this.heapToUse) {
            case SINGLE_BYTE_ARRAY: {
                return TEST_TARGET_PRE + this.model.getSizeofPtrInBits();
            }
            case ARRAYS: 
            case UF: {
                return TEST_TARGET_PRE + this.model.getSizeofPtrInBits() + "_" + length;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected SMTHeapBasedTest0.HeapOptions heapToUse() {
        return this.heapToUse;
    }

    @Override
    protected MachineModel modelToUse() {
        return this.model;
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverUnderTest;
    }
}

