/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeap;
import org.sosy_lab.cpachecker.util.predicates.smt.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;

class SMTHeapWithArrays
implements SMTHeap {
    private final ArrayFormulaManagerView afmgr;
    private final FormulaManagerView formulaManager;
    private final FormulaType<?> pointerType;

    SMTHeapWithArrays(FormulaManagerView pFormulaManager, FormulaType<?> pPointerType) {
        this.formulaManager = pFormulaManager;
        this.afmgr = this.formulaManager.getArrayFormulaManager();
        this.pointerType = pPointerType;
    }

    @Override
    public <I extends Formula, E extends Formula> BooleanFormula makePointerAssignment(String targetName, FormulaType<?> pTargetType, int oldIndex, int newIndex, I address, E value) {
        FormulaType<E> targetType = this.formulaManager.getFormulaType(value);
        Preconditions.checkArgument((boolean)pTargetType.equals(targetType));
        FormulaType<I> addressType = this.formulaManager.getFormulaType(address);
        Preconditions.checkArgument((boolean)this.pointerType.equals(addressType));
        ArrayFormula oldFormula = this.afmgr.makeArray(targetName, oldIndex, addressType, targetType);
        ArrayFormula arrayFormula = this.afmgr.makeArray(targetName, newIndex, addressType, targetType);
        return this.formulaManager.makeEqual(arrayFormula, this.afmgr.store(oldFormula, address, value));
    }

    @Override
    public <I extends Formula, E extends Formula> E makePointerDereference(String targetName, FormulaType<E> targetType, I address) {
        FormulaType<I> addressType = this.formulaManager.getFormulaType(address);
        Preconditions.checkArgument((boolean)this.pointerType.equals(addressType));
        ArrayFormula arrayFormula = this.afmgr.makeArray(targetName, addressType, targetType);
        return (E)this.afmgr.select(arrayFormula, address);
    }

    @Override
    public <I extends Formula, V extends Formula> V makePointerDereference(String targetName, FormulaType<V> targetType, int ssaIndex, I address) {
        FormulaType<I> addressType = this.formulaManager.getFormulaType(address);
        Preconditions.checkArgument((boolean)this.pointerType.equals(addressType));
        ArrayFormula arrayFormula = this.afmgr.makeArray(targetName, ssaIndex, addressType, targetType);
        return (V)this.afmgr.select(arrayFormula, address);
    }
}

