/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteOrder;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeap;
import org.sosy_lab.cpachecker.util.predicates.smt.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FloatingPointFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;

class SMTHeapWithByteArray
implements SMTHeap {
    private static final FormulaType.BitvectorType BYTE_TYPE = FormulaType.getBitvectorTypeWithSize((int)8);
    private final ArrayFormulaManagerView afmgr;
    private final FormulaManagerView formulaManager;
    private final BitvectorFormulaManager bfmgr;
    private final FormulaType<?> pointerType;
    private final ByteOrder endianness;

    SMTHeapWithByteArray(FormulaManagerView pFormulaManager, FormulaType<?> pPointerType, MachineModel pModel) {
        this.formulaManager = pFormulaManager;
        this.afmgr = this.formulaManager.getArrayFormulaManager();
        this.pointerType = pPointerType;
        this.endianness = pModel.getEndianness();
        this.bfmgr = this.formulaManager.getBitvectorFormulaManager();
    }

    @Override
    public <I extends Formula, E extends Formula> BooleanFormula makePointerAssignment(String targetName, FormulaType<?> pTargetType, int oldIndex, int newIndex, I address, E value) {
        if (pTargetType.isFloatingPointType()) {
            FormulaType.FloatingPointType floatTargetType = (FormulaType.FloatingPointType)pTargetType;
            FormulaType.BitvectorType bvType = FormulaType.getBitvectorTypeWithSize((int)floatTargetType.getTotalSize());
            FloatingPointFormulaManagerView floatMgr = this.formulaManager.getFloatingPointFormulaManager();
            BitvectorFormula bvValue = floatMgr.toIeeeBitvector((FloatingPointFormula)value);
            return this.makePointerAssignment(targetName, (FormulaType<?>)bvType, oldIndex, newIndex, address, (E)bvValue);
        }
        if (pTargetType.isBitvectorType()) {
            FormulaType.BitvectorType targetType = (FormulaType.BitvectorType)this.formulaManager.getFormulaType(value);
            Preconditions.checkArgument((boolean)pTargetType.equals((Object)targetType));
            FormulaType<I> addressType = this.formulaManager.getFormulaType(address);
            Preconditions.checkArgument((boolean)this.pointerType.equals(addressType));
            return this.handleBitvectorAssignment(targetName, oldIndex, newIndex, address, addressType, (BitvectorFormula)value);
        }
        throw new UnsupportedOperationException("ByteArray Heap encoding does not support " + pTargetType);
    }

    @Override
    public <I extends Formula, E extends Formula> E makePointerDereference(String targetName, FormulaType<E> targetType, I address) {
        if (targetType.isFloatingPointType()) {
            FormulaType.FloatingPointType floatType = (FormulaType.FloatingPointType)targetType;
            FormulaType.BitvectorType bvType = FormulaType.getBitvectorTypeWithSize((int)floatType.getTotalSize());
            BitvectorFormula bvFormula = (BitvectorFormula)this.makePointerDereference(targetName, (FormulaType<E>)bvType, address);
            FloatingPointFormulaManagerView floatMgr = this.formulaManager.getFloatingPointFormulaManager();
            FloatingPointFormula floatFormula = floatMgr.fromIeeeBitvector(bvFormula, floatType);
            return (E)floatFormula;
        }
        if (targetType.isBitvectorType()) {
            FormulaType<I> addressType = this.formulaManager.getFormulaType(address);
            Preconditions.checkArgument((boolean)this.pointerType.equals(addressType));
            FormulaType.BitvectorType bvTargetType = (FormulaType.BitvectorType)targetType;
            ArrayFormula arrayFormula = this.afmgr.makeArray(targetName, addressType, BYTE_TYPE);
            BitvectorFormula returnVal = this.handleBitvectorDeref(arrayFormula, address, addressType, bvTargetType);
            return (E)returnVal;
        }
        throw new UnsupportedOperationException("ByteArray Heap encoding does not support " + targetType);
    }

    @Override
    public <I extends Formula, V extends Formula> V makePointerDereference(String targetName, FormulaType<V> targetType, int ssaIndex, I address) {
        if (targetType.isFloatingPointType()) {
            FormulaType.FloatingPointType floatType = (FormulaType.FloatingPointType)targetType;
            FormulaType.BitvectorType bvType = FormulaType.getBitvectorTypeWithSize((int)floatType.getTotalSize());
            BitvectorFormula bvFormula = (BitvectorFormula)this.makePointerDereference(targetName, (FormulaType<V>)bvType, ssaIndex, address);
            FloatingPointFormulaManagerView floatMgr = this.formulaManager.getFloatingPointFormulaManager();
            FloatingPointFormula floatFormula = floatMgr.fromIeeeBitvector(bvFormula, floatType);
            return (V)floatFormula;
        }
        if (targetType.isBitvectorType()) {
            FormulaType<I> addressType = this.formulaManager.getFormulaType(address);
            Preconditions.checkArgument((boolean)this.pointerType.equals(addressType));
            FormulaType.BitvectorType bvTargetType = (FormulaType.BitvectorType)targetType;
            ArrayFormula arrayFormula = this.afmgr.makeArray(targetName, ssaIndex, addressType, BYTE_TYPE);
            BitvectorFormula returnVal = this.handleBitvectorDeref(arrayFormula, address, addressType, bvTargetType);
            return (V)returnVal;
        }
        throw new UnsupportedOperationException("ByteArray Heap encoding does not support " + targetType);
    }

    private <I extends Formula> BitvectorFormula handleBitvectorDeref(ArrayFormula<I, BitvectorFormula> arrayFormula, I address, FormulaType<I> addressType, FormulaType.BitvectorType targetType) {
        int bitLength = targetType.getSize();
        BitvectorFormula result = this.afmgr.select(arrayFormula, address);
        if (bitLength < 8) {
            return this.bfmgr.extract(result, bitLength - 1, 0);
        }
        if (bitLength == 8) {
            return result;
        }
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (String)"Bitvector size %s is not a multiple of 8!", (int)bitLength);
        for (int byteOffset = 1; byteOffset < bitLength / 8; ++byteOffset) {
            I addressWithOffset = this.formulaManager.makePlus(address, this.formulaManager.makeNumber(addressType, byteOffset));
            BitvectorFormula nextBVPart = this.afmgr.select(arrayFormula, addressWithOffset);
            result = this.endianness == ByteOrder.BIG_ENDIAN ? this.bfmgr.concat(result, nextBVPart) : this.bfmgr.concat(nextBVPart, result);
        }
        return result;
    }

    private <I extends Formula> BooleanFormula handleBitvectorAssignment(String targetName, int oldIndex, int newIndex, I address, FormulaType<I> addressType, BitvectorFormula value) {
        ImmutableList bytes;
        Object oldFormula = this.afmgr.makeArray(targetName, oldIndex, addressType, BYTE_TYPE);
        int bitLength = this.bfmgr.getLength(value);
        if (bitLength < 8) {
            BitvectorFormula remainingBits = this.bfmgr.extract((BitvectorFormula)this.afmgr.select(oldFormula, address), 7, bitLength);
            bytes = ImmutableList.of((Object)this.bfmgr.concat(remainingBits, value));
        } else {
            bytes = bitLength == 8 ? ImmutableList.of((Object)value) : this.splitBitvectorToBytes(value);
        }
        int byteOffset = 0;
        for (BitvectorFormula formula : bytes) {
            I addressWithOffset = this.formulaManager.makePlus(address, this.formulaManager.makeNumber(addressType, byteOffset++));
            oldFormula = this.afmgr.store(oldFormula, addressWithOffset, formula);
        }
        ArrayFormula arrayFormula = this.afmgr.makeArray(targetName, newIndex, addressType, BYTE_TYPE);
        return this.formulaManager.makeEqual(arrayFormula, oldFormula);
    }

    private <I extends BitvectorFormula> ImmutableList<BitvectorFormula> splitBitvectorToBytes(I bitvector) {
        int bitLength = this.bfmgr.getLength(bitvector);
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (String)"Bitvector size %s is not a multiple of 8!", (int)bitLength);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int bitOffset = 0; bitOffset < bitLength; bitOffset += 8) {
            builder.add((Object)this.bfmgr.extract(bitvector, bitOffset + 7, bitOffset));
        }
        return this.endianness == ByteOrder.BIG_ENDIAN ? builder.build().reverse() : builder.build();
    }
}

