/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.SMTHeap;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FunctionFormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;

class SMTHeapWithUninterpretedFunctionCalls
implements SMTHeap {
    private final FunctionFormulaManagerView ffmgr;
    private final FormulaManagerView formulaManager;

    SMTHeapWithUninterpretedFunctionCalls(FormulaManagerView pFormulaManager) {
        this.formulaManager = pFormulaManager;
        this.ffmgr = this.formulaManager.getFunctionFormulaManager();
    }

    @Override
    public <I extends Formula, E extends Formula> BooleanFormula makePointerAssignment(String targetName, FormulaType<?> pTargetType, int oldIndex, int newIndex, I address, E value) {
        FormulaType<E> targetType = this.formulaManager.getFormulaType(value);
        Preconditions.checkArgument((boolean)pTargetType.equals(targetType));
        E lhs = this.ffmgr.declareAndCallUninterpretedFunction(targetName, newIndex, targetType, address);
        return this.formulaManager.assignment(lhs, value);
    }

    @Override
    public <I extends Formula, E extends Formula> E makePointerDereference(String targetName, FormulaType<E> targetType, I address) {
        return this.ffmgr.declareAndCallUF(targetName, targetType, address);
    }

    @Override
    public <I extends Formula, V extends Formula> V makePointerDereference(String targetName, FormulaType<V> targetType, int ssaIndex, I address) {
        return this.ffmgr.declareAndCallUninterpretedFunction(targetName, ssaIndex, targetType, address);
    }
}

