/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CachingCanonizingCTypeVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;

public class TypeHandlerWithPointerAliasing
extends CtoFormulaTypeHandler {
    private static final String POINTER_NAME_PREFIX = "*";
    private static final String BYTE_ARRAY_HEAP_ACCESS_NAME = "*SINGLE_BYTE_ARRAY";
    private final MachineModel model;
    private final FormulaEncodingWithPointerAliasingOptions options;
    private final CachingCanonizingCTypeVisitor canonizingVisitor = new CachingCanonizingCTypeVisitor(true, true, false);
    private final CachingCanonizingCTypeVisitor canonizingVisitorWithoutSignedness = new CachingCanonizingCTypeVisitor(true, true, true);
    private final IdentityHashMap<CType, String> pointerNameCache = new IdentityHashMap();
    private final Map<CCompositeType, Long> sizes = new HashMap<CCompositeType, Long>();

    public TypeHandlerWithPointerAliasing(LogManager pLogger, MachineModel pMachineModel, FormulaEncodingWithPointerAliasingOptions pOptions) {
        super(pLogger, pMachineModel);
        this.model = pMachineModel;
        this.options = pOptions;
    }

    public static boolean isByteArrayAccessName(String pName) {
        return BYTE_ARRAY_HEAP_ACCESS_NAME.equals(pName);
    }

    @Override
    public long getSizeof(CType cType) {
        if ((cType = this.simplifyType(cType)) instanceof CCompositeType) {
            return this.sizes.computeIfAbsent((CCompositeType)cType, this::getSizeofUncached);
        }
        return this.getSizeofUncached(cType);
    }

    private long getSizeofUncached(CType cType) {
        if (cType instanceof CArrayType && !cType.hasKnownConstantSize()) {
            CArrayType t = (CArrayType)cType;
            int length = t.getLengthAsInt().orElse(this.options.defaultArrayLength());
            long sizeOfType = this.getSizeofUncached(t.getType());
            return (long)length * sizeOfType;
        }
        return this.model.getSizeof(cType).longValueExact();
    }

    public int getAlignof(CType type) {
        return this.model.getAlignof(type);
    }

    CType simplifyType(CType type) {
        return type.accept(this.canonizingVisitor);
    }

    public CType getSimplifiedType(CRightHandSide exp) {
        return this.simplifyType(exp.getExpressionType());
    }

    CType getSimplifiedType(CSimpleDeclaration decl) {
        return this.simplifyType(decl.getType());
    }

    CType getSimplifiedType(CCompositeType.CCompositeTypeMemberDeclaration field) {
        return this.simplifyType(field.getType());
    }

    CType simplifyTypeForPointerAccess(CType type) {
        return type.accept(this.canonizingVisitorWithoutSignedness);
    }

    static boolean isPointerAccessSymbol(String symbol) {
        return symbol.startsWith(POINTER_NAME_PREFIX);
    }

    public String getPointerAccessNameForType(CType type) {
        Object result = this.pointerNameCache.get(type);
        if (result != null) {
            return result;
        }
        result = this.options.useByteArrayForHeap() ? BYTE_ARRAY_HEAP_ACCESS_NAME : POINTER_NAME_PREFIX + this.simplifyTypeForPointerAccess(type).toString().replace(' ', '_');
        this.pointerNameCache.put(type, (String)result);
        return result;
    }
}

