/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;

final class Variable {
    private final String name;
    private final CType type;

    private Variable(String pName, CType pType) {
        this.name = pName;
        this.type = pType;
    }

    String getName() {
        return this.name;
    }

    CType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.type.toASTString(this.name);
    }

    static Variable create(String pName, CType pT) {
        CTypeUtils.checkIsSimplified(pT);
        return new Variable((String)Preconditions.checkNotNull((Object)pName), (CType)Preconditions.checkNotNull((Object)pT));
    }
}

