/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.precisionConverter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.Converter;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.SymbolEncoding;
import org.sosy_lab.java_smt.api.FormulaType;

public class BVConverter
extends Converter {
    private final Map<String, String> unaryOps;
    private final Map<String, Pair<String, String>> binOps;
    private final Map<String, Pair<String, String>> arithmeticOps;
    private final Set<String> ignorableFunctions = Sets.newHashSet((Object[])new String[]{"to_int", "to_real"});

    public BVConverter(CFA pCfa, LogManager pLogger) {
        super(pLogger, pCfa);
        this.unaryOps = new HashMap<String, String>();
        this.unaryOps.put("-", "bvneg");
        this.unaryOps.put("not", "not");
        this.unaryOps.put("_~_", "bvnot");
        this.binOps = new HashMap<String, Pair<String, String>>();
        this.binOps.put("=", Pair.of("=", "="));
        this.binOps.put("<", Pair.of("bvslt", "bvult"));
        this.binOps.put("<=", Pair.of("bvsle", "bvule"));
        this.binOps.put(">", Pair.of("bvsgt", "bvugt"));
        this.binOps.put(">=", Pair.of("bvsge", "bvuge"));
        this.arithmeticOps = new HashMap<String, Pair<String, String>>();
        this.arithmeticOps.put("+", Pair.of("bvadd", "bvadd"));
        this.arithmeticOps.put("-", Pair.of("bvsub", "bvsub"));
        this.arithmeticOps.put("*", Pair.of("bvmul", "bvmul"));
        this.arithmeticOps.put("/", Pair.of("bvsdiv", "bvudiv"));
        this.arithmeticOps.put("%", Pair.of("bvsrem", "bvurem"));
        this.arithmeticOps.put("Integer__*_", Pair.of("bvmul", "bvmul"));
        this.arithmeticOps.put("Integer__/_", Pair.of("bvsdiv", "bvudiv"));
        this.arithmeticOps.put("Integer__%_", Pair.of("bvsrem", "bvurem"));
        this.arithmeticOps.put("Rational__*_", Pair.of("bvmul", "bvmul"));
        this.arithmeticOps.put("Rational__/_", Pair.of("bvsdiv", "bvudiv"));
        this.arithmeticOps.put("Rational__%_", Pair.of("bvsrem)", "bvurem"));
        this.arithmeticOps.put("_&_", Pair.of("bvand", "bvand"));
        this.arithmeticOps.put("_!!_", Pair.of("bvor", "bvor"));
        this.arithmeticOps.put("_^_", Pair.of("bvxor", "bvxor"));
        this.arithmeticOps.put("_<<_", Pair.of("bvshl", "bvshl"));
        this.arithmeticOps.put("_>>_", Pair.of("bvlshr", "bvashr"));
    }

    private String unescapeSymbol(String symbol) {
        if (symbol.startsWith("|") && symbol.endsWith("|")) {
            return symbol.substring(1, symbol.length() - 1);
        }
        return symbol;
    }

    private SymbolEncoding.Type<FormulaType<?>> getType(String symbol) throws SymbolEncoding.UnknownFormulaSymbolException {
        symbol = this.unescapeSymbol(symbol);
        return this.symbolEncoding.getType(symbol);
    }

    private Integer getBVsize(FormulaType<?> t) {
        if (t.isBitvectorType()) {
            return ((FormulaType.BitvectorType)t).getSize();
        }
        throw new AssertionError((Object)("unhandled type: " + t));
    }

    private boolean isOperationSigned(SymbolEncoding.Type<FormulaType<?>> t1, SymbolEncoding.Type<FormulaType<?>> t2) {
        if (t1.getReturnType().isBitvectorType() && t2.getReturnType().isBitvectorType()) {
            int s2;
            int s1 = this.getBVsize(t1.getReturnType());
            if (s1 < (s2 = this.getBVsize(t2.getReturnType()).intValue())) {
                return t2.isSigned();
            }
            if (s1 > s2) {
                return t1.isSigned();
            }
            return t1.isSigned() && t2.isSigned();
        }
        return false;
    }

    private String getSMTType(FormulaType<?> t) {
        if (t == FormulaType.BooleanType) {
            return "Bool";
        }
        if (t == FormulaType.IntegerType) {
            return "Int";
        }
        if (t.isBitvectorType()) {
            return String.format("(_ BitVec %d)", ((FormulaType.BitvectorType)t).getSize());
        }
        throw new AssertionError((Object)("unhandled type: " + t));
    }

    @Override
    public String convertFunctionDeclaration(String symbol, SymbolEncoding.Type<String> type) throws SymbolEncoding.UnknownFormulaSymbolException {
        FormulaType.BitvectorType retType;
        SymbolEncoding.Type<FormulaType<?>> t = this.getType((String)symbol);
        ArrayList<String> lst = new ArrayList<String>();
        if (t == null) {
            boolean defaultBitsize = true;
            String ignorePrefix = "_CPAchecker_ignored_symbol_";
            this.logger.log(Level.SEVERE, new Object[]{"ignoring unknown function symbol '" + (String)symbol + "'"});
            for (String i : type.getParameterTypes()) {
                lst.add(this.getSMTType((FormulaType<?>)FormulaType.getBitvectorTypeWithSize((int)1)));
            }
            retType = FormulaType.getBitvectorTypeWithSize((int)1);
            symbol = "_CPAchecker_ignored_symbol_" + (String)symbol;
        } else {
            for (FormulaType<?> i : t.getParameterTypes()) {
                lst.add(this.getSMTType(i));
            }
            retType = t.getReturnType();
        }
        return String.format("%s (%s) %s", symbol, Joiner.on((String)" ").join(lst), this.getSMTType((FormulaType<?>)retType));
    }

    @Override
    public String convertFunctionDefinition(String symbol, SymbolEncoding.Type<String> type, @Nullable Pair<String, SymbolEncoding.Type<FormulaType<?>>> initializerTerm) throws SymbolEncoding.UnknownFormulaSymbolException {
        assert (!this.symbolEncoding.containsSymbol(symbol)) : "function re-defined";
        assert (type.getParameterTypes().isEmpty()) : "tmp-function with complex type";
        this.symbolEncoding.put(symbol, (SymbolEncoding.Type)Preconditions.checkNotNull(initializerTerm.getSecond()));
        return String.format("%s (%s) %s %s", symbol, Joiner.on((char)' ').join(type.getParameterTypes()), this.getSMTType(this.getType(symbol).getReturnType()), initializerTerm.getFirst());
    }

    private String cast(String term, @Nullable Integer availableBitsize, int neededBitsize) {
        if (term.matches("(\\(_\\sbv\\d+\\s\\d+\\))")) {
            List splitted = Splitter.on((char)' ').splitToList((CharSequence)term);
            BigInteger num = new BigInteger(((String)splitted.get(1)).substring(2));
            assert (num.bitLength() <= neededBitsize) : String.format("numeral %s does not fit into bitvector of length %d", num, neededBitsize);
            return this.getNumber(num, neededBitsize);
        }
        String casted = availableBitsize == null ? term : (availableBitsize < neededBitsize ? String.format("((_ sign_extend %d) %s)", neededBitsize - availableBitsize, term) : (availableBitsize > neededBitsize ? String.format("((_ extract %d %d) %s)", neededBitsize, 0, term) : term));
        return casted;
    }

    @Override
    public Pair<String, SymbolEncoding.Type<FormulaType<?>>> convertNumeral(String num) {
        BigInteger n = new BigInteger(num);
        int bitsize = Math.max(1, n.bitLength());
        return Pair.of(this.getNumber(n, bitsize), new SymbolEncoding.Type<FormulaType.BitvectorType>(FormulaType.getBitvectorTypeWithSize((int)bitsize)));
    }

    private String getNumber(BigInteger num, int bitsize) {
        assert (num.compareTo(BigInteger.ZERO) >= 0) : "Negative numbers should be written with an unary minus.";
        return String.format("(_ bv%s %d)", num, bitsize);
    }

    @Override
    public Pair<String, SymbolEncoding.Type<FormulaType<?>>> convertSymbol(String symbol) throws SymbolEncoding.UnknownFormulaSymbolException {
        return Pair.of(symbol, this.getType(symbol));
    }

    @Override
    public Pair<String, SymbolEncoding.Type<FormulaType<?>>> convertTerm(Pair<String, SymbolEncoding.Type<FormulaType<?>>> op, List<Pair<String, SymbolEncoding.Type<FormulaType<?>>>> terms) {
        if (terms.isEmpty()) {
            return Pair.of(String.format("(%s)", op.getFirst()), op.getSecond());
        }
        if (terms.size() == 1 && op.getFirst().startsWith("(_ divisible")) {
            assert (op.getSecond() == null) : "type of MODULO should be unknown.";
            int N = Integer.parseInt(((String)Splitter.on((char)' ').splitToList((CharSequence)op.getFirst()).get(3)).substring(2));
            int bitsize = this.getBVsize((FormulaType)((SymbolEncoding.Type)((Pair)Iterables.getOnlyElement(terms)).getSecond()).getReturnType());
            return Pair.of(String.format("(= (_ bv0 %d) (bvsrem %s (_ bv%d %d)))", bitsize, ((Pair)Iterables.getOnlyElement(terms)).getFirst(), N, bitsize), new SymbolEncoding.Type<FormulaType.BitvectorType>(FormulaType.getBitvectorTypeWithSize((int)bitsize)));
        }
        if (terms.size() == 1 && "__string__".equals(op.getFirst())) {
            int n = Integer.parseInt(((String)Splitter.on((char)' ').splitToList((CharSequence)terms.get(0).getFirst()).get(1)).substring(2));
            return Pair.of(String.format("(__string__ %d)", n), new SymbolEncoding.Type(op.getSecond().getReturnType()));
        }
        if (terms.size() == 1 && this.unaryOps.containsKey(op.getFirst())) {
            return Pair.of(String.format("(%s %s)", this.unaryOps.get(op.getFirst()), Joiner.on((char)' ').join((Iterable)Lists.transform(terms, Pair::getFirst))), (SymbolEncoding.Type)((Pair)Iterables.getOnlyElement(terms)).getSecond());
        }
        if (terms.size() == 1 && this.ignorableFunctions.contains(op.getFirst())) {
            return (Pair)Iterables.getOnlyElement(terms);
        }
        if (terms.size() == 2 && (this.binOps.containsKey(op.getFirst()) || this.arithmeticOps.containsKey(op.getFirst()))) {
            SymbolEncoding.Type<FormulaType> type;
            Pair<String, String> operator;
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> e1 = terms.get(0);
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> e2 = terms.get(1);
            SymbolEncoding.Type<FormulaType<?>> t1 = e1.getSecond();
            SymbolEncoding.Type<FormulaType<?>> t2 = e2.getSecond();
            int s1 = this.getBVsize(t1.getReturnType());
            int s2 = this.getBVsize(t2.getReturnType());
            int commonBitsize = Math.max(s1, s2);
            boolean isOpSigned = this.isOperationSigned(t1, t2);
            if (this.binOps.containsKey(op.getFirst())) {
                operator = this.binOps.get(op.getFirst());
                type = new SymbolEncoding.Type<FormulaType>(FormulaType.BooleanType);
            } else {
                operator = this.arithmeticOps.get(op.getFirst());
                type = new SymbolEncoding.Type<FormulaType.BitvectorType>(FormulaType.getBitvectorTypeWithSize((int)commonBitsize));
                type.setSigness(isOpSigned);
            }
            return Pair.of(String.format("(%s %s %s)", isOpSigned ? operator.getFirst() : operator.getSecond(), this.cast(e1.getFirst(), s1, commonBitsize), this.cast(e2.getFirst(), s2, commonBitsize)), type);
        }
        if (terms.size() == 3 && "ite".equals(op.getFirst())) {
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> cond = terms.get(0);
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> eIf = terms.get(1);
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> eElse = terms.get(2);
            if (FormulaType.BooleanType.equals(eIf.getSecond().getReturnType())) {
                return Pair.of(String.format("(ite %s %s %s)", cond.getFirst(), eIf.getFirst(), eElse.getFirst()), new SymbolEncoding.Type<FormulaType>(FormulaType.BooleanType));
            }
            int sIf = this.getBVsize(eIf.getSecond().getReturnType());
            int sElse = this.getBVsize(eElse.getSecond().getReturnType());
            int commonBitsize = Math.max(sIf, sElse);
            boolean isOpSigned = this.isOperationSigned(eIf.getSecond(), eElse.getSecond());
            SymbolEncoding.Type<FormulaType.BitvectorType> type = new SymbolEncoding.Type<FormulaType.BitvectorType>(FormulaType.getBitvectorTypeWithSize((int)commonBitsize));
            type.setSigness(isOpSigned);
            return Pair.of(String.format("(ite %s %s %s)", cond.getFirst(), this.cast(eIf.getFirst(), sIf, commonBitsize), this.cast(eElse.getFirst(), sElse, commonBitsize)), type);
        }
        if (this.binBooleanOps.contains(op.getFirst())) {
            return Pair.of(String.format("(%s %s)", op.getFirst(), Joiner.on((char)' ').join((Iterable)Lists.transform(terms, Pair::getFirst))), new SymbolEncoding.Type<FormulaType>(FormulaType.BooleanType));
        }
        if (this.symbolEncoding.containsSymbol(op.getFirst())) {
            assert (op.getSecond().getParameterTypes().size() == terms.size());
            ArrayList<String> params = new ArrayList<String>();
            for (int i = 0; i < terms.size(); ++i) {
                params.add(this.cast(terms.get(i).getFirst(), this.getBVsize(terms.get(i).getSecond().getReturnType()), this.getBVsize(op.getSecond().getParameterTypes().get(i))));
            }
            return Pair.of(String.format("(%s %s)", op.getFirst(), Joiner.on((char)' ').join(params)), op.getSecond());
        }
        if (!"_".equals(op.getFirst()) || !"divisible".equals(terms.get(0).getFirst())) {
            this.logger.log(Level.SEVERE, new Object[]{"unhandled term:", op, terms});
        }
        return Pair.of(String.format("(%s %s)", op.getFirst(), Joiner.on((char)' ').join((Iterable)Lists.transform(terms, Pair::getFirst))), op.getSecond());
    }
}

