/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.precisionConverter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.BVConverter;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.IntConverter;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.SymbolEncoding;
import org.sosy_lab.java_smt.api.FormulaType;

public class Converter {
    protected final Set<String> binBooleanOps = Sets.newHashSet((Object[])new String[]{"and", "or"});
    protected final SymbolEncoding symbolEncoding;
    protected final LogManager logger;

    public Converter(LogManager logger, CFA cfa) {
        this.symbolEncoding = new SymbolEncoding(cfa);
        this.logger = logger;
    }

    @VisibleForTesting
    public Converter() {
        this.symbolEncoding = null;
        this.logger = null;
    }

    public String convertFunctionDeclaration(String symbol, SymbolEncoding.Type<String> pFt) throws SymbolEncoding.UnknownFormulaSymbolException {
        return String.format("%s (%s) %s", symbol, Joiner.on((char)' ').join(pFt.getParameterTypes()), pFt.getReturnType());
    }

    public String convertFunctionDefinition(String symbol, SymbolEncoding.Type<String> type, Pair<String, SymbolEncoding.Type<FormulaType<?>>> initializerTerm) throws SymbolEncoding.UnknownFormulaSymbolException {
        return String.format("%s (%s) %s %s", symbol, Joiner.on((char)' ').join(type.getParameterTypes()), type.getReturnType(), initializerTerm.getFirst());
    }

    public Pair<String, SymbolEncoding.Type<FormulaType<?>>> convertNumeral(String num) {
        return Converter.wrap(num);
    }

    public Pair<String, SymbolEncoding.Type<FormulaType<?>>> convertSymbol(String symbol) throws SymbolEncoding.UnknownFormulaSymbolException {
        return Converter.wrap(symbol);
    }

    public Pair<String, SymbolEncoding.Type<FormulaType<?>>> convertTerm(Pair<String, SymbolEncoding.Type<FormulaType<?>>> op, List<Pair<String, SymbolEncoding.Type<FormulaType<?>>>> terms) throws SymbolEncoding.UnknownFormulaSymbolException {
        if (terms.isEmpty()) {
            return Converter.wrap("(" + op.getFirst() + ")");
        }
        return Converter.wrap("(" + op.getFirst() + " " + Joiner.on((char)' ').join((Iterable)Lists.transform(terms, Pair::getFirst)) + ")");
    }

    private static Pair<String, SymbolEncoding.Type<FormulaType<?>>> wrap(String s) {
        return Pair.of(s, new SymbolEncoding.Type<FormulaType.BitvectorType>(FormulaType.getBitvectorTypeWithSize((int)0)));
    }

    public static Converter getConverter(PrecisionConverter encodePredicates, CFA cfa, LogManager logger) {
        switch (encodePredicates) {
            case INT2BV: {
                return new BVConverter(cfa, logger);
            }
            case BV2INT: {
                return new IntConverter(cfa, logger);
            }
            case DISABLE: {
                return null;
            }
        }
        throw new AssertionError((Object)"invalid value for option");
    }

    public static enum PrecisionConverter {
        DISABLE,
        INT2BV,
        BV2INT;

    }
}

