/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.precisionConverter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.Converter;
import org.sosy_lab.cpachecker.util.predicates.precisionConverter.SymbolEncoding;
import org.sosy_lab.java_smt.api.FormulaType;

public class IntConverter
extends Converter {
    private final Map<String, String> unaryOps;
    private final Map<String, String> binOps;
    private final Map<String, String> arithmeticOps;
    private final Set<String> ignorableFunctions = new HashSet<String>();

    public IntConverter(CFA pCfa, LogManager pLogger) {
        super(pLogger, pCfa);
        this.unaryOps = new HashMap<String, String>();
        this.unaryOps.put("bvneg", "-");
        this.unaryOps.put("not", "not");
        this.unaryOps.put("bvnot", "_~_");
        this.binOps = new HashMap<String, String>();
        this.binOps.put("=", "=");
        this.binOps.put("bvslt", "<");
        this.binOps.put("bvult", "<");
        this.binOps.put("bvsle", "<=");
        this.binOps.put("bvule", "<=");
        this.binOps.put("bvsgt", ">");
        this.binOps.put("bvugt", ">");
        this.binOps.put("bvsge", ">=");
        this.binOps.put("bvuge", ">=");
        this.arithmeticOps = new HashMap<String, String>();
        this.arithmeticOps.put("bvadd", "+");
        this.arithmeticOps.put("bvsub", "-");
        this.arithmeticOps.put("bvmul", "Integer__*_");
        this.arithmeticOps.put("bvsdiv", "Integer__/_");
        this.arithmeticOps.put("bvudiv", "Integer__/_");
        this.arithmeticOps.put("bvsrem", "Integer__%_");
        this.arithmeticOps.put("bvurem", "Integer__%_");
        this.arithmeticOps.put("bvand", "_&_");
        this.arithmeticOps.put("bvor", "_!!_");
        this.arithmeticOps.put("bvxor", "_^_");
        this.arithmeticOps.put("bvshl", "_<<_");
        this.arithmeticOps.put("bvlshr", "_>>_");
        this.arithmeticOps.put("bvashr", "_>>_");
    }

    private String unescapeSymbol(String symbol) {
        if (symbol.startsWith("|") && symbol.endsWith("|")) {
            return symbol.substring(1, symbol.length() - 1);
        }
        return symbol;
    }

    private SymbolEncoding.Type<FormulaType<?>> getType(String symbol) throws SymbolEncoding.UnknownFormulaSymbolException {
        symbol = this.unescapeSymbol(symbol);
        return this.symbolEncoding.getType(symbol);
    }

    private String getSMTType(FormulaType<?> t) {
        if (t == FormulaType.BooleanType) {
            return "Bool";
        }
        if (t == FormulaType.IntegerType) {
            return "Int";
        }
        if (t.isBitvectorType()) {
            return "Int";
        }
        throw new AssertionError((Object)("unhandled type: " + t));
    }

    @Override
    public String convertFunctionDeclaration(String symbol, SymbolEncoding.Type<String> type) throws SymbolEncoding.UnknownFormulaSymbolException {
        FormulaType retType;
        SymbolEncoding.Type<FormulaType<?>> t = this.getType((String)symbol);
        ArrayList<String> lst = new ArrayList<String>();
        if (t == null) {
            String ignorePrefix = "_CPAchecker_ignored_symbol_";
            this.logger.log(Level.SEVERE, new Object[]{"ignoring unknown function symbol '" + (String)symbol + "'"});
            for (String i : type.getParameterTypes()) {
                lst.add(this.getSMTType(FormulaType.IntegerType));
            }
            retType = FormulaType.IntegerType;
            symbol = "_CPAchecker_ignored_symbol_" + (String)symbol;
        } else {
            for (FormulaType<?> i : t.getParameterTypes()) {
                lst.add(this.getSMTType(i));
            }
            retType = t.getReturnType();
        }
        return String.format("%s (%s) %s", symbol, Joiner.on((String)" ").join(lst), this.getSMTType(retType));
    }

    @Override
    public String convertFunctionDefinition(String symbol, SymbolEncoding.Type<String> type, @Nullable Pair<String, SymbolEncoding.Type<FormulaType<?>>> initializerTerm) throws SymbolEncoding.UnknownFormulaSymbolException {
        assert (!this.symbolEncoding.containsSymbol(symbol)) : "function re-defined";
        assert (type.getParameterTypes().isEmpty()) : "tmp-function with complex type";
        this.symbolEncoding.put(symbol, (SymbolEncoding.Type)Preconditions.checkNotNull(initializerTerm.getSecond(), initializerTerm));
        return String.format("%s (%s) %s %s", symbol, Joiner.on((char)' ').join(type.getParameterTypes()), this.getSMTType(this.getType(symbol).getReturnType()), initializerTerm.getFirst());
    }

    @Override
    public Pair<String, SymbolEncoding.Type<FormulaType<?>>> convertNumeral(String num) {
        return Pair.of(num, new SymbolEncoding.Type<FormulaType>(FormulaType.IntegerType));
    }

    @Override
    public Pair<String, SymbolEncoding.Type<FormulaType<?>>> convertSymbol(String symbol) throws SymbolEncoding.UnknownFormulaSymbolException {
        return Pair.of(symbol, this.getType(symbol));
    }

    @Override
    public Pair<String, SymbolEncoding.Type<FormulaType<?>>> convertTerm(Pair<String, SymbolEncoding.Type<FormulaType<?>>> op, List<Pair<String, SymbolEncoding.Type<FormulaType<?>>>> terms) {
        if (terms.isEmpty()) {
            return Pair.of(String.format("(%s)", op.getFirst()), op.getSecond());
        }
        if (terms.size() == 1 && (op.getFirst().startsWith("(_ extract ") || op.getFirst().startsWith("(_ zero_extend ") || op.getFirst().startsWith("(_ sign_extend "))) {
            assert (op.getSecond() == null) : "type of EXTRACT/EXTEND should be unknown.";
            return (Pair)Iterables.getOnlyElement(terms);
        }
        if (terms.size() == 2 && op.getFirst().equals("_") && terms.get(0).getFirst().startsWith("bv")) {
            assert (op.getSecond() == null) : "type of BV-NUMBER should be unknown.";
            return Pair.of(terms.get(0).getFirst().substring(2), new SymbolEncoding.Type<FormulaType>(FormulaType.IntegerType));
        }
        if (terms.size() == 1 && this.unaryOps.containsKey(op.getFirst())) {
            return Pair.of(String.format("(%s %s)", this.unaryOps.get(op.getFirst()), Joiner.on((char)' ').join((Iterable)Lists.transform(terms, Pair::getFirst))), (SymbolEncoding.Type)((Pair)Iterables.getOnlyElement(terms)).getSecond());
        }
        if (terms.size() == 1 && this.ignorableFunctions.contains(op.getFirst())) {
            return (Pair)Iterables.getOnlyElement(terms);
        }
        if (terms.size() == 2 && (this.binOps.containsKey(op.getFirst()) || this.arithmeticOps.containsKey(op.getFirst()))) {
            SymbolEncoding.Type<FormulaType> type;
            String operator;
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> e1 = terms.get(0);
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> e2 = terms.get(1);
            if (this.binOps.containsKey(op.getFirst())) {
                operator = this.binOps.get(op.getFirst());
                type = new SymbolEncoding.Type<FormulaType>(FormulaType.BooleanType);
            } else {
                operator = this.arithmeticOps.get(op.getFirst());
                type = new SymbolEncoding.Type<FormulaType>(FormulaType.IntegerType);
            }
            return Pair.of(String.format("(%s %s %s)", operator, e1.getFirst(), e2.getFirst()), type);
        }
        if (terms.size() == 3 && "ite".equals(op.getFirst())) {
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> cond = terms.get(0);
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> eIf = terms.get(1);
            Pair<String, SymbolEncoding.Type<FormulaType<?>>> eElse = terms.get(2);
            FormulaType type = FormulaType.BooleanType.equals(eIf.getSecond().getReturnType()) ? FormulaType.BooleanType : FormulaType.IntegerType;
            return Pair.of(String.format("(ite %s %s %s)", cond.getFirst(), eIf.getFirst(), eElse.getFirst()), new SymbolEncoding.Type<FormulaType>(type));
        }
        if (this.binBooleanOps.contains(op.getFirst())) {
            return Pair.of(String.format("(%s %s)", op.getFirst(), Joiner.on((char)' ').join((Iterable)Lists.transform(terms, Pair::getFirst))), new SymbolEncoding.Type<FormulaType>(FormulaType.BooleanType));
        }
        if (this.symbolEncoding.containsSymbol(op.getFirst())) {
            assert (op.getSecond().getParameterTypes().size() == terms.size());
            ArrayList<String> params = new ArrayList<String>();
            for (Pair<String, SymbolEncoding.Type<FormulaType<?>>> term : terms) {
                params.add(term.getFirst());
            }
            return Pair.of(String.format("(%s %s)", op.getFirst(), Joiner.on((char)' ').join(params)), op.getSecond());
        }
        if (!"_".equals(op.getFirst())) {
            this.logger.log(Level.SEVERE, new Object[]{"unhandled term:", op, terms});
        }
        return Pair.of(String.format("(%s %s)", op.getFirst(), Joiner.on((char)' ').join((Iterable)Lists.transform(terms, Pair::getFirst))), op.getSecond());
    }
}

