/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.precisionConverter;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.FormulaType;

public class SymbolEncoding {
    private Set<CSimpleDeclaration> decls = new HashSet<CSimpleDeclaration>();
    private MachineModel machineModel = null;
    private static final Set<String> functionSymbols = Sets.newHashSet((Object[])new String[]{"and", "or", "not", "ite", "=", "<", ">", "<=", ">=", "+", "-", "*", "/", "Integer__*_", "Integer__/_", "Integer__%_", "Rational__*_", "Rational__/_", "Rational__%_", "_~_", "_&_", "_!!_", "_^_", "_<<_", "_>>_", "bvnot", "bvslt", "bvult", "bvsle", "bvule", "bvsgt", "bvugt", "bvsge", "bvuge", "bvadd", "bvsub", "bvmul", "bvsdiv", "bvudiv", "bvsrem", "bvurem", "bvand", "bvor", "bvxor", "bvshl", "bvlshr", "bvashr", "to_real", "to_int", "_", "divisible"});
    private final Map<String, Type<FormulaType<?>>> encodedSymbols = new HashMap();

    public SymbolEncoding() {
    }

    public SymbolEncoding(CFA pCfa) {
        this.decls = this.getAllDeclarations(pCfa.getAllNodes());
        this.machineModel = pCfa.getMachineModel();
        this.encodedSymbols.put("true", new Type<FormulaType>(FormulaType.BooleanType));
        this.encodedSymbols.put("false", new Type<FormulaType>(FormulaType.BooleanType));
    }

    public void put(String symbol, int length) {
        this.put(symbol, new Type<FormulaType.BitvectorType>(FormulaType.getBitvectorTypeWithSize((int)length)));
    }

    public void put(String symbol, FormulaType<?> pReturnType, ImmutableList<FormulaType<?>> pArgs) {
        this.put(symbol, new Type(pReturnType, pArgs));
    }

    public void put(String symbol, Type<FormulaType<?>> t) {
        if (this.encodedSymbols.containsKey(symbol)) {
            assert (this.encodedSymbols.get(symbol).equals(t)) : String.format("Symbol '%s' of type '%s' is already declared with the type '%s'.", symbol, t, this.encodedSymbols.get(symbol));
        } else {
            this.encodedSymbols.put(symbol, t);
        }
    }

    public boolean containsSymbol(String symbol) {
        return this.encodedSymbols.containsKey(symbol);
    }

    public Type<FormulaType<?>> getType(String symbol) throws UnknownFormulaSymbolException {
        if (functionSymbols.contains(symbol)) {
            return null;
        }
        if (this.encodedSymbols.containsKey(symbol)) {
            return this.encodedSymbols.get(symbol);
        }
        symbol = FormulaManagerView.parseName(symbol).getFirst();
        for (CSimpleDeclaration decl : this.decls) {
            if (!symbol.equals(decl.getQualifiedName())) continue;
            CType cType = decl.getType().getCanonicalType();
            return this.getType(cType);
        }
        throw new UnknownFormulaSymbolException(symbol);
    }

    private Type<FormulaType<?>> getType(CType cType) {
        FormulaType fType;
        if (cType instanceof CSimpleType && ((CSimpleType)cType).getType().isFloatingPointType()) {
            fType = FormulaType.RationalType;
        } else {
            int length = this.machineModel.getSizeofInBits(cType).intValueExact();
            fType = FormulaType.getBitvectorTypeWithSize((int)length);
        }
        Type type = new Type(fType);
        if (cType instanceof CSimpleType) {
            type.setSigness(!((CSimpleType)cType).isUnsigned());
        }
        return type;
    }

    private Set<CSimpleDeclaration> getAllDeclarations(Collection<CFANode> nodes) {
        HashSet<CSimpleDeclaration> sd = new HashSet<CSimpleDeclaration>();
        for (CFANode node : nodes) {
            Optional<CVariableDeclaration> retVar;
            if (node instanceof CFunctionEntryNode && (retVar = ((CFunctionEntryNode)node).getReturnVariable()).isPresent()) {
                sd.add(retVar.get());
            }
            FluentIterable<CFAEdge> edges = CFAUtils.allLeavingEdges(node);
            for (AbstractCFAEdge edge : edges.filter(CDeclarationEdge.class)) {
                sd.add(((CDeclarationEdge)edge).getDeclaration());
            }
            for (AbstractCFAEdge edge : edges.filter(CFunctionCallEdge.class)) {
                List<CParameterDeclaration> params = ((CFunctionCallEdge)edge).getSuccessor().getFunctionParameters();
                sd.addAll(params);
            }
            for (AbstractCFAEdge edge : edges.filter(CFunctionReturnEdge.class)) {
                Optional<CVariableDeclaration> retVar2 = ((CFunctionReturnEdge)edge).getFunctionEntry().getReturnVariable();
                if (!retVar2.isPresent()) continue;
                sd.add(retVar2.get());
            }
        }
        return sd;
    }

    public void dump(Path symbolEncodingFile) throws IOException {
        if (symbolEncodingFile != null) {
            IO.writeFile((Path)symbolEncodingFile, (Charset)Charset.defaultCharset(), (Object)new Appender(){

                public void appendTo(Appendable app) throws IOException {
                    for (Map.Entry<String, Type<FormulaType<?>>> entry : SymbolEncoding.this.encodedSymbols.entrySet()) {
                        String symbol = entry.getKey();
                        Type<FormulaType<?>> type = entry.getValue();
                        app.append(symbol + "\t" + type.getReturnType());
                        if (!type.getParameterTypes().isEmpty()) {
                            app.append("\t" + Joiner.on((String)"\t").join(type.getParameterTypes()));
                        }
                        app.append("\n");
                    }
                }
            });
        }
    }

    public static class UnknownFormulaSymbolException
    extends CPAException {
        private static final long serialVersionUID = 150615L;

        public UnknownFormulaSymbolException(String symbol) {
            super("unknown symbol in formula: " + symbol);
        }
    }

    public static class Type<T> {
        private boolean signed = true;
        private final T returnType;
        private final ImmutableList<T> parameterTypes;

        public Type(T pReturnType, ImmutableList<T> pParameterTypes) {
            this.returnType = pReturnType;
            this.parameterTypes = pParameterTypes;
        }

        public Type(T pReturnType) {
            this.returnType = pReturnType;
            this.parameterTypes = ImmutableList.of();
        }

        public T getReturnType() {
            return this.returnType;
        }

        public List<T> getParameterTypes() {
            return this.parameterTypes;
        }

        public void setSigness(boolean pSigned) {
            this.signed = pSigned;
        }

        public boolean isSigned() {
            return this.signed;
        }

        public String toString() {
            return this.returnType + " " + this.parameterTypes;
        }

        public boolean equals(Object other) {
            if (other instanceof Type) {
                Type t = (Type)other;
                return this.returnType.equals(t.returnType) && this.parameterTypes.equals(t.parameterTypes);
            }
            return false;
        }

        public int hashCode() {
            return this.returnType.hashCode() + 17 * this.parameterTypes.hashCode();
        }
    }
}

