/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pseudoQE;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

class PseudoExistFormula {
    private final Map<String, Formula> quantifiedVars;
    private final BooleanFormula quantifiedFormula;
    private final List<BooleanFormula> conjunctsWithoutQuantifiedVars;
    private final List<BooleanFormula> conjunctsWithQuantifiedVars;

    PseudoExistFormula(Map<String, Formula> pQuantifiedVars, BooleanFormula pQuantifiedFormula, FormulaManagerView pFmgr) {
        this.quantifiedVars = ImmutableMap.copyOf(pQuantifiedVars);
        this.quantifiedFormula = pQuantifiedFormula;
        ArrayList<BooleanFormula> tmpWithoutQuantifiedVars = new ArrayList<BooleanFormula>();
        ArrayList<BooleanFormula> tmpWithQuantifiedVars = new ArrayList<BooleanFormula>();
        for (BooleanFormula conjunct : pFmgr.getBooleanFormulaManager().toConjunctionArgs(this.quantifiedFormula, true)) {
            if (Sets.intersection(pFmgr.extractVariableNames((Formula)conjunct), this.quantifiedVars.keySet()).isEmpty()) {
                tmpWithoutQuantifiedVars.add(conjunct);
                continue;
            }
            tmpWithQuantifiedVars.add(conjunct);
        }
        this.conjunctsWithoutQuantifiedVars = ImmutableList.copyOf(tmpWithoutQuantifiedVars);
        this.conjunctsWithQuantifiedVars = ImmutableList.copyOf(tmpWithQuantifiedVars);
    }

    Map<String, Formula> getQuantifiedVars() {
        return this.quantifiedVars;
    }

    Collection<Formula> getQuantifiedVarFormulas() {
        return this.quantifiedVars.values();
    }

    BooleanFormula getInnerFormula() {
        return this.quantifiedFormula;
    }

    boolean hasQuantifiers() {
        return !this.quantifiedVars.isEmpty();
    }

    int getNumberOfQuantifiers() {
        return this.quantifiedVars.size();
    }

    List<BooleanFormula> getConjunctsWithoutQuantifiedVars() {
        return this.conjunctsWithoutQuantifiedVars;
    }

    List<BooleanFormula> getConjunctsWithQuantifiedVars() {
        return this.conjunctsWithQuantifiedVars;
    }

    public String toString() {
        return String.format("EXISTS %s : %s", this.quantifiedVars, this.quantifiedFormula);
    }
}

