/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pseudoQE;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.predicates.pseudoQE.PseudoExistFormula;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

@Options(prefix="cpa.predicate.pseudoExistQE")
public class PseudoExistQeManager
implements StatisticsProvider {
    private final Solver solver;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bFmgr;
    private Optional<QuantifiedFormulaManager> qFmgr;
    private final LogManager logger;
    private final PseudoExQeStatistics stats = new PseudoExQeStatistics();
    @Option(secure=true, description="Use Destructive Equality Resolution as simplification method")
    private boolean useDER = true;
    @Option(secure=true, description="Use Unconnected Parameter Drop as simplification method")
    private boolean useUPD = true;
    @Option(secure=true, description="Which solver tactic to use for Quantifier Elimination(Only used if useRealQuantifierElimination=true)")
    private SolverQeTactic solverQeTactic = SolverQeTactic.LIGHT;
    @Option(secure=true, description="Specify whether to overapproximate quantified formula, if one or more quantifiers couldn't be eliminated.(Otherwise an exception will be thrown)")
    private boolean overapprox = false;

    public PseudoExistQeManager(Solver pSolver, Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this, PseudoExistQeManager.class);
        this.solver = pSolver;
        this.fmgr = pSolver.getFormulaManager();
        this.bFmgr = this.fmgr.getBooleanFormulaManager();
        this.logger = pLogger;
        try {
            this.qFmgr = Optional.of(this.fmgr.getQuantifiedFormulaManager());
        }
        catch (UnsupportedOperationException e) {
            this.qFmgr = Optional.empty();
            this.logger.log(Level.WARNING, new Object[]{"The selected SMT-Solver does not support Quantifier Elimination, but Solver-based QE is enabled. Switched solverQeTactic configuration option to NONE."});
            this.solverQeTactic = SolverQeTactic.NONE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<BooleanFormula> eliminateQuantifiers(Map<String, Formula> pQuantifiedVars, BooleanFormula pQuantifiedFormula) throws InterruptedException {
        this.stats.qeTimer.start();
        try {
            this.stats.qeTotalCounter += pQuantifiedVars.size();
            PseudoExistFormula existFormula = new PseudoExistFormula(pQuantifiedVars, pQuantifiedFormula, this.fmgr);
            int quantifierCountLastIteration = Integer.MAX_VALUE;
            while (quantifierCountLastIteration > existFormula.getNumberOfQuantifiers() && existFormula.hasQuantifiers()) {
                quantifierCountLastIteration = existFormula.getNumberOfQuantifiers();
                if (this.useDER && existFormula.hasQuantifiers()) {
                    existFormula = this.applyDER(existFormula);
                }
                if (!this.useUPD || !existFormula.hasQuantifiers()) continue;
                existFormula = this.applyUPD(existFormula);
            }
            if (this.solverQeTactic != SolverQeTactic.NONE && existFormula.hasQuantifiers()) {
                existFormula = this.applyRealQuantifierElimination(existFormula);
            }
            int numberOfEliminatedVariables = pQuantifiedVars.size() - existFormula.getNumberOfQuantifiers();
            this.stats.qeSuccessCounter += numberOfEliminatedVariables;
            if (numberOfEliminatedVariables < 1) {
                if (this.overapprox) {
                    this.logger.logf(Level.FINE, "Successfully eliminated %d quantified variable(s), overapproximated formulas containing remaining %d quantified variable(s).", new Object[]{numberOfEliminatedVariables, existFormula.getNumberOfQuantifiers()});
                    Optional<BooleanFormula> optional = Optional.of(this.overapproximateFormula(existFormula));
                    return optional;
                }
                Optional<BooleanFormula> optional = Optional.empty();
                return optional;
            }
            this.logger.log(Level.FINE, new Object[]{"Sucessfully eliminated all quantified Variables."});
            Optional<BooleanFormula> optional = Optional.of(existFormula.getInnerFormula());
            return optional;
        }
        finally {
            this.stats.qeTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PseudoExistFormula applyDER(PseudoExistFormula pExistFormula) throws InterruptedException {
        this.stats.derTimer.start();
        try {
            BooleanFormula conjunct;
            ImmutableSet boundVars = ImmutableSet.copyOf(pExistFormula.getQuantifiedVarFormulas());
            EqualityExtractor visitor = new EqualityExtractor((Set<Formula>)boundVars);
            Map potentialReplacement = null;
            Object object = pExistFormula.getConjunctsWithQuantifiedVars().iterator();
            while (object.hasNext() && (potentialReplacement = (Map)this.fmgr.visit((Formula)(conjunct = object.next()), visitor)) == null) {
            }
            if (potentialReplacement != null) {
                assert (potentialReplacement.size() == 1);
                BooleanFormula newFormula = this.fmgr.substitute(pExistFormula.getInnerFormula(), potentialReplacement);
                Formula replacedVar = (Formula)Iterables.getOnlyElement(potentialReplacement.keySet());
                newFormula = this.fmgr.simplify(newFormula);
                this.logger.log(Level.FINER, new Object[]{"Successfully applied DER to eliminate 1 quantified variable."});
                ++this.stats.derSucessCounter;
                PseudoExistFormula pseudoExistFormula = new PseudoExistFormula(Maps.filterValues(pExistFormula.getQuantifiedVars(), e -> !replacedVar.equals(e)), newFormula, this.fmgr);
                return pseudoExistFormula;
            }
            object = pExistFormula;
            return object;
        }
        finally {
            this.stats.derTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PseudoExistFormula applyUPD(PseudoExistFormula pExistFormula) throws InterruptedException {
        this.stats.updTimer.start();
        try {
            Object object;
            List<BooleanFormula> conjuncts_with_bound = pExistFormula.getConjunctsWithQuantifiedVars();
            ArrayList<BooleanFormula> conjuncts_to_eliminate = new ArrayList<BooleanFormula>();
            Map<String, Object> boundVarsToElim = new LinkedHashMap<String, Formula>(pExistFormula.getQuantifiedVars());
            for (Object conjunct : conjuncts_with_bound) {
                Sets.SetView boundVarNames;
                Set<String> varNames = this.fmgr.extractVariableNames((Formula)conjunct);
                if (varNames.equals(boundVarNames = Sets.intersection(varNames, boundVarsToElim.keySet()))) {
                    conjuncts_to_eliminate.add((BooleanFormula)conjunct);
                    continue;
                }
                boundVarsToElim = Maps.filterKeys(boundVarsToElim, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)boundVarNames)));
            }
            if (!boundVarsToElim.isEmpty()) {
                try {
                    if (this.solver.isUnsat(this.bFmgr.and(conjuncts_to_eliminate))) {
                        object = pExistFormula;
                        return object;
                    }
                }
                catch (SolverException e) {
                    Object conjunct;
                    this.logger.log(Level.WARNING, new Object[]{"Solver failed while proving satisfiability of unconnected conjuncts. Ignore UPD-result."});
                    conjunct = pExistFormula;
                    return conjunct;
                }
                BooleanFormula newFormula = this.bFmgr.and(this.bFmgr.and(pExistFormula.getConjunctsWithoutQuantifiedVars()), this.bFmgr.and((Collection)FluentIterable.from(conjuncts_with_bound).filter(Predicates.not((Predicate)Predicates.in(conjuncts_to_eliminate))).toList()));
                Map newBoundVars = Maps.filterKeys(pExistFormula.getQuantifiedVars(), (Predicate)Predicates.not((Predicate)Predicates.in(boundVarsToElim.keySet())));
                this.logger.log(Level.FINER, new Object[]{"Successfully applied UPD to eliminate " + (pExistFormula.getNumberOfQuantifiers() - newBoundVars.size()) + "quantified variable(s)."});
                this.stats.updSucessCounter += pExistFormula.getNumberOfQuantifiers() - newBoundVars.size();
                PseudoExistFormula pseudoExistFormula = new PseudoExistFormula(newBoundVars, newFormula, this.fmgr);
                return pseudoExistFormula;
            }
            object = pExistFormula;
            return object;
        }
        finally {
            this.stats.updTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PseudoExistFormula applyRealQuantifierElimination(PseudoExistFormula pExistFormula) throws InterruptedException {
        this.stats.solverQETimer.start();
        try {
            int numberQuantifiers;
            BooleanFormula quantifiedFormula;
            assert (this.qFmgr.isPresent());
            BooleanFormula afterQE = quantifiedFormula = this.qFmgr.orElseThrow().exists(new ArrayList<Formula>(pExistFormula.getQuantifiedVarFormulas()), pExistFormula.getInnerFormula());
            if (this.solverQeTactic == SolverQeTactic.LIGHT || this.solverQeTactic == SolverQeTactic.FULL) {
                afterQE = this.fmgr.applyTactic(quantifiedFormula, Tactic.QE_LIGHT);
            }
            if (this.solverQeTactic == SolverQeTactic.FULL) {
                try {
                    afterQE = this.qFmgr.orElseThrow().eliminateQuantifiers(quantifiedFormula);
                }
                catch (SolverException e) {
                    this.logger.log(Level.FINER, new Object[]{"Solver based Quantifier Elimination failed with SolverException!", e});
                }
            }
            if ((numberQuantifiers = this.numberQuantifiers(afterQE)) < pExistFormula.getNumberOfQuantifiers()) {
                PseudoExistFormula result;
                if (numberQuantifiers == 0) {
                    result = new PseudoExistFormula((Map<String, Formula>)ImmutableMap.of(), afterQE, this.fmgr);
                    this.logger.log(Level.FINER, new Object[]{"Successfully applied Solver-QE to eliminate " + pExistFormula.getNumberOfQuantifiers() + "quantified variable(s)."});
                    this.stats.solverQeSucessCounter += pExistFormula.getNumberOfQuantifiers();
                } else {
                    result = pExistFormula;
                }
                if (this.isQuantified(result.getInnerFormula())) {
                    result = pExistFormula;
                }
                PseudoExistFormula pseudoExistFormula = result;
                return pseudoExistFormula;
            }
            PseudoExistFormula pseudoExistFormula = pExistFormula;
            return pseudoExistFormula;
        }
        finally {
            this.stats.solverQETimer.stop();
        }
    }

    BooleanFormula overapproximateFormula(PseudoExistFormula pExistFormula) {
        return this.bFmgr.and(pExistFormula.getConjunctsWithoutQuantifiedVars());
    }

    int numberQuantifiers(BooleanFormula pAfterQE) {
        Integer numberQuantifiers = (Integer)this.fmgr.visit((Formula)pAfterQE, new DefaultFormulaVisitor<Integer>(){

            protected Integer visitDefault(Formula pF) {
                return 0;
            }

            public Integer visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQ, List<Formula> pBoundVariables, BooleanFormula pBody) {
                assert (!pBoundVariables.isEmpty());
                return pBoundVariables.size();
            }
        });
        return numberQuantifiers;
    }

    boolean isQuantified(BooleanFormula pAfterQE) {
        final AtomicBoolean foundQuantifier = new AtomicBoolean();
        this.fmgr.visitRecursively((Formula)pAfterQE, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            protected TraversalProcess visitDefault(Formula pF) {
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQ, List<Formula> pBoundVariables, BooleanFormula pBody) {
                foundQuantifier.set(true);
                return TraversalProcess.ABORT;
            }
        });
        return foundQuantifier.get();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private class PseudoExQeStatistics
    implements Statistics {
        private int qeTotalCounter = 0;
        private int qeSuccessCounter = 0;
        private int derSucessCounter = 0;
        private int updSucessCounter = 0;
        private int solverQeSucessCounter = 0;
        private final Timer qeTimer = new Timer();
        private final Timer derTimer = new Timer();
        private final Timer updTimer = new Timer();
        private final Timer solverQETimer = new Timer();

        private PseudoExQeStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            pOut.println("Number of QEs                 : " + this.qeTotalCounter);
            if (this.qeTotalCounter > 0) {
                pOut.println("Successful QEs              : " + this.qeSuccessCounter);
                pOut.println("Time spent QE               : " + this.qeTimer);
                if (PseudoExistQeManager.this.useDER) {
                    pOut.println("  Sucessful DER             : " + this.derSucessCounter);
                    pOut.println("  Time spent DER            : " + this.derTimer);
                }
                if (PseudoExistQeManager.this.useUPD) {
                    pOut.println("  Sucessful UPD             : " + this.updSucessCounter);
                    pOut.println("  Time spent UPD            : " + this.updTimer);
                }
                if (PseudoExistQeManager.this.solverQeTactic != SolverQeTactic.NONE) {
                    pOut.println("  Sucessful Solver Based QEs: " + this.solverQeSucessCounter);
                    pOut.println("  Time spent Solver Based QE: " + this.solverQETimer);
                }
            }
        }

        @Override
        public @Nullable String getName() {
            return "Quantifier Elimination";
        }
    }

    static enum SolverQeTactic {
        NONE,
        LIGHT,
        FULL;

    }

    private static final class EqualityExtractor
    extends DefaultFormulaVisitor<Map<Formula, Formula>> {
        private final Set<Formula> boundVars;

        private EqualityExtractor(Set<Formula> pBoundVars) {
            this.boundVars = pBoundVars;
        }

        protected Map<Formula, Formula> visitDefault(Formula pF) {
            return null;
        }

        public Map<Formula, Formula> visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            switch (pFunctionDeclaration.getKind()) {
                case EQ: 
                case BV_EQ: 
                case FP_EQ: {
                    if (this.boundVars.contains(pArgs.get(0))) {
                        return ImmutableMap.of((Object)pArgs.get(0), (Object)pArgs.get(1));
                    }
                    if (this.boundVars.contains(pArgs.get(1))) {
                        return ImmutableMap.of((Object)pArgs.get(1), (Object)pArgs.get(0));
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

