/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pseudoQE;

import com.google.common.truth.Truth;
import java.util.HashMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.predicates.pseudoQE.PseudoExistFormula;
import org.sosy_lab.cpachecker.util.predicates.pseudoQE.PseudoExistQeManager;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;

@RunWith(value=Parameterized.class)
public class PseudoExistQeManagerTest
extends SolverViewBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverUnderTest;
    private PseudoExistQeManager pQEmgr;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getTestSolvers() {
        return new Object[]{SolverContextFactory.Solvers.MATHSAT5, SolverContextFactory.Solvers.Z3, SolverContextFactory.Solvers.SMTINTERPOL};
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverUnderTest;
    }

    private void initQeManager(boolean der, boolean upd, PseudoExistQeManager.SolverQeTactic qeTactic, boolean overapprox) throws InvalidConfigurationException {
        Configuration testConfig = Configuration.builder().copyFrom(this.config).setOption("cpa.predicate.pseudoExistQE.useDER", der ? "true" : "false").setOption("cpa.predicate.pseudoExistQE.useUPD", upd ? "true" : "false").setOption("cpa.predicate.pseudoExistQE.solverQeTactic", qeTactic.name()).setOption("cpa.predicate.pseudoExistQE.overapprox", overapprox ? "true" : "false").build();
        this.pQEmgr = new PseudoExistQeManager(this.solver, testConfig, this.logger);
    }

    @Before
    public void setUp() throws InvalidConfigurationException {
        this.pQEmgr = new PseudoExistQeManager(this.solver, this.config, this.logger);
    }

    @Test
    public void testDERSimpleInteger() throws Exception {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "y");
        BooleanFormula t1 = this.mgrv.makeEqual(x, (NumeralFormula.IntegerFormula)this.mgrv.getIntegerFormulaManager().makeNumber(5L));
        BooleanFormula t2 = this.mgrv.makeGreaterThan(y, x, true);
        BooleanFormula toExist = this.mgrv.makeAnd(t1, t2);
        HashMap<String, Formula> boundVars = new HashMap<String, Formula>();
        boundVars.put("x", (Formula)x);
        PseudoExistFormula input = new PseudoExistFormula(boundVars, toExist, this.mgrv);
        BooleanFormula expectedResult = this.mgrv.makeGreaterThan(y, (NumeralFormula.IntegerFormula)this.mgrv.getIntegerFormulaManager().makeNumber(5L), true);
        PseudoExistFormula result = this.pQEmgr.applyDER(input);
        Truth.assertThat((Boolean)result.hasQuantifiers()).isFalse();
        this.assertThatFormula(result.getInnerFormula()).isEquivalentTo(expectedResult);
    }

    @Test
    public void testUPDSimpleInteger() throws Exception {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "y");
        BooleanFormula t1 = this.mgrv.makeEqual(x, (NumeralFormula.IntegerFormula)this.mgrv.getIntegerFormulaManager().makeNumber(5L));
        BooleanFormula t2 = this.mgrv.makeGreaterThan(y, (NumeralFormula.IntegerFormula)this.mgrv.getIntegerFormulaManager().makeNumber(4L), true);
        BooleanFormula toExist = this.mgrv.makeAnd(t1, t2);
        HashMap<String, Formula> boundVars = new HashMap<String, Formula>();
        boundVars.put("y", (Formula)y);
        PseudoExistFormula input = new PseudoExistFormula(boundVars, toExist, this.mgrv);
        BooleanFormula expectedResult = t1;
        PseudoExistFormula result = this.pQEmgr.applyUPD(input);
        Truth.assertThat((Boolean)result.hasQuantifiers()).isFalse();
        this.assertThatFormula(result.getInnerFormula()).isEquivalentTo(expectedResult);
    }

    @Test
    public void testArrayDER() throws Exception {
        this.requireArrays();
        this.initQeManager(true, false, PseudoExistQeManager.SolverQeTactic.NONE, false);
        ArrayFormula array = this.amgr.makeArray("array", FormulaType.IntegerType, FormulaType.IntegerType);
        ArrayFormula arraystore = this.amgr.store(array, (Formula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)), (Formula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)));
        ArrayFormula test = this.amgr.makeArray("test", FormulaType.getArrayType((FormulaType)FormulaType.IntegerType, (FormulaType)FormulaType.IntegerType));
        Formula arrayselect = this.amgr.select(test, (Formula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
        NumeralFormula.IntegerFormula xFormula = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "x");
        BooleanFormula t1 = this.mgrv.makeEqual(test, arraystore);
        BooleanFormula t2 = this.mgrv.makeEqual(arrayselect, xFormula);
        BooleanFormula toExist = this.mgrv.makeAnd(t1, t2);
        HashMap<String, Formula> boundVars = new HashMap<String, Formula>();
        boundVars.put("test", (Formula)test);
        BooleanFormula expectedResult = this.mgrv.makeEqual(xFormula, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L));
        PseudoExistFormula input = new PseudoExistFormula(boundVars, toExist, this.mgrv);
        PseudoExistFormula result = this.pQEmgr.applyDER(input);
        Truth.assertThat((Boolean)result.hasQuantifiers()).isFalse();
        this.assertThatFormula(result.getInnerFormula()).isEquivalentTo(expectedResult);
    }

    @Test
    public void testRealQESimpleInteger() throws Exception {
        this.requireQuantifiers();
        this.initQeManager(false, false, PseudoExistQeManager.SolverQeTactic.LIGHT, false);
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "y");
        BooleanFormula t1 = this.mgrv.makeEqual(x, (NumeralFormula.IntegerFormula)this.mgrv.getIntegerFormulaManager().makeNumber(5L));
        BooleanFormula t2 = this.mgrv.makeGreaterThan(y, x, true);
        BooleanFormula toExist = this.mgrv.makeAnd(t1, t2);
        HashMap<String, Formula> boundVars = new HashMap<String, Formula>();
        boundVars.put("x", (Formula)x);
        BooleanFormula expectedResult = this.mgrv.makeGreaterThan(y, (NumeralFormula.IntegerFormula)this.mgrv.getIntegerFormulaManager().makeNumber(5L), true);
        BooleanFormula result = this.pQEmgr.eliminateQuantifiers(boundVars, toExist).orElseThrow();
        this.assertThatFormula(result).isEquivalentTo(expectedResult);
    }

    @Test
    public void testUPDSeveralBoundVars() throws Exception {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "y");
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.IntegerType, "z");
        NumeralFormula.IntegerFormula n5 = (NumeralFormula.IntegerFormula)this.mgrv.getIntegerFormulaManager().makeNumber(5L);
        BooleanFormula t1 = this.mgrv.makeEqual(x, n5);
        BooleanFormula t2 = this.mgrv.makeGreaterThan(y, z, true);
        BooleanFormula t3 = this.mgrv.makeLessThan(y, n5, true);
        BooleanFormula t4 = this.mgrv.makeLessThan(z, n5, true);
        BooleanFormula toExist = this.mgrv.getBooleanFormulaManager().and(t1, t2, t3, t4);
        HashMap<String, Formula> boundVars = new HashMap<String, Formula>();
        boundVars.put("y", (Formula)y);
        boundVars.put("z", (Formula)z);
        PseudoExistFormula input = new PseudoExistFormula(boundVars, toExist, this.mgrv);
        BooleanFormula expectedResult = t1;
        PseudoExistFormula result = this.pQEmgr.applyUPD(input);
        Truth.assertThat((Boolean)result.hasQuantifiers()).isFalse();
        this.assertThatFormula(result.getInnerFormula()).isEquivalentTo(expectedResult);
    }
}

