/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.regions;

import com.google.common.primitives.ImmutableIntArray;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Function;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionCreator;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class CountingRegionManager
implements RegionManager {
    private final RegionManager delegate;
    private final StatInt trueCtr = new StatInt(StatKind.COUNT, "Number of accesses to true");
    private final StatInt falseCtr = new StatInt(StatKind.COUNT, "Number of accesses to false");
    private final StatInt operationsCtr = new StatInt(StatKind.COUNT, "Number of operations");
    private final StatInt parserCtr = new StatInt(StatKind.COUNT, "Number of parsings");
    private final StatInt reorderCtr = new StatInt(StatKind.COUNT, "Number of reorderings");

    public CountingRegionManager(RegionManager pDelegate) {
        this.delegate = pDelegate;
    }

    @Override
    public RegionCreator.RegionBuilder builder(ShutdownNotifier pShutdownNotifier) {
        return this.delegate.builder(pShutdownNotifier);
    }

    @Override
    public Region makeTrue() {
        this.trueCtr.setNextValue(1);
        return this.delegate.makeTrue();
    }

    @Override
    public Region makeFalse() {
        this.falseCtr.setNextValue(1);
        return this.delegate.makeFalse();
    }

    @Override
    public Region makeNot(Region pF) {
        this.operationsCtr.setNextValue(1);
        return this.delegate.makeNot(pF);
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        this.operationsCtr.setNextValue(1);
        return this.delegate.makeAnd(pF1, pF2);
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        this.operationsCtr.setNextValue(1);
        return this.delegate.makeOr(pF1, pF2);
    }

    @Override
    public Region makeEqual(Region pF1, Region pF2) {
        this.operationsCtr.setNextValue(1);
        return this.delegate.makeEqual(pF1, pF2);
    }

    @Override
    public Region makeUnequal(Region pF1, Region pF2) {
        this.operationsCtr.setNextValue(1);
        return this.delegate.makeUnequal(pF1, pF2);
    }

    @Override
    public Region makeIte(Region pF1, Region pF2, Region pF3) {
        this.operationsCtr.setNextValue(1);
        return this.delegate.makeIte(pF1, pF2, pF3);
    }

    @Override
    public Region makeExists(Region pF1, Region ... pF2) {
        this.operationsCtr.setNextValue(1);
        return this.delegate.makeExists(pF1, pF2);
    }

    @Override
    public boolean entails(Region pF1, Region pF2) throws SolverException, InterruptedException {
        this.operationsCtr.setNextValue(1);
        return this.delegate.entails(pF1, pF2);
    }

    @Override
    public Region createPredicate() {
        this.operationsCtr.setNextValue(1);
        return this.delegate.createPredicate();
    }

    @Override
    public Region fromFormula(BooleanFormula pF, FormulaManagerView pFmgr, Function<BooleanFormula, Region> pAtomToRegion) {
        this.parserCtr.setNextValue(1);
        return this.delegate.fromFormula(pF, pFmgr, pAtomToRegion);
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        this.operationsCtr.setNextValue(1);
        return this.delegate.getIfThenElse(pF);
    }

    @Override
    public void printStatistics(PrintStream pOut) {
        StatisticsWriter.writingStatisticsTo(pOut).put(this.trueCtr).put(this.falseCtr).put(this.operationsCtr).put(this.parserCtr).put(this.reorderCtr);
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public void setVarOrder(ImmutableIntArray pOrder) {
        this.reorderCtr.setNextValue(1);
        this.delegate.setVarOrder(pOrder);
    }

    @Override
    public void reorder(RegionManager.VariableOrderingStrategy pStrategy) {
        this.reorderCtr.setNextValue(1);
        this.delegate.reorder(pStrategy);
    }

    @Override
    public Region replace(Region pRegion, List<Region> pOldPredicates, List<Region> pNewPredicates) {
        this.operationsCtr.setNextValue(1);
        return this.delegate.replace(pRegion, pOldPredicates, pNewPredicates);
    }
}

