/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.regions;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.ImmutableIntArray;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionCreator;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class NamedRegionManager
implements RegionManager {
    private static final String ANONYMOUS_PREDICATE = "__anon_pred";
    private final RegionManager delegate;
    private final BiMap<String, Region> regionMap = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private AtomicInteger anonymousPredicateCounter = new AtomicInteger(0);

    public NamedRegionManager(RegionManager pDelegate) {
        this.delegate = (RegionManager)Preconditions.checkNotNull((Object)pDelegate);
    }

    public Region createPredicate(String pName) {
        return (Region)this.regionMap.computeIfAbsent((Object)pName, ignoreArg -> this.delegate.createPredicate());
    }

    @Override
    public Region createPredicate() {
        return this.createPredicate(ANONYMOUS_PREDICATE + this.anonymousPredicateCounter.getAndIncrement());
    }

    public Appender dumpRegion(final Region r) {
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable pAppendable) throws IOException {
                NamedRegionManager.this.dumpRegion(r, pAppendable);
            }
        };
    }

    private void dumpRegion(Region r, Appendable out) throws IOException {
        if (this.regionMap.containsValue((Object)r)) {
            out.append((CharSequence)this.regionMap.inverse().get((Object)r));
        } else if (r.isFalse()) {
            out.append("FALSE");
        } else if (r.isTrue()) {
            out.append("TRUE");
        } else {
            Triple<Region, Region, Region> triple = this.delegate.getIfThenElse(r);
            String predName = (String)this.regionMap.inverse().get((Object)triple.getFirst());
            Region trueBranch = triple.getSecond();
            Region falseBranch = triple.getThird();
            if (trueBranch.isFalse()) {
                assert (!falseBranch.isFalse());
                out.append("!").append(predName).append(" & ");
                this.dumpRegion(falseBranch, out);
            } else if (falseBranch.isFalse()) {
                out.append(predName).append(" & ");
                this.dumpRegion(trueBranch, out);
            } else {
                out.append("((").append(predName).append(" & ");
                this.dumpRegion(trueBranch, out);
                out.append(") | (").append("!").append(predName).append(" & ");
                this.dumpRegion(falseBranch, out);
                out.append("))");
            }
        }
    }

    public String regionToDot(Region r) {
        AtomicInteger nodeCounter = new AtomicInteger(2);
        HashMap<Region, Integer> cache = new HashMap<Region, Integer>();
        StringBuilder str = new StringBuilder("digraph G {\n");
        if (!r.isTrue()) {
            str.append("0 [shape=box, label=\"0\", style=filled, shape=box, height=0.3, width=0.3];\n");
            cache.put(this.makeFalse(), 0);
        }
        if (!r.isFalse()) {
            str.append("1 [shape=box, label=\"1\", style=filled, shape=box, height=0.3, width=0.3];\n");
            cache.put(this.makeTrue(), 1);
        }
        this.regionToDot(r, str, cache, nodeCounter);
        str.append("}\n");
        return str.toString();
    }

    private int regionToDot(Region r, StringBuilder str, Map<Region, Integer> cache, AtomicInteger nodeCounter) {
        if (cache.containsKey(r)) {
            return cache.get(r);
        }
        Triple<Region, Region, Region> triple = this.delegate.getIfThenElse(r);
        String predName = (String)this.regionMap.inverse().get((Object)triple.getFirst());
        int predNum = nodeCounter.incrementAndGet();
        str.append(predNum).append(" [label=\"").append(predName).append("\"];\n");
        Region trueBranch = triple.getSecond();
        int trueTarget = this.regionToDot(trueBranch, str, cache, nodeCounter);
        str.append(predNum).append(" -> ").append(trueTarget).append(" [style=filled];\n");
        Region falseBranch = triple.getThird();
        int falseTarget = this.regionToDot(falseBranch, str, cache, nodeCounter);
        str.append(predNum).append(" -> ").append(falseTarget).append(" [style=dotted];\n");
        cache.put(r, predNum);
        return predNum;
    }

    @Override
    public boolean entails(Region pF1, Region pF2) throws SolverException, InterruptedException {
        return this.delegate.entails(pF1, pF2);
    }

    @Override
    public Region makeTrue() {
        return this.delegate.makeTrue();
    }

    @Override
    public Region makeFalse() {
        return this.delegate.makeFalse();
    }

    @Override
    public Region makeNot(Region pF) {
        return this.delegate.makeNot(pF);
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        return this.delegate.makeAnd(pF1, pF2);
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        return this.delegate.makeOr(pF1, pF2);
    }

    @Override
    public Region makeEqual(Region pF1, Region pF2) {
        return this.delegate.makeEqual(pF1, pF2);
    }

    @Override
    public Region makeUnequal(Region pF1, Region pF2) {
        return this.delegate.makeUnequal(pF1, pF2);
    }

    @Override
    public Region makeExists(Region pF1, Region ... pF2) {
        return this.delegate.makeExists(pF1, pF2);
    }

    @Override
    public RegionCreator.RegionBuilder builder(ShutdownNotifier pShutdownNotifier) {
        return this.delegate.builder(pShutdownNotifier);
    }

    @Override
    public void setVarOrder(ImmutableIntArray pOrder) {
        this.delegate.setVarOrder(pOrder);
    }

    @Override
    public void reorder(RegionManager.VariableOrderingStrategy strategy) {
        this.delegate.reorder(strategy);
    }

    @Override
    public Region fromFormula(BooleanFormula pF, FormulaManagerView pFmgr, Function<BooleanFormula, Region> pAtomToRegion) {
        return this.delegate.fromFormula(pF, pFmgr, pAtomToRegion);
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        return this.delegate.getIfThenElse(pF);
    }

    @Override
    public void printStatistics(PrintStream out) {
        out.println("Number of named predicates:          " + (this.regionMap.size() - this.anonymousPredicateCounter.get()));
        this.delegate.printStatistics(out);
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPredicates() {
        BiMap<String, Region> biMap = this.regionMap;
        synchronized (biMap) {
            return ImmutableSet.copyOf((Collection)this.regionMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getOrderedPredicates() {
        BiMap<String, Region> biMap = this.regionMap;
        synchronized (biMap) {
            return ImmutableList.sortedCopyOf((a, b) -> {
                Region rb;
                Region root;
                Region ra = (Region)this.regionMap.get(a);
                if (ra.equals(root = this.getIfThenElse(this.makeAnd(ra, rb = (Region)this.regionMap.get(b))).getFirst())) {
                    return 1;
                }
                if (rb.equals(root)) {
                    return -1;
                }
                throw new AssertionError((Object)"should not happen, all predicates are unique");
            }, (Iterable)this.regionMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPredicatesFromRegion(Region region) {
        BiMap<String, Region> biMap = this.regionMap;
        synchronized (biMap) {
            LinkedHashSet<String> predicates = new LinkedHashSet<String>();
            HashSet<Region> finished = new HashSet<Region>();
            ArrayDeque<Region> waitlist = new ArrayDeque<Region>();
            waitlist.push(region);
            while (!waitlist.isEmpty()) {
                Region r = (Region)waitlist.pop();
                if (r.isTrue() || r.isFalse() || !finished.add(r)) continue;
                Triple<Region, Region, Region> t = this.getIfThenElse(r);
                predicates.add((String)this.regionMap.inverse().get((Object)t.getFirst()));
                waitlist.add(t.getSecond());
                waitlist.add(t.getThird());
            }
            return predicates;
        }
    }

    @Override
    public Region makeIte(Region pF1, Region pF2, Region pF3) {
        return this.delegate.makeIte(pF1, pF2, pF3);
    }

    @Override
    public Region replace(Region pRegion, List<Region> pOldPredicates, List<Region> pNewPredicates) {
        return this.delegate.replace(pRegion, pOldPredicates, pNewPredicates);
    }
}

