/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.regions;

import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableIntArray;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Function;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionCreator;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

public class SymbolicRegionManager
implements RegionManager {
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bfmgr;
    private final Solver solver;
    private final SymbolicRegion trueRegion;
    private final SymbolicRegion falseRegion;

    public SymbolicRegionManager(Solver pSolver) {
        this.solver = pSolver;
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.trueRegion = new SymbolicRegion(this.bfmgr, this.bfmgr.makeTrue());
        this.falseRegion = new SymbolicRegion(this.bfmgr, this.bfmgr.makeFalse());
    }

    @Override
    public Region fromFormula(BooleanFormula f, FormulaManagerView pFmgr, Function<BooleanFormula, Region> pAtomToRegion) {
        Preconditions.checkArgument((pFmgr.getBooleanFormulaManager() == this.bfmgr ? 1 : 0) != 0);
        return new SymbolicRegion(this.bfmgr, f);
    }

    public BooleanFormula toFormula(Region r) {
        return ((SymbolicRegion)r).f;
    }

    public Region createPredicate(BooleanFormula pAtom) {
        return new SymbolicRegion(this.bfmgr, pAtom);
    }

    @Override
    public boolean entails(Region pF1, Region pF2) throws SolverException, InterruptedException {
        SymbolicRegion r1 = (SymbolicRegion)pF1;
        SymbolicRegion r2 = (SymbolicRegion)pF2;
        return this.solver.implies(r1.f, r2.f);
    }

    @Override
    public SymbolicRegion makeTrue() {
        return this.trueRegion;
    }

    @Override
    public SymbolicRegion makeFalse() {
        return this.falseRegion;
    }

    @Override
    public Region makeNot(Region pF) {
        SymbolicRegion r = (SymbolicRegion)pF;
        return new SymbolicRegion(r.bfmgr, r.bfmgr.not(r.f));
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        SymbolicRegion r1 = (SymbolicRegion)pF1;
        SymbolicRegion r2 = (SymbolicRegion)pF2;
        assert (r1.bfmgr == r2.bfmgr);
        return new SymbolicRegion(r1.bfmgr, r1.bfmgr.and(r1.f, r2.f));
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        SymbolicRegion r1 = (SymbolicRegion)pF1;
        SymbolicRegion r2 = (SymbolicRegion)pF2;
        assert (r1.bfmgr == r2.bfmgr);
        return new SymbolicRegion(r1.bfmgr, r1.bfmgr.or(r1.f, r2.f));
    }

    @Override
    public Region makeEqual(Region pF1, Region pF2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Region makeUnequal(Region pF1, Region pF2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Region makeIte(Region pF1, Region pF2, Region pF3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Region makeExists(Region pF1, Region ... pF2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Region createPredicate() {
        throw new UnsupportedOperationException("Call createPredicate(BooleanFormula) instead.");
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        throw new UnsupportedOperationException("Use toFormula(Region) instead of traversal.");
    }

    @Override
    public RegionCreator.RegionBuilder builder(ShutdownNotifier pShutdownNotifier) {
        return new SymbolicRegionBuilder();
    }

    @Override
    public void printStatistics(PrintStream out) {
    }

    @Override
    public String getVersion() {
        return this.solver.getVersion();
    }

    @Override
    public void reorder(RegionManager.VariableOrderingStrategy strategy) {
    }

    @Override
    public void setVarOrder(ImmutableIntArray pOrder) {
    }

    @Override
    public Region replace(Region pRegion, List<Region> pOldPredicates, List<Region> pNewPredicates) {
        throw new UnsupportedOperationException();
    }

    private class SymbolicRegionBuilder
    implements RegionCreator.RegionBuilder {
        private BooleanFormula currentCube = null;
        private BooleanFormula cubes;

        private SymbolicRegionBuilder() {
            this.cubes = SymbolicRegionManager.this.bfmgr.makeFalse();
        }

        @Override
        public void startNewConjunction() {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            this.currentCube = SymbolicRegionManager.this.bfmgr.makeBoolean(true);
        }

        @Override
        public void addPositiveRegion(Region r) {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            this.currentCube = SymbolicRegionManager.this.bfmgr.and(((SymbolicRegion)r).f, this.currentCube);
        }

        @Override
        public void addNegativeRegion(Region r) {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            this.currentCube = SymbolicRegionManager.this.bfmgr.and(SymbolicRegionManager.this.bfmgr.not(((SymbolicRegion)r).f), this.currentCube);
        }

        @Override
        public void finishConjunction() {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            this.cubes = SymbolicRegionManager.this.bfmgr.or(this.currentCube, this.cubes);
            this.currentCube = null;
        }

        @Override
        public Region getResult() {
            return new SymbolicRegion(SymbolicRegionManager.this.bfmgr, this.cubes);
        }

        @Override
        public void close() {
        }
    }

    private static class SymbolicRegion
    implements Region {
        private final BooleanFormula f;
        private final BooleanFormulaManager bfmgr;

        private SymbolicRegion(BooleanFormulaManager bfmgr, BooleanFormula pF) {
            this.f = (BooleanFormula)Preconditions.checkNotNull((Object)pF);
            this.bfmgr = bfmgr;
        }

        @Override
        public boolean isTrue() {
            return this.bfmgr.isTrue(this.f);
        }

        @Override
        public boolean isFalse() {
            return this.bfmgr.isFalse(this.f);
        }

        public String toString() {
            return this.f.toString();
        }

        public boolean equals(Object pObj) {
            return pObj instanceof SymbolicRegion && this.f.equals(((SymbolicRegion)pObj).f);
        }

        public int hashCode() {
            return this.f.hashCode();
        }
    }
}

