/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.regions;

import com.google.common.primitives.ImmutableIntArray;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Function;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionCreator;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class TimedRegionManager
implements RegionManager {
    private final RegionManager delegate;
    private final Timer timer = new Timer();
    private final Timer predicateTimer = new Timer();
    private final Timer orderingTimer = new Timer();

    public TimedRegionManager(RegionManager pDelegate) {
        this.delegate = pDelegate;
    }

    @Override
    public RegionCreator.RegionBuilder builder(ShutdownNotifier pShutdownNotifier) {
        this.timer.start();
        try {
            RegionCreator.RegionBuilder regionBuilder = this.delegate.builder(pShutdownNotifier);
            return regionBuilder;
        }
        finally {
            this.timer.stop();
        }
    }

    @Override
    public Region makeTrue() {
        this.timer.start();
        try {
            Region region = this.delegate.makeTrue();
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    @Override
    public Region makeFalse() {
        this.timer.start();
        try {
            Region region = this.delegate.makeFalse();
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    @Override
    public Region makeNot(Region pF) {
        this.timer.start();
        try {
            Region region = this.delegate.makeNot(pF);
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        this.timer.start();
        try {
            Region region = this.delegate.makeAnd(pF1, pF2);
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region makeOr(Region pF1, Region pF2) {
        this.timer.start();
        try {
            Region region = this.delegate.makeOr(pF1, pF2);
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region makeEqual(Region pF1, Region pF2) {
        this.timer.start();
        try {
            Region region = this.delegate.makeEqual(pF1, pF2);
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region makeUnequal(Region pF1, Region pF2) {
        this.timer.start();
        try {
            Region region = this.delegate.makeUnequal(pF1, pF2);
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region makeIte(Region pF1, Region pF2, Region pF3) {
        this.timer.start();
        try {
            Region region = this.delegate.makeIte(pF1, pF2, pF3);
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region makeExists(Region pF1, Region ... pF2) {
        this.timer.start();
        try {
            Region region = this.delegate.makeExists(pF1, pF2);
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean entails(Region pF1, Region pF2) throws SolverException, InterruptedException {
        this.timer.start();
        try {
            boolean bl = this.delegate.entails(pF1, pF2);
            return bl;
        }
        finally {
            this.timer.stop();
        }
    }

    @Override
    public Region createPredicate() {
        this.predicateTimer.start();
        try {
            Region region = this.delegate.createPredicate();
            return region;
        }
        finally {
            this.predicateTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region fromFormula(BooleanFormula pF, FormulaManagerView pFmgr, Function<BooleanFormula, Region> pAtomToRegion) {
        this.timer.start();
        try {
            Region region = this.delegate.fromFormula(pF, pFmgr, pAtomToRegion);
            return region;
        }
        finally {
            this.timer.stop();
        }
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        this.timer.start();
        try {
            Triple<Region, Region, Region> triple = this.delegate.getIfThenElse(pF);
            return triple;
        }
        finally {
            this.timer.stop();
        }
    }

    @Override
    public void printStatistics(PrintStream pOut) {
        StatisticsWriter.writingStatisticsTo(pOut).put("Time for region operations", this.timer).put("Max time for region operations", this.timer.getMaxTime()).put("Time for predicate creations", this.predicateTimer).put("Time for reorderings", this.orderingTimer).put("Number of region operations", this.timer.getNumberOfIntervals()).put("Number of predicate creations", this.predicateTimer.getNumberOfIntervals()).put("Number of reorderings", this.orderingTimer.getNumberOfIntervals());
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public void setVarOrder(ImmutableIntArray pOrder) {
        this.orderingTimer.start();
        try {
            this.delegate.setVarOrder(pOrder);
        }
        finally {
            this.orderingTimer.stop();
        }
    }

    @Override
    public void reorder(RegionManager.VariableOrderingStrategy pStrategy) {
        this.orderingTimer.start();
        try {
            this.delegate.reorder(pStrategy);
        }
        finally {
            this.orderingTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region replace(Region pRegion, List<Region> pOldPredicates, List<Region> pNewPredicates) {
        this.timer.start();
        try {
            Region region = this.delegate.replace(pRegion, pOldPredicates, pNewPredicates);
            return region;
        }
        finally {
            this.timer.stop();
        }
    }
}

