/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import org.sosy_lab.cpachecker.util.predicates.smt.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.cpachecker.util.predicates.smt.WrappingFormula;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;

public class ArrayFormulaManagerView
extends BaseManagerView
implements ArrayFormulaManager {
    private ArrayFormulaManager manager;

    ArrayFormulaManagerView(FormulaWrappingHandler pWrappingHandler, ArrayFormulaManager pManager) {
        super(pWrappingHandler);
        this.manager = pManager;
    }

    public <TI extends Formula, TE extends Formula> TE select(ArrayFormula<TI, TE> pArray, TI pIndex) {
        ArrayFormula declaredArray = (ArrayFormula)this.unwrap((Formula)pArray);
        Formula declaredIndex = this.unwrap(pIndex);
        Formula selectResult = this.manager.select(declaredArray, declaredIndex);
        FormulaType<TE> resultType = this.getElementType(pArray);
        return this.wrap(resultType, selectResult);
    }

    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> store(ArrayFormula<TI, TE> pArray, TI pIndex, TE pValue) {
        ArrayFormula declaredArray = (ArrayFormula)this.unwrap((Formula)pArray);
        FormulaType.ArrayFormulaType inputArrayType = new FormulaType.ArrayFormulaType(this.getIndexType(pArray), this.getElementType(pArray));
        ArrayFormula resultFormula = this.manager.store(declaredArray, this.unwrap(pIndex), this.unwrap(pValue));
        if (resultFormula instanceof WrappingFormula) {
            return resultFormula;
        }
        return (ArrayFormula)this.wrap(inputArrayType, resultFormula);
    }

    public <TI extends Formula, TE extends Formula, FTI extends FormulaType<TI>, FTE extends FormulaType<TE>> ArrayFormula<TI, TE> makeArray(String pName, FTI pIndexType, FTE pElementType) {
        FormulaType.ArrayFormulaType inputArrayType = new FormulaType.ArrayFormulaType(pIndexType, pElementType);
        FormulaType<?> unwrappedIndexType = this.unwrapType(pIndexType);
        FormulaType<?> unwrappedElementType = this.unwrapType(pElementType);
        ArrayFormula result = this.manager.makeArray(pName, unwrappedIndexType, unwrappedElementType);
        return (ArrayFormula)this.wrap(inputArrayType, result);
    }

    public <TI extends Formula, TE extends Formula, FTI extends FormulaType<TI>, FTE extends FormulaType<TE>> ArrayFormula<TI, TE> makeArray(String pName, int pSsaIndex, FTI pIndexType, FTE pElementType) {
        return this.makeArray(FormulaManagerView.makeName(pName, pSsaIndex), pIndexType, pElementType);
    }

    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> makeArray(String pName, FormulaType.ArrayFormulaType<TI, TE> type) {
        return (ArrayFormula)this.wrap(type, this.manager.makeArray(pName, (FormulaType.ArrayFormulaType)this.unwrapType((FormulaType<?>)type)));
    }

    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> makeArray(String pName, int pSsaIndex, FormulaType.ArrayFormulaType<TI, TE> pType) {
        return this.makeArray(FormulaManagerView.makeName(pName, pSsaIndex), pType);
    }

    public <TI extends Formula> FormulaType<TI> getIndexType(ArrayFormula<TI, ?> pArray) {
        if (pArray instanceof WrappingFormula) {
            FormulaType.ArrayFormulaType t = (FormulaType.ArrayFormulaType)((WrappingFormula)pArray).getType();
            return t.getIndexType();
        }
        return this.manager.getIndexType(pArray);
    }

    public <TE extends Formula> FormulaType<TE> getElementType(ArrayFormula<?, TE> pArray) {
        if (pArray instanceof WrappingFormula) {
            FormulaType.ArrayFormulaType t = (FormulaType.ArrayFormulaType)((WrappingFormula)pArray).getType();
            return t.getElementType();
        }
        return this.manager.getElementType(pArray);
    }

    public <TI extends Formula, TE extends Formula> BooleanFormula equivalence(ArrayFormula<TI, TE> pArray1, ArrayFormula<TI, TE> pArray2) {
        ArrayFormula declaredArray1 = (ArrayFormula)this.unwrap((Formula)pArray1);
        ArrayFormula declaredArray2 = (ArrayFormula)this.unwrap((Formula)pArray2);
        BooleanFormula result = this.manager.equivalence(declaredArray1, declaredArray2);
        return (BooleanFormula)this.wrap(FormulaType.BooleanType, result);
    }
}

