/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.cpachecker.util.predicates.smt.ModelView;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;

public class BasicProverEnvironmentView<E>
implements BasicProverEnvironment<E> {
    private final BasicProverEnvironment<E> delegate;
    private final FormulaWrappingHandler wrappingHandler;

    public BasicProverEnvironmentView(BasicProverEnvironment<E> pDelegate, FormulaWrappingHandler pWrappingHandler) {
        this.delegate = pDelegate;
        this.wrappingHandler = pWrappingHandler;
    }

    public E push(BooleanFormula f) throws InterruptedException {
        return (E)this.delegate.push(f);
    }

    public void pop() {
        this.delegate.pop();
    }

    public E addConstraint(BooleanFormula constraint) throws InterruptedException {
        return (E)this.delegate.addConstraint(constraint);
    }

    public void push() {
        this.delegate.push();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isUnsat() throws SolverException, InterruptedException {
        return this.delegate.isUnsat();
    }

    public Model getModel() throws SolverException {
        return new ModelView(this.delegate.getModel(), this.wrappingHandler);
    }

    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        return BasicProverEnvironmentView.fixModelAssignments((ImmutableList<Model.ValueAssignment>)this.delegate.getModelAssignments());
    }

    static ImmutableList<Model.ValueAssignment> fixModelAssignments(ImmutableList<Model.ValueAssignment> m) {
        if (m.stream().noneMatch(valueAssignment -> valueAssignment.getName().contains("!"))) {
            return m;
        }
        return FluentIterable.from(m).filter(ModelView::isRelevantModelTerm).toList();
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        return this.delegate.isUnsatWithAssumptions(assumptions);
    }

    public List<BooleanFormula> getUnsatCore() {
        return this.delegate.getUnsatCore();
    }

    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        return this.delegate.unsatCoreOverAssumptions(pAssumptions);
    }

    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> pCallback, List<BooleanFormula> pImportant) throws InterruptedException, SolverException {
        return (R)this.delegate.allSat(pCallback, pImportant);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

