/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.smt.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;

public class BitvectorFormulaManagerView
extends BaseManagerView
implements BitvectorFormulaManager {
    private final BitvectorFormulaManager manager;
    private final BooleanFormulaManager bmgr;

    BitvectorFormulaManagerView(FormulaWrappingHandler pWrappingHandler, BitvectorFormulaManager pManager, BooleanFormulaManager pBmgr) {
        super(pWrappingHandler);
        this.manager = (BitvectorFormulaManager)Preconditions.checkNotNull((Object)pManager);
        this.bmgr = (BooleanFormulaManager)Preconditions.checkNotNull((Object)pBmgr);
    }

    public BooleanFormula notEqual(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        return this.bmgr.not(this.equal(pNumber1, pNumber2));
    }

    public BitvectorFormula makeBitvector(FormulaType<BitvectorFormula> pType, long pI) {
        FormulaType.BitvectorType t = (FormulaType.BitvectorType)pType;
        return this.makeBitvector(t.getSize(), pI);
    }

    public BitvectorFormula makeBitvector(FormulaType<BitvectorFormula> pType, BigInteger pI) {
        FormulaType.BitvectorType t = (FormulaType.BitvectorType)pType;
        return this.makeBitvector(t.getSize(), pI);
    }

    public BitvectorFormula negate(BitvectorFormula pNumber) {
        return this.manager.negate(pNumber);
    }

    public BitvectorFormula add(BitvectorFormula pNumber1, BitvectorFormula pNumbe2) {
        return this.manager.add(pNumber1, pNumbe2);
    }

    public BitvectorFormula subtract(BitvectorFormula pNumber1, BitvectorFormula pNumbe2) {
        return this.manager.subtract(pNumber1, pNumbe2);
    }

    public BitvectorFormula divide(BitvectorFormula pNumber1, BitvectorFormula pNumbe2, boolean signed) {
        return this.manager.divide(pNumber1, pNumbe2, signed);
    }

    public BitvectorFormula modulo(BitvectorFormula pNumber1, BitvectorFormula pNumbe2, boolean signed) {
        return this.manager.modulo(pNumber1, pNumbe2, signed);
    }

    public BitvectorFormula multiply(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        return this.manager.multiply(pNumber1, pNumber2);
    }

    public BooleanFormula equal(BitvectorFormula pNumber1, BitvectorFormula pNumbe2) {
        return this.manager.equal(pNumber1, pNumbe2);
    }

    public BooleanFormula greaterThan(BitvectorFormula pNumber1, BitvectorFormula pNumbe2, boolean signed) {
        return this.manager.greaterThan(pNumber1, pNumbe2, signed);
    }

    public BooleanFormula greaterOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumbe2, boolean signed) {
        return this.manager.greaterOrEquals(pNumber1, pNumbe2, signed);
    }

    public BooleanFormula lessThan(BitvectorFormula pNumber1, BitvectorFormula pNumbe2, boolean signed) {
        return this.manager.lessThan(pNumber1, pNumbe2, signed);
    }

    public BooleanFormula lessOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumbe2, boolean signed) {
        return this.manager.lessOrEquals(pNumber1, pNumbe2, signed);
    }

    public BitvectorFormula not(BitvectorFormula pBits) {
        return this.manager.not(pBits);
    }

    public BitvectorFormula and(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        return this.manager.and(pBits1, pBits2);
    }

    public BitvectorFormula or(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        return this.manager.or(pBits1, pBits2);
    }

    public BitvectorFormula xor(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        return this.manager.xor(pBits1, pBits2);
    }

    public BitvectorFormula makeBitvector(int pLength, long pI) {
        return this.manager.makeBitvector(pLength, pI);
    }

    public BitvectorFormula makeBitvector(int pLength, BigInteger pI) {
        return this.manager.makeBitvector(pLength, pI);
    }

    public BitvectorFormula makeVariable(int pLength, String pVar) {
        return this.manager.makeVariable(pLength, pVar);
    }

    public BitvectorFormula makeVariable(FormulaType.BitvectorType type, String pVar) {
        return this.manager.makeVariable(type.getSize(), pVar);
    }

    public int getLength(BitvectorFormula pNumber) {
        return this.manager.getLength(pNumber);
    }

    public BitvectorFormula shiftRight(BitvectorFormula pNumber, BitvectorFormula pToShift, boolean signed) {
        return this.manager.shiftRight(pNumber, pToShift, signed);
    }

    public BitvectorFormula shiftLeft(BitvectorFormula pNumber, BitvectorFormula pToShift) {
        return this.manager.shiftLeft(pNumber, pToShift);
    }

    public BitvectorFormula concat(BitvectorFormula pNumber, BitvectorFormula pAppend) {
        return this.manager.concat(pNumber, pAppend);
    }

    public BitvectorFormula extract(BitvectorFormula pNumber, int pMsb, int pLsb) {
        return this.manager.extract(pNumber, pMsb, pLsb);
    }

    public BitvectorFormula extend(BitvectorFormula pNumber, int pExtensionBits, boolean pSigned) {
        return this.manager.extend(pNumber, pExtensionBits, pSigned);
    }

    public BitvectorFormula makeBitvector(int pLength, NumeralFormula.IntegerFormula pI) {
        return this.manager.makeBitvector(pLength, pI);
    }

    public NumeralFormula.IntegerFormula toIntegerFormula(BitvectorFormula pI, boolean pSigned) {
        return this.manager.toIntegerFormula(pI, pSigned);
    }

    public BooleanFormula distinct(List<BitvectorFormula> pBits) {
        return this.manager.distinct(pBits);
    }
}

