/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collector;
import org.sosy_lab.cpachecker.util.predicates.smt.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public class BooleanFormulaManagerView
extends BaseManagerView
implements BooleanFormulaManager {
    private final BooleanFormulaManager manager;

    BooleanFormulaManagerView(FormulaWrappingHandler pWrappingHandler, BooleanFormulaManager pManager) {
        super(pWrappingHandler);
        this.manager = (BooleanFormulaManager)Preconditions.checkNotNull((Object)pManager);
    }

    public BooleanFormula makeVariable(String pVar, int pI) {
        return this.makeVariable(FormulaManagerView.makeName(pVar, pI));
    }

    public BooleanFormula not(BooleanFormula pBits) {
        return this.manager.not(pBits);
    }

    public BooleanFormula and(BooleanFormula pBits1, BooleanFormula pBits2) {
        return this.manager.and(pBits1, pBits2);
    }

    public BooleanFormula and(Collection<BooleanFormula> pBits) {
        return this.manager.and(pBits);
    }

    public BooleanFormula and(BooleanFormula ... bits) {
        return this.manager.and(bits);
    }

    public Collector<BooleanFormula, ?, BooleanFormula> toConjunction() {
        return this.manager.toConjunction();
    }

    public BooleanFormula or(BooleanFormula pBits1, BooleanFormula pBits2) {
        return this.manager.or(pBits1, pBits2);
    }

    public BooleanFormula or(Collection<BooleanFormula> pBits) {
        return this.manager.or(pBits);
    }

    public BooleanFormula or(BooleanFormula ... bits) {
        return this.manager.or(bits);
    }

    public Collector<BooleanFormula, ?, BooleanFormula> toDisjunction() {
        return this.manager.toDisjunction();
    }

    public BooleanFormula xor(BooleanFormula pBits1, BooleanFormula pBits2) {
        return this.manager.xor(pBits1, pBits2);
    }

    public <R> R visit(BooleanFormula formula, BooleanFormulaVisitor<R> visitor) {
        return (R)this.manager.visit(formula, visitor);
    }

    public void visitRecursively(BooleanFormula f, BooleanFormulaVisitor<TraversalProcess> rFormulaVisitor) {
        this.manager.visitRecursively(f, rFormulaVisitor);
    }

    public BooleanFormula transformRecursively(BooleanFormula f, org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor pVisitor) {
        return this.manager.transformRecursively(f, pVisitor);
    }

    public Set<BooleanFormula> toConjunctionArgs(BooleanFormula f, boolean flatten) {
        return this.manager.toConjunctionArgs(f, flatten);
    }

    public Set<BooleanFormula> toDisjunctionArgs(BooleanFormula f, boolean flatten) {
        return this.manager.toDisjunctionArgs(f, flatten);
    }

    public BooleanFormula makeBoolean(boolean pValue) {
        return this.manager.makeBoolean(pValue);
    }

    public BooleanFormula makeTrue() {
        return this.manager.makeTrue();
    }

    public BooleanFormula makeFalse() {
        return this.manager.makeFalse();
    }

    public BooleanFormula makeVariable(String pVar) {
        return this.manager.makeVariable(pVar);
    }

    public boolean isTrue(BooleanFormula pFormula) {
        return this.manager.isTrue(pFormula);
    }

    public boolean isFalse(BooleanFormula pFormula) {
        return this.manager.isFalse(pFormula);
    }

    public <T extends Formula> T ifThenElse(BooleanFormula pCond, T pF1, T pF2) {
        Formula f1 = this.unwrap(pF1);
        Formula f2 = this.unwrap(pF2);
        FormulaType<T> targetType = this.getFormulaType(pF1);
        return this.wrap(targetType, this.manager.ifThenElse(pCond, f1, f2));
    }

    public BooleanFormula equivalence(BooleanFormula pFormula1, BooleanFormula pFormula2) {
        return this.manager.equivalence(pFormula1, pFormula2);
    }

    public BooleanFormula implication(BooleanFormula formula1, BooleanFormula formula2) {
        return this.manager.implication(formula1, formula2);
    }

    public static abstract class BooleanFormulaTransformationVisitor
    extends org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor {
        protected BooleanFormulaTransformationVisitor(FormulaManagerView pFmgr) {
            super(pFmgr.getRawFormulaManager());
        }
    }
}

