/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BitvectorFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FloatingPointFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.cpachecker.util.predicates.smt.FunctionFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.IntegerFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.QuantifiedFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.RationalFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.ReplaceBitvectorWithNumeralAndFunctionTheory;
import org.sosy_lab.cpachecker.util.predicates.smt.ReplaceFloatingPointWithNumeralAndFunctionTheory;
import org.sosy_lab.cpachecker.util.predicates.smt.ReplaceIntegerWithBitvectorTheory;
import org.sosy_lab.cpachecker.util.predicates.smt.SLFormulaManagerView;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.NumeralFormulaManager;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

@Options(prefix="cpa.predicate")
public class FormulaManagerView {
    private final LogManager logger;
    private final FormulaManager manager;
    private final FormulaWrappingHandler wrappingHandler;
    private final BooleanFormulaManagerView booleanFormulaManager;
    private final FunctionFormulaManagerView functionFormulaManager;
    private final ReplaceIntegerWithBitvectorTheory.ReplaceIntegerEncodingOptions intOptions;
    private final @Nullable BitvectorFormulaManagerView bitvectorFormulaManager;
    private final @Nullable FloatingPointFormulaManagerView floatingPointFormulaManager;
    private final @Nullable IntegerFormulaManagerView integerFormulaManager;
    private @Nullable RationalFormulaManagerView rationalFormulaManager;
    private @Nullable QuantifiedFormulaManagerView quantifiedFormulaManager;
    private @Nullable ArrayFormulaManagerView arrayFormulaManager;
    private @Nullable SLFormulaManagerView slFormulaManager;
    @Option(secure=true, name="formulaDumpFilePattern", description="where to dump interpolation and abstraction problems (format string)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate formulaDumpFile = PathTemplate.ofFormatString((String)"%s%04d-%s%03d.smt2");
    @Option(secure=true, description="try to add some useful static-learning-like axioms for bitwise operations (which are encoded as UFs): essentially, we simply collect all the numbers used in bitwise operations, and add axioms like (0 & n = 0)")
    private boolean useBitwiseAxioms = false;
    @Option(secure=true, description="Theory to use as backend for bitvectors. If different from BITVECTOR, the specified theory is used to approximate bitvectors. This can be used for solvers that do not support bitvectors, or for increased performance. If UNSUPPORTED, solvers can be used that support none of the possible alternatives, but CPAchecker will crash if bitvectors are required by the analysis.")
    private Theory encodeBitvectorAs = Theory.BITVECTOR;
    @Option(secure=true, description="Theory to use as backend for floats. If different from FLOAT, the specified theory is used to approximate floats. This can be used for solvers that do not support floating-point arithmetic, or for increased performance. If UNSUPPORTED, solvers can be used that support none of the possible alternatives, but CPAchecker will crash if floats are required by the analysis.")
    private Theory encodeFloatAs = Theory.FLOAT;
    @Option(secure=true, description="Theory to use as backend for integers. If different from INTEGER, the specified theory is used to approximate integers. This can be used for solvers that do not support integers, or for increased performance. If UNSUPPORTED, solvers can be used that support none of the possible alternatives, but CPAchecker will crash if integers are required by the analysis.")
    private Theory encodeIntegerAs = Theory.INTEGER;
    public static final char INDEX_SEPARATOR = '@';
    private static final Splitter INDEX_SPLITTER = Splitter.on((char)'@');
    private final Map<Formula, Formula> uninstantiateCache = new HashMap<Formula, Formula>();
    private final Map<Formula, Boolean> arithCache = new HashMap<Formula, Boolean>();
    static final String BitwiseAndUfName = "_&_";
    static final String BitwiseOrUfName = "_!!_";
    static final String BitwiseXorUfName = "_^_";
    static final String BitwiseNotUfName = "_~_";
    private static final String DUMMY_VAR = "__dummy_variable_dumping_formulas__";

    @VisibleForTesting
    public FormulaManagerView(FormulaManager pFormulaManager, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this, FormulaManagerView.class);
        this.logger = pLogger;
        this.manager = (FormulaManager)Preconditions.checkNotNull((Object)pFormulaManager);
        if (!ImmutableSet.of((Object)((Object)Theory.UNSUPPORTED), (Object)((Object)Theory.BITVECTOR), (Object)((Object)Theory.INTEGER), (Object)((Object)Theory.RATIONAL)).contains((Object)this.encodeBitvectorAs)) {
            throw new InvalidConfigurationException("Invalid value " + this.encodeBitvectorAs + " for option cpa.predicate.encodeBitvectorAs. This kind of theory approximation is not supported.");
        }
        if (!ImmutableSet.of((Object)((Object)Theory.UNSUPPORTED), (Object)((Object)Theory.FLOAT), (Object)((Object)Theory.INTEGER), (Object)((Object)Theory.RATIONAL)).contains((Object)this.encodeFloatAs)) {
            throw new InvalidConfigurationException("Invalid value " + this.encodeFloatAs + " for option cpa.predicate.encodeFloatAs. This kind of theory approximation is not supported.");
        }
        if (!ImmutableSet.of((Object)((Object)Theory.UNSUPPORTED), (Object)((Object)Theory.INTEGER), (Object)((Object)Theory.BITVECTOR)).contains((Object)this.encodeIntegerAs)) {
            throw new InvalidConfigurationException("Invalid value " + this.encodeIntegerAs + " for option cpa.predicate.encodeIntegerAs. This kind of theory approximation is not supported.");
        }
        this.intOptions = new ReplaceIntegerWithBitvectorTheory.ReplaceIntegerEncodingOptions(config);
        this.wrappingHandler = new FormulaWrappingHandler(this.manager, this.encodeBitvectorAs, this.encodeFloatAs, this.encodeIntegerAs, this.intOptions);
        this.booleanFormulaManager = new BooleanFormulaManagerView(this.wrappingHandler, this.manager.getBooleanFormulaManager());
        this.functionFormulaManager = new FunctionFormulaManagerView(this.wrappingHandler, this.manager.getUFManager());
        this.bitvectorFormulaManager = this.createBitvectorFormulaManager(config);
        this.floatingPointFormulaManager = this.createFloatingPointFormulaManager();
        this.integerFormulaManager = this.createIntegerFormulaManager(this.intOptions);
        this.logInfo();
    }

    private void logInfo() {
        ArrayList<Theory> unsupportedTheories = new ArrayList<Theory>();
        if (this.encodeBitvectorAs == Theory.UNSUPPORTED) {
            unsupportedTheories.add(Theory.BITVECTOR);
        }
        if (this.encodeFloatAs == Theory.UNSUPPORTED) {
            unsupportedTheories.add(Theory.FLOAT);
        }
        if (this.encodeIntegerAs == Theory.UNSUPPORTED) {
            unsupportedTheories.add(Theory.INTEGER);
        }
        if (!unsupportedTheories.isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"Theory of", FluentIterable.from(unsupportedTheories).transform(Theory::description).join(Joiner.on((String)" and ")), "unsupported by current configuration.", "CPAchecker will crash if any of these are used during the analysis."});
        }
        ArrayList<CallSite> approximations = new ArrayList<CallSite>();
        if (this.encodeIntegerAs != Theory.INTEGER && this.encodeIntegerAs != Theory.UNSUPPORTED) {
            approximations.add((CallSite)((Object)("plain ints with " + this.encodeIntegerAs.description() + " with bitsize " + this.intOptions.getBitsize())));
        }
        if (this.encodeBitvectorAs != Theory.BITVECTOR && this.encodeBitvectorAs != Theory.UNSUPPORTED) {
            approximations.add((CallSite)((Object)("ints with " + this.encodeBitvectorAs.description())));
        }
        if (this.encodeFloatAs != Theory.FLOAT && this.encodeFloatAs != Theory.UNSUPPORTED) {
            approximations.add((CallSite)((Object)("floats with " + this.encodeFloatAs.description())));
        }
        if (!approximations.isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"Using unsound approximation of", Joiner.on((String)" and ").join(approximations), "for encoding program semantics."});
        }
    }

    private @Nullable BitvectorFormulaManagerView createBitvectorFormulaManager(Configuration config) throws InvalidConfigurationException {
        ReplaceBitvectorWithNumeralAndFunctionTheory rawBvmgr;
        if (this.encodeBitvectorAs == Theory.UNSUPPORTED) {
            return null;
        }
        try {
            switch (this.encodeBitvectorAs) {
                case BITVECTOR: {
                    rawBvmgr = this.manager.getBitvectorFormulaManager();
                    break;
                }
                case INTEGER: {
                    rawBvmgr = new ReplaceBitvectorWithNumeralAndFunctionTheory(this.wrappingHandler, this.manager.getBooleanFormulaManager(), this.manager.getIntegerFormulaManager(), this.manager.getUFManager(), config);
                    break;
                }
                case RATIONAL: {
                    rawBvmgr = new ReplaceBitvectorWithNumeralAndFunctionTheory(this.wrappingHandler, this.manager.getBooleanFormulaManager(), this.manager.getRationalFormulaManager(), this.manager.getUFManager(), config);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected encoding for bitvectors: " + this.encodeBitvectorAs));
                }
            }
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidConfigurationException("The chosen SMT solver does not support the theory of " + this.encodeBitvectorAs.description() + ", please choose another SMT solver or use the option cpa.predicate.encodeBitvectorAs to approximate bitvectors with another theory. The value UNSUPPORTED for this option can be used to override this, but CPAchecker will crash if bitvectors are used during the analysis.", (Throwable)e);
        }
        return new BitvectorFormulaManagerView(this.wrappingHandler, rawBvmgr, this.manager.getBooleanFormulaManager());
    }

    private @Nullable FloatingPointFormulaManagerView createFloatingPointFormulaManager() throws InvalidConfigurationException {
        ReplaceFloatingPointWithNumeralAndFunctionTheory rawFpmgr;
        if (this.encodeFloatAs == Theory.UNSUPPORTED) {
            return null;
        }
        try {
            switch (this.encodeFloatAs) {
                case FLOAT: {
                    rawFpmgr = this.manager.getFloatingPointFormulaManager();
                    break;
                }
                case INTEGER: {
                    rawFpmgr = new ReplaceFloatingPointWithNumeralAndFunctionTheory(this.wrappingHandler, this.manager.getIntegerFormulaManager(), this.manager.getUFManager(), this.manager.getBooleanFormulaManager());
                    break;
                }
                case RATIONAL: {
                    rawFpmgr = new ReplaceFloatingPointWithNumeralAndFunctionTheory(this.wrappingHandler, this.manager.getRationalFormulaManager(), this.manager.getUFManager(), this.manager.getBooleanFormulaManager());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected encoding for floating points: " + this.encodeFloatAs));
                }
            }
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidConfigurationException("The chosen SMT solver does not support the theory of " + this.encodeFloatAs.description() + ", please choose another SMT solver or use the option cpa.predicate.encodeFloatAs to approximate floats with another theory. The value UNSUPPORTED for this option can be used to override this, but CPAchecker will crash if floats are used during the analysis.", (Throwable)e);
        }
        return new FloatingPointFormulaManagerView(this.wrappingHandler, rawFpmgr, this.manager.getUFManager());
    }

    private @Nullable IntegerFormulaManagerView createIntegerFormulaManager(ReplaceIntegerWithBitvectorTheory.ReplaceIntegerEncodingOptions pIntegerOptions) throws InvalidConfigurationException {
        IntegerFormulaManager rawImgr;
        if (this.encodeIntegerAs == Theory.UNSUPPORTED) {
            return null;
        }
        try {
            switch (this.encodeIntegerAs) {
                case INTEGER: {
                    rawImgr = this.manager.getIntegerFormulaManager();
                    break;
                }
                case BITVECTOR: {
                    rawImgr = new ReplaceIntegerWithBitvectorTheory(this.wrappingHandler, this.manager.getBitvectorFormulaManager(), this.manager.getBooleanFormulaManager(), pIntegerOptions);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected encoding for plain integers: " + this.encodeIntegerAs));
                }
            }
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidConfigurationException("The chosen SMT solver does not support the theory of " + this.encodeIntegerAs.description() + ", please choose another SMT solver or use the option cpa.predicate.encodeIntegerAs to approximate integers with another theory. The value UNSUPPORTED for this option can be used to override this, but CPAchecker will crash if integers are used during the analysis.", (Throwable)e);
        }
        return new IntegerFormulaManagerView(this.wrappingHandler, rawImgr);
    }

    FormulaWrappingHandler getFormulaWrappingHandler() {
        return this.wrappingHandler;
    }

    FormulaManager getRawFormulaManager() {
        return this.manager;
    }

    private <T1 extends Formula, T2 extends Formula> T1 wrap(FormulaType<T1> targetType, T2 toWrap) {
        return this.wrappingHandler.wrap(targetType, toWrap);
    }

    private <T extends Formula> Formula unwrap(T f) {
        return this.wrappingHandler.unwrap(f);
    }

    public @Nullable Path formatFormulaOutputFile(String function, int call, String formula, int index) {
        if (this.formulaDumpFile == null) {
            return null;
        }
        return this.formulaDumpFile.getPath(new Object[]{function, call, formula, index});
    }

    public void dumpFormulaToFile(BooleanFormula f, @Nullable Path outputFile) {
        if (outputFile != null) {
            try {
                IO.writeFile((Path)outputFile, (Charset)Charset.defaultCharset(), (Object)this.dumpFormula(f));
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Failed to save formula to file");
            }
        }
    }

    public <T extends Formula> T makeVariable(FormulaType<T> formulaType, String name) {
        ArrayFormula t;
        if (formulaType.isBooleanType()) {
            t = this.booleanFormulaManager.makeVariable(name);
        } else if (formulaType.isIntegerType()) {
            t = this.getIntegerFormulaManager().makeVariable(name);
        } else if (formulaType.isRationalType()) {
            t = this.getRationalFormulaManager().makeVariable(name);
        } else if (formulaType.isBitvectorType()) {
            FormulaType.BitvectorType impl = (FormulaType.BitvectorType)formulaType;
            t = this.getBitvectorFormulaManager().makeVariable(impl.getSize(), name);
        } else if (formulaType.isFloatingPointType()) {
            t = this.getFloatingPointFormulaManager().makeVariable(name, (FormulaType.FloatingPointType)formulaType);
        } else if (formulaType.isArrayType()) {
            FormulaType.ArrayFormulaType arrayType = (FormulaType.ArrayFormulaType)formulaType;
            t = this.getArrayFormulaManager().makeArray(name, arrayType.getIndexType(), arrayType.getElementType());
        } else {
            throw new IllegalArgumentException("Unknown formula type");
        }
        BooleanFormula out = t;
        return (T)out;
    }

    public <T extends Formula> T makeNumber(FormulaType<T> formulaType, long value) {
        Object t;
        if (formulaType.isIntegerType()) {
            t = this.getIntegerFormulaManager().makeNumber(value);
        } else if (formulaType.isRationalType()) {
            t = this.getRationalFormulaManager().makeNumber(value);
        } else if (formulaType.isBitvectorType()) {
            t = this.getBitvectorFormulaManager().makeBitvector(formulaType, value);
        } else if (formulaType.isFloatingPointType()) {
            t = this.getFloatingPointFormulaManager().makeNumber(value, (FormulaType.FloatingPointType)formulaType);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeNumber(T formula, Rational value) {
        Object t;
        FormulaType<T> formulaType = this.getFormulaType(formula);
        if (formulaType.isIntegerType() && value.isIntegral()) {
            t = this.getIntegerFormulaManager().makeNumber(value.toString());
        } else if (formulaType.isRationalType()) {
            t = this.getRationalFormulaManager().makeNumber(value.toString());
        } else if (value.isIntegral() && formulaType.isBitvectorType()) {
            t = this.getBitvectorFormulaManager().makeBitvector(formulaType, new BigInteger(value.toString()));
        } else if (formulaType.isFloatingPointType()) {
            t = this.getFloatingPointFormulaManager().makeNumber(value, (FormulaType.FloatingPointType)formulaType);
        } else {
            throw new IllegalArgumentException("Not supported interface: " + formula);
        }
        return (T)t;
    }

    public <T extends Formula> T makeNumber(FormulaType<T> formulaType, BigInteger value) {
        Object t;
        if (formulaType.isIntegerType()) {
            t = this.getIntegerFormulaManager().makeNumber(value);
        } else if (formulaType.isRationalType()) {
            t = this.getRationalFormulaManager().makeNumber(value);
        } else if (formulaType.isBitvectorType()) {
            t = this.getBitvectorFormulaManager().makeBitvector(formulaType, value);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeNegate(T pNum) {
        Object t;
        if (pNum instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().negate((NumeralFormula.IntegerFormula)pNum);
        } else if (pNum instanceof NumeralFormula.RationalFormula) {
            t = this.getRationalFormulaManager().negate((NumeralFormula.RationalFormula)pNum);
        } else if (pNum instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().negate((BitvectorFormula)pNum);
        } else if (pNum instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().negate((FloatingPointFormula)pNum);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makePlus(T pF1, T pF2) {
        Object t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().add((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().add((NumeralFormula)pF1, (NumeralFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().add((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else if (pF1 instanceof FloatingPointFormula && pF2 instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().add((FloatingPointFormula)pF1, (FloatingPointFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeMinus(T pF1, T pF2) {
        Object t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().subtract((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().subtract((NumeralFormula)pF1, (NumeralFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().subtract((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else if (pF1 instanceof FloatingPointFormula && pF2 instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().subtract((FloatingPointFormula)pF1, (FloatingPointFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeMultiply(T pF1, T pF2) {
        Object t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().multiply((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().multiply((NumeralFormula)pF1, (NumeralFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().multiply((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else if (pF1 instanceof FloatingPointFormula && pF2 instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().multiply((FloatingPointFormula)pF1, (FloatingPointFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeDivide(T pF1, T pF2, boolean pSigned) {
        Object t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().divide((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().divide((NumeralFormula)pF1, (NumeralFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().divide((BitvectorFormula)pF1, (BitvectorFormula)pF2, pSigned);
        } else if (pF1 instanceof FloatingPointFormula && pF2 instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().divide((FloatingPointFormula)pF1, (FloatingPointFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeModulo(T pF1, T pF2, boolean pSigned) {
        NumeralFormula.IntegerFormula t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().modulo((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().modulo((BitvectorFormula)pF1, (BitvectorFormula)pF2, pSigned);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> BooleanFormula makeModularCongruence(T pF1, T pF2, long pModulo, boolean pSigned) {
        return this.makeModularCongruence(pF1, pF2, BigInteger.valueOf(pModulo), pSigned);
    }

    public <T extends Formula> BooleanFormula makeModularCongruence(T pF1, T pF2, BigInteger pModulo, boolean pSigned) {
        BooleanFormula t;
        if (pF1 instanceof NumeralFormula.IntegerFormula && pF2 instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().modularCongruence((NumeralFormula.IntegerFormula)pF1, (NumeralFormula.IntegerFormula)pF2, pModulo);
        } else if (pF1 instanceof NumeralFormula && pF2 instanceof NumeralFormula) {
            t = this.booleanFormulaManager.makeTrue();
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            Formula unwrapped1 = this.unwrap(pF1);
            Formula unwrapped2 = this.unwrap(pF2);
            if (unwrapped1 instanceof NumeralFormula.IntegerFormula && unwrapped2 instanceof NumeralFormula.IntegerFormula) {
                t = this.getIntegerFormulaManager().modularCongruence((NumeralFormula.IntegerFormula)unwrapped1, (NumeralFormula.IntegerFormula)unwrapped2, pModulo);
            } else {
                BitvectorFormulaManagerView bvmgr = this.getBitvectorFormulaManager();
                BitvectorFormula constant = bvmgr.makeBitvector(bvmgr.getLength((BitvectorFormula)pF1), pModulo);
                t = bvmgr.equal(bvmgr.modulo((BitvectorFormula)pF1, constant, pSigned), bvmgr.modulo((BitvectorFormula)pF2, constant, pSigned));
            }
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> T makeNot(T pF1) {
        BooleanFormula t;
        if (pF1 instanceof BooleanFormula) {
            t = this.booleanFormulaManager.not((BooleanFormula)pF1);
        } else if (pF1 instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().not((BitvectorFormula)pF1);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeAnd(T pF1, T pF2) {
        BooleanFormula t;
        if (pF1 instanceof BooleanFormula && pF2 instanceof BooleanFormula) {
            t = this.booleanFormulaManager.and((BooleanFormula)pF1, (BooleanFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().and((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeOr(T pF1, T pF2) {
        BooleanFormula t;
        if (pF1 instanceof BooleanFormula && pF2 instanceof BooleanFormula) {
            t = this.booleanFormulaManager.or((BooleanFormula)pF1, (BooleanFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().or((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeXor(T pF1, T pF2) {
        BooleanFormula t;
        if (pF1 instanceof BooleanFormula && pF2 instanceof BooleanFormula) {
            t = this.booleanFormulaManager.xor((BooleanFormula)pF1, (BooleanFormula)pF2);
        } else if (pF1 instanceof BitvectorFormula && pF2 instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().xor((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return (T)t;
    }

    public <T extends Formula> T makeShiftLeft(T pF1, T pF2) {
        if (!(pF1 instanceof BitvectorFormula) || !(pF2 instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.getBitvectorFormulaManager().shiftLeft((BitvectorFormula)pF1, (BitvectorFormula)pF2);
        return (T)t;
    }

    public <T extends Formula> T makeShiftRight(T pF1, T pF2, boolean signed) {
        if (!(pF1 instanceof BitvectorFormula) || !(pF2 instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.getBitvectorFormulaManager().shiftRight((BitvectorFormula)pF1, (BitvectorFormula)pF2, signed);
        return (T)t;
    }

    public <T extends Formula> T makeExtract(T pFormula, int pMsb, int pLsb) {
        Preconditions.checkArgument((pLsb >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((pMsb >= pLsb ? 1 : 0) != 0);
        Preconditions.checkNotNull(pFormula);
        if (!(pFormula instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.getBitvectorFormulaManager().extract((BitvectorFormula)pFormula, pMsb, pLsb);
        return (T)t;
    }

    public <T extends Formula> T makeConcat(T pFormula, T pAppendFormula) {
        if (!(pFormula instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.getBitvectorFormulaManager().concat((BitvectorFormula)pFormula, (BitvectorFormula)pAppendFormula);
        return (T)t;
    }

    public <T extends Formula> T makeConcat(List<T> formulas) {
        Preconditions.checkArgument((!formulas.isEmpty() ? 1 : 0) != 0);
        Formula conc = null;
        for (Formula t : formulas) {
            if (conc == null) {
                conc = t;
                continue;
            }
            conc = this.makeConcat(conc, t);
        }
        return (T)conc;
    }

    public <T extends Formula> T makeExtend(T pFormula, int pExtensionBits, boolean pSigned) {
        Preconditions.checkArgument((pExtensionBits >= 0 ? 1 : 0) != 0);
        if (!(pFormula instanceof BitvectorFormula)) {
            throw new IllegalArgumentException("Not supported interface");
        }
        BitvectorFormula t = this.getBitvectorFormulaManager().extend((BitvectorFormula)pFormula, pExtensionBits, pSigned);
        return (T)t;
    }

    public <T extends Formula> BooleanFormula makeEqual(T pLhs, T pRhs) {
        BooleanFormula t;
        if (pLhs instanceof BooleanFormula && pRhs instanceof BooleanFormula) {
            t = this.booleanFormulaManager.equivalence((BooleanFormula)pLhs, (BooleanFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().equal((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().equal((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().equal((BitvectorFormula)pLhs, (BitvectorFormula)pRhs);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().equalWithFPSemantics((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else if (pLhs instanceof ArrayFormula && pRhs instanceof ArrayFormula) {
            ArrayFormula rhs = (ArrayFormula)pRhs;
            t = this.getArrayFormulaManager().equivalence((ArrayFormula)pLhs, rhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> BooleanFormula makeLessOrEqual(T pLhs, T pRhs, boolean signed) {
        BooleanFormula t;
        if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().lessOrEquals((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().lessOrEquals((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula && pRhs instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().lessOrEquals((BitvectorFormula)pLhs, (BitvectorFormula)pRhs, signed);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().lessOrEquals((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else {
            throw new IllegalArgumentException("Not supported interface: " + pLhs + " " + pRhs);
        }
        return t;
    }

    public <T extends Formula> BooleanFormula makeLessThan(T pLhs, T pRhs, boolean signed) {
        BooleanFormula t;
        if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().lessThan((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().lessThan((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula && pRhs instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().lessThan((BitvectorFormula)pLhs, (BitvectorFormula)pRhs, signed);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().lessThan((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> BooleanFormula makeGreaterThan(T pLhs, T pRhs, boolean signed) {
        BooleanFormula t;
        if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().greaterThan((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().greaterThan((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula && pRhs instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().greaterThan((BitvectorFormula)pLhs, (BitvectorFormula)pRhs, signed);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().greaterThan((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> BooleanFormula makeGreaterOrEqual(T pLhs, T pRhs, boolean signed) {
        BooleanFormula t;
        if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.getIntegerFormulaManager().greaterOrEquals((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.getRationalFormulaManager().greaterOrEquals((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula && pRhs instanceof BitvectorFormula) {
            t = this.getBitvectorFormulaManager().greaterOrEquals((BitvectorFormula)pLhs, (BitvectorFormula)pRhs, signed);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            t = this.getFloatingPointFormulaManager().greaterOrEquals((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    public <T extends Formula> BooleanFormula makeElementIndexConstraint(T term, T start, long length, boolean signed) {
        FormulaType<T> type = this.getFormulaType(start);
        T end = this.makePlus(start, this.makeNumber(type, length));
        return this.booleanFormulaManager.and(this.makeLessOrEqual(start, term, signed), this.makeLessThan(term, end, signed));
    }

    public <T extends Formula> BooleanFormula makeRangeConstraint(T term, T start, T end, boolean signed) {
        return this.booleanFormulaManager.and(this.makeLessOrEqual(start, term, signed), this.makeLessOrEqual(term, end, signed));
    }

    public <T extends Formula> T makeVariable(FormulaType<T> formulaType, String name, int idx) {
        return this.makeVariable(formulaType, FormulaManagerView.makeName(name, idx));
    }

    public <T extends Formula> T makeVariableWithoutSSAIndex(FormulaType<T> formulaType, String name) {
        return this.makeVariable(formulaType, FormulaManagerView.makeNameNoIndex(name));
    }

    public IntegerFormulaManagerView getIntegerFormulaManager() throws UnsupportedOperationException {
        if (this.integerFormulaManager == null) {
            throw new UnsupportedOperationException("Integers attempted to be used but configured to be unsupported");
        }
        return this.integerFormulaManager;
    }

    public RationalFormulaManagerView getRationalFormulaManager() throws UnsupportedOperationException {
        if (this.rationalFormulaManager == null) {
            this.rationalFormulaManager = new RationalFormulaManagerView(this.wrappingHandler, (NumeralFormulaManager<NumeralFormula, NumeralFormula.RationalFormula>)this.manager.getRationalFormulaManager());
        }
        return this.rationalFormulaManager;
    }

    public BooleanFormulaManagerView getBooleanFormulaManager() {
        return this.booleanFormulaManager;
    }

    public BitvectorFormulaManagerView getBitvectorFormulaManager() throws UnsupportedOperationException {
        if (this.bitvectorFormulaManager == null) {
            throw new UnsupportedOperationException("Bitvectors attempted to be used but configured to be unsupported");
        }
        return this.bitvectorFormulaManager;
    }

    public FloatingPointFormulaManagerView getFloatingPointFormulaManager() throws UnsupportedOperationException {
        if (this.floatingPointFormulaManager == null) {
            throw new UnsupportedOperationException("Floats attempted to be used but configured to be unsupported");
        }
        return this.floatingPointFormulaManager;
    }

    public FunctionFormulaManagerView getFunctionFormulaManager() {
        return this.functionFormulaManager;
    }

    public QuantifiedFormulaManagerView getQuantifiedFormulaManager() throws UnsupportedOperationException {
        if (this.quantifiedFormulaManager == null) {
            this.quantifiedFormulaManager = new QuantifiedFormulaManagerView(this.wrappingHandler, this.manager.getQuantifiedFormulaManager(), this.booleanFormulaManager, this.getIntegerFormulaManager());
        }
        return this.quantifiedFormulaManager;
    }

    public ArrayFormulaManagerView getArrayFormulaManager() throws UnsupportedOperationException {
        if (this.arrayFormulaManager == null) {
            this.arrayFormulaManager = new ArrayFormulaManagerView(this.wrappingHandler, this.manager.getArrayFormulaManager());
        }
        return this.arrayFormulaManager;
    }

    public SLFormulaManagerView getSLFormulaManager() {
        if (this.slFormulaManager == null) {
            this.slFormulaManager = new SLFormulaManagerView(this.wrappingHandler, this.manager.getSLFormulaManager());
        }
        return this.slFormulaManager;
    }

    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        return this.wrappingHandler.getFormulaType(pFormula);
    }

    public FormulaType.BitvectorType getFormulaType(BitvectorFormula pFormula) {
        return (FormulaType.BitvectorType)this.wrappingHandler.getFormulaType(pFormula);
    }

    public FormulaType.FloatingPointType getFormulaType(FloatingPointFormula pFormula) {
        return (FormulaType.FloatingPointType)this.wrappingHandler.getFormulaType(pFormula);
    }

    public <I extends Formula, E extends Formula> FormulaType.ArrayFormulaType<I, E> getFormulaType(ArrayFormula<I, E> pFormula) {
        return (FormulaType.ArrayFormulaType)this.wrappingHandler.getFormulaType(pFormula);
    }

    private <T extends Formula> FormulaType<T> getRawFormulaType(T pFormula) {
        return this.manager.getFormulaType(pFormula);
    }

    public <T extends Formula> BooleanFormula assignment(T left, T right) {
        FormulaType<T> rformulaType;
        FormulaType<T> lformulaType = this.getFormulaType(left);
        if (!lformulaType.equals(rformulaType = this.getFormulaType(right))) {
            throw new IllegalArgumentException("Can't assign different types! (" + lformulaType + " and " + rformulaType + ")");
        }
        if (lformulaType.isFloatingPointType()) {
            return this.getFloatingPointFormulaManager().assignment((FloatingPointFormula)left, (FloatingPointFormula)right);
        }
        return this.makeEqual(left, right);
    }

    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        return this.manager.parse(pS);
    }

    static String makeName(String name, int idx) {
        Preconditions.checkArgument((name.indexOf(64) == -1 ? 1 : 0) != 0, (String)"Instantiating already instantiated variable %s with index %s", (Object)name, (int)idx);
        Preconditions.checkArgument((idx >= 0 ? 1 : 0) != 0, (String)"Invalid index %s for variable %s", (int)idx, (Object)name);
        return name + "@" + idx;
    }

    static String makeNameNoIndex(String name) {
        Preconditions.checkArgument((name.indexOf(64) == -1 ? 1 : 0) != 0, (String)"Variable with forbidden symbol '@': %s", (Object)name);
        return name + "@";
    }

    public <F extends Formula> F instantiate(F pF, SSAMap pSsa) {
        return this.wrap(this.getFormulaType(pF), this.myFreeVariableNodeTransformer(this.unwrap(pF), new HashMap<Formula, Formula>(), pFullSymbolName -> {
            int sepPos = pFullSymbolName.indexOf(64);
            if (sepPos == pFullSymbolName.length() - 1) {
                return pFullSymbolName;
            }
            if (sepPos != -1) {
                throw new IllegalArgumentException("already instantiated variable " + pFullSymbolName + " in formula");
            }
            int reInstantiateWithIndex = pSsa.getIndex((String)pFullSymbolName);
            if (reInstantiateWithIndex > 0) {
                return FormulaManagerView.makeName(pFullSymbolName, reInstantiateWithIndex);
            }
            return pFullSymbolName;
        }));
    }

    public static Pair<String, OptionalInt> parseName(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid empty name");
        List parts = INDEX_SPLITTER.splitToList((CharSequence)name);
        if (parts.size() == 2) {
            if (((String)parts.get(1)).isEmpty()) {
                return Pair.of((String)parts.get(0), OptionalInt.empty());
            }
            return Pair.of((String)parts.get(0), OptionalInt.of(Integer.parseInt((String)parts.get(1))));
        }
        if (parts.size() == 1) {
            return Pair.of((String)parts.get(0), OptionalInt.empty());
        }
        throw new IllegalArgumentException("Not an instantiated variable nor constant: " + name);
    }

    public static String instantiateVariableName(String pVar, SSAMap pSsa) {
        return FormulaManagerView.makeName(pVar, pSsa.getIndex(pVar));
    }

    public <F extends Formula> F uninstantiate(F f) {
        return this.wrap(this.getFormulaType(f), this.myFreeVariableNodeTransformer(this.unwrap(f), this.uninstantiateCache, name -> name.charAt(name.length() - 1) == '@' ? name : FormulaManagerView.parseName(name).getFirst()));
    }

    public <F extends Formula> F renameFreeVariablesAndUFs(F pFormula, Function<String, String> pRenameFunction) {
        return this.wrap(this.getFormulaType(pFormula), this.myFreeVariableNodeTransformer(this.unwrap(pFormula), new HashMap<Formula, Formula>(), pRenameFunction));
    }

    private <T extends Formula> T myFreeVariableNodeTransformer(T pFormula, final Map<Formula, Formula> pCache, final Function<String, String> pRenameFunction) {
        Preconditions.checkNotNull(pCache);
        Preconditions.checkNotNull(pFormula);
        Preconditions.checkNotNull(pRenameFunction);
        final ArrayDeque<T> toProcess = new ArrayDeque<T>();
        toProcess.push(pFormula);
        FormulaVisitor<Void> process = new FormulaVisitor<Void>(){

            public Void visitFreeVariable(Formula f, String name) {
                String newName = (String)pRenameFunction.apply(name);
                Formula renamed = FormulaManagerView.this.unwrap(FormulaManagerView.this.makeVariable(FormulaManagerView.this.getFormulaType(f), newName));
                pCache.put(f, renamed);
                return null;
            }

            public Void visitBoundVariable(Formula f, int deBruijnIdx) {
                pCache.put(f, f);
                return null;
            }

            public Void visitConstant(Formula f, Object value) {
                pCache.put(f, f);
                return null;
            }

            public Void visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> decl) {
                boolean allArgumentsTransformed = true;
                ArrayList<Formula> newArgs = new ArrayList<Formula>(args.size());
                for (Formula c : args) {
                    Formula newC = (Formula)pCache.get(c);
                    if (newC != null) {
                        newArgs.add(newC);
                        continue;
                    }
                    toProcess.push(c);
                    allArgumentsTransformed = false;
                }
                if (allArgumentsTransformed) {
                    Formula out;
                    toProcess.pop();
                    if (decl.getKind() == FunctionDeclarationKind.UF) {
                        FunctionDeclaration<Formula> uf = FormulaManagerView.this.getFunctionFormulaManager().declareUF((String)pRenameFunction.apply(decl.getName()), FormulaManagerView.this.getFormulaType(f), (List<FormulaType<?>>)decl.getArgumentTypes());
                        out = FormulaManagerView.this.unwrap(FormulaManagerView.this.getFunctionFormulaManager().callUF(uf, newArgs));
                    } else {
                        out = FormulaManagerView.this.manager.makeApplication(decl, newArgs);
                    }
                    pCache.put(f, out);
                }
                return null;
            }

            public Void visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier quantifier, List<Formula> args, BooleanFormula body) {
                BooleanFormula transformedBody = (BooleanFormula)pCache.get(body);
                if (transformedBody != null) {
                    BooleanFormula newTt = FormulaManagerView.this.getQuantifiedFormulaManager().mkQuantifier(quantifier, args, transformedBody);
                    pCache.put(f, newTt);
                } else {
                    toProcess.push(body);
                }
                return null;
            }
        };
        while (!toProcess.isEmpty()) {
            Formula tt = (Formula)toProcess.peek();
            if (pCache.containsKey(tt)) {
                toProcess.pop();
                continue;
            }
            this.visit(tt, process);
        }
        Formula result = pCache.get(pFormula);
        assert (result != null);
        assert (this.getRawFormulaType(pFormula).equals(this.getRawFormulaType(result)));
        return (T)result;
    }

    public ImmutableSet<BooleanFormula> extractAtoms(BooleanFormula pFormula, final boolean splitArithEqualities) {
        final ImmutableSet.Builder result = ImmutableSet.builder();
        this.booleanFormulaManager.visitRecursively(pFormula, (BooleanFormulaVisitor<TraversalProcess>)new DefaultBooleanFormulaVisitor<TraversalProcess>(){

            protected TraversalProcess visitDefault() {
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitQuantifier(QuantifiedFormulaManager.Quantifier quantifier, BooleanFormula quantifiedAST, List<Formula> boundVars, BooleanFormula body) {
                result.add((Object)quantifiedAST);
                return TraversalProcess.SKIP;
            }

            public TraversalProcess visitAtom(BooleanFormula atom, FunctionDeclaration<BooleanFormula> decl) {
                if (splitArithEqualities && FormulaManagerView.this.myIsPurelyArithmetic((Formula)atom)) {
                    result.addAll(FormulaManagerView.this.extractAtoms(FormulaManagerView.this.splitNumeralEqualityIfPossible(atom).get(0), false));
                }
                result.add((Object)atom);
                return TraversalProcess.CONTINUE;
            }
        });
        return result.build();
    }

    public Optional<BooleanFormula> stripNegation(BooleanFormula f) {
        return (Optional)this.booleanFormulaManager.visit(f, new DefaultBooleanFormulaVisitor<Optional<BooleanFormula>>(){

            protected Optional<BooleanFormula> visitDefault() {
                return Optional.empty();
            }

            public Optional<BooleanFormula> visitNot(BooleanFormula negated) {
                return Optional.of(negated);
            }
        });
    }

    public List<BooleanFormula> splitNumeralEqualityIfPossible(BooleanFormula formula) {
        return (List)this.visit((Formula)formula, (FormulaVisitor)new DefaultFormulaVisitor<List<BooleanFormula>>(){

            protected List<BooleanFormula> visitDefault(Formula f) {
                return ImmutableList.of((Object)((BooleanFormula)f));
            }

            public List<BooleanFormula> visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
                if (!(functionDeclaration.getKind() != FunctionDeclarationKind.EQ && functionDeclaration.getKind() != FunctionDeclarationKind.EQ_ZERO || ((FormulaType)functionDeclaration.getArgumentTypes().get(0)).isBooleanType() || ((FormulaType)functionDeclaration.getArgumentTypes().get(0)).isArrayType())) {
                    Formula arg1 = args.get(0);
                    Formula arg2 = functionDeclaration.getKind() == FunctionDeclarationKind.EQ_ZERO ? FormulaManagerView.this.makeNumber(FormulaManagerView.this.getFormulaType(arg1), 0L) : args.get(1);
                    return ImmutableList.of((Object)FormulaManagerView.this.makeLessOrEqual(arg1, arg2, true), (Object)FormulaManagerView.this.makeGreaterOrEqual(arg1, arg2, true));
                }
                return ImmutableList.of((Object)((BooleanFormula)f));
            }
        });
    }

    private boolean myIsPurelyArithmetic(Formula f) {
        Boolean result = this.arithCache.get(f);
        if (result != null) {
            return result;
        }
        final AtomicBoolean isPurelyAtomic = new AtomicBoolean(true);
        this.visitRecursively(f, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            protected TraversalProcess visitDefault(Formula pF) {
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitFunction(Formula pF, List<Formula> args, FunctionDeclaration<?> decl) {
                if (decl.getKind() == FunctionDeclarationKind.UF) {
                    isPurelyAtomic.set(false);
                    return TraversalProcess.ABORT;
                }
                return TraversalProcess.CONTINUE;
            }
        });
        result = isPurelyAtomic.get();
        this.arithCache.put(f, result);
        return result;
    }

    public Map<String, Formula> extractVariables(Formula pFormula) {
        return this.manager.extractVariables(pFormula);
    }

    public Set<String> extractVariableNames(Formula f) {
        return this.manager.extractVariables(this.unwrap(f)).keySet();
    }

    public Set<String> extractFunctionNames(Formula f) {
        return this.manager.extractVariablesAndUFs(this.unwrap(f)).keySet();
    }

    public Appender dumpFormula(BooleanFormula pT) {
        return this.manager.dumpFormula(pT);
    }

    public boolean isPurelyConjunctive(BooleanFormula t) {
        DefaultBooleanFormulaVisitor<Boolean> isAtomicVisitor = new DefaultBooleanFormulaVisitor<Boolean>(){

            protected Boolean visitDefault() {
                return false;
            }

            public Boolean visitAtom(BooleanFormula atom, FunctionDeclaration<BooleanFormula> decl) {
                return !FormulaManagerView.this.containsIfThenElse((Formula)atom);
            }
        };
        return (Boolean)this.booleanFormulaManager.visit(t, new DefaultBooleanFormulaVisitor<Boolean>((BooleanFormulaVisitor)isAtomicVisitor){
            final /* synthetic */ BooleanFormulaVisitor val$isAtomicVisitor;
            {
                this.val$isAtomicVisitor = booleanFormulaVisitor;
            }

            public Boolean visitDefault() {
                return false;
            }

            public Boolean visitConstant(boolean constantValue) {
                return true;
            }

            public Boolean visitAtom(BooleanFormula atom, FunctionDeclaration<BooleanFormula> decl) {
                return !FormulaManagerView.this.containsIfThenElse((Formula)atom);
            }

            public Boolean visitNot(BooleanFormula operand) {
                return (Boolean)FormulaManagerView.this.booleanFormulaManager.visit(operand, this.val$isAtomicVisitor);
            }

            public Boolean visitAnd(List<BooleanFormula> operands) {
                for (BooleanFormula operand : operands) {
                    if (((Boolean)FormulaManagerView.this.booleanFormulaManager.visit(operand, this)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private boolean containsIfThenElse(Formula f) {
        final AtomicBoolean containsITE = new AtomicBoolean(false);
        this.visitRecursively(f, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            protected TraversalProcess visitDefault(Formula pF) {
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitFunction(Formula pF, List<Formula> args, FunctionDeclaration<?> decl) {
                if (decl.getKind() == FunctionDeclarationKind.ITE) {
                    containsITE.set(true);
                    return TraversalProcess.ABORT;
                }
                return TraversalProcess.CONTINUE;
            }
        });
        return containsITE.get();
    }

    private BooleanFormula myGetBitwiseAxioms(BooleanFormula f) {
        final HashSet allLiterals = new HashSet();
        final AtomicBoolean andFound = new AtomicBoolean(false);
        this.visitRecursively((Formula)f, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            protected TraversalProcess visitDefault(Formula pF) {
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitConstant(Formula pF, Object value) {
                if (value instanceof Number) {
                    allLiterals.add(pF);
                }
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitFunction(Formula pF, List<Formula> args, FunctionDeclaration<?> decl) {
                if (decl.getKind() == FunctionDeclarationKind.UF && decl.getName().equals(FormulaManagerView.BitwiseAndUfName)) {
                    andFound.set(true);
                }
                return TraversalProcess.CONTINUE;
            }
        });
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        if (andFound.get()) {
            BitvectorFormulaManagerView bvmgr = this.getBitvectorFormulaManager();
            BitvectorFormula z = bvmgr.makeBitvector(1, 0L);
            FormulaType.BitvectorType type = FormulaType.getBitvectorTypeWithSize((int)1);
            for (Formula nn : allLiterals) {
                BitvectorFormula n = (BitvectorFormula)bvmgr.wrap(type, nn);
                BitvectorFormula u1 = bvmgr.and(z, n);
                BitvectorFormula u2 = bvmgr.and(n, z);
                result.add(bvmgr.equal(u1, z));
                result.add(bvmgr.equal(u2, z));
            }
        }
        return this.booleanFormulaManager.and(result);
    }

    public BooleanFormula getBitwiseAxioms(BooleanFormula f) {
        return this.myGetBitwiseAxioms(f);
    }

    public boolean useBitwiseAxioms() {
        return this.useBitwiseAxioms;
    }

    public BooleanFormula createPredicateVariable(String pName) {
        return this.booleanFormulaManager.makeVariable(pName);
    }

    public <T extends Formula> T simplify(T input) throws InterruptedException {
        return (T)this.manager.simplify(input);
    }

    public BooleanFormula substitute(BooleanFormula f, Map<? extends Formula, ? extends Formula> replacements) {
        HashMap<Formula, Formula> m = new HashMap<Formula, Formula>();
        for (Map.Entry<? extends Formula, ? extends Formula> e : replacements.entrySet()) {
            m.put(this.unwrap(e.getKey()), this.unwrap(e.getValue()));
        }
        return (BooleanFormula)this.manager.substitute((Formula)f, m);
    }

    public boolean isIntermediate(String varName, SSAMap ssa) {
        Pair<String, OptionalInt> p = FormulaManagerView.parseName(varName);
        String name = p.getFirst();
        OptionalInt idx = p.getSecond();
        return !idx.isPresent() ? ssa.containsVariable(varName) : idx.orElseThrow() != ssa.getIndex(name);
    }

    public Set<String> getDeadFunctionNames(BooleanFormula pFormula, SSAMap pSsa) {
        return this.getFunctionNames(pFormula, (Predicate<String>)((Predicate)varName -> this.isIntermediate((String)varName, pSsa)), true);
    }

    private Set<String> getFunctionNames(BooleanFormula pFormula, Predicate<String> pIsDesired, boolean extractUFs) {
        return this.myGetDesiredVariables(pFormula, pIsDesired, extractUFs).keySet();
    }

    private Map<String, Formula> myGetDesiredVariables(BooleanFormula pFormula, Predicate<String> pIsDesired, boolean extractUF) {
        HashMap<String, Formula> result = new HashMap<String, Formula>();
        Map vars = extractUF ? this.manager.extractVariablesAndUFs((Formula)pFormula) : this.manager.extractVariables((Formula)pFormula);
        for (Map.Entry entry : vars.entrySet()) {
            String name = (String)entry.getKey();
            Formula varFormula = (Formula)entry.getValue();
            if (!pIsDesired.apply((Object)name)) continue;
            result.put(name, varFormula);
        }
        return result;
    }

    public BooleanFormula eliminateDeadVariables(BooleanFormula pF, SSAMap pSsa) throws SolverException, InterruptedException {
        Preconditions.checkNotNull((Object)pSsa);
        return this.eliminateVariables(pF, (Predicate<String>)((Predicate)varName -> this.isIntermediate((String)varName, pSsa)));
    }

    public BooleanFormula eliminateVariables(BooleanFormula pF, Predicate<String> pToEliminate) throws SolverException, InterruptedException {
        Preconditions.checkNotNull((Object)pF);
        Preconditions.checkNotNull(pToEliminate);
        Map<String, Formula> irrelevantVariables = this.myGetDesiredVariables(pF, pToEliminate, false);
        BooleanFormula eliminationResult = pF;
        if (!irrelevantVariables.isEmpty()) {
            QuantifiedFormulaManagerView qfmgr = this.getQuantifiedFormulaManager();
            BooleanFormula quantifiedFormula = qfmgr.exists((List<? extends Formula>)ImmutableList.copyOf(irrelevantVariables.values()), pF);
            eliminationResult = qfmgr.eliminateQuantifiers(quantifiedFormula);
        }
        eliminationResult = this.simplify(eliminationResult);
        return eliminationResult;
    }

    public BooleanFormula quantifyDeadVariables(BooleanFormula pF, SSAMap pSSAMap) {
        Map<String, Formula> irrelevantVariables = this.myGetDesiredVariables(pF, (Predicate<String>)((Predicate)varName -> this.isIntermediate((String)varName, pSSAMap)), false);
        if (irrelevantVariables.isEmpty()) {
            return pF;
        }
        return this.getQuantifiedFormulaManager().exists((List<? extends Formula>)ImmutableList.copyOf(irrelevantVariables.values()), pF);
    }

    public <T extends Formula> Optional<Triple<BooleanFormula, T, T>> splitIfThenElse(final T pF) {
        return (Optional)this.visit(pF, (FormulaVisitor)new DefaultFormulaVisitor<Optional<Triple<BooleanFormula, T, T>>>(){

            protected Optional<Triple<BooleanFormula, T, T>> visitDefault(Formula f) {
                return Optional.empty();
            }

            public Optional<Triple<BooleanFormula, T, T>> visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
                if (functionDeclaration.getKind() == FunctionDeclarationKind.ITE) {
                    assert (args.size() == 3);
                    BooleanFormula cond = (BooleanFormula)args.get(0);
                    Formula thenBranch = args.get(1);
                    Formula elseBranch = args.get(2);
                    FormulaType<Formula> targetType = FormulaManagerView.this.getFormulaType(pF);
                    return Optional.of(Triple.of(cond, FormulaManagerView.this.wrap(targetType, thenBranch), FormulaManagerView.this.wrap(targetType, elseBranch)));
                }
                return Optional.empty();
            }
        });
    }

    public BooleanFormula applyTactic(BooleanFormula input, Tactic tactic) throws InterruptedException {
        return this.manager.applyTactic(input, tactic);
    }

    @CanIgnoreReturnValue
    public <R> R visit(Formula f, FormulaVisitor<R> rFormulaVisitor) {
        return (R)this.manager.visit(this.unwrap(f), rFormulaVisitor);
    }

    public void visitRecursively(Formula f, FormulaVisitor<TraversalProcess> rFormulaVisitor) {
        this.manager.visitRecursively(this.unwrap(f), rFormulaVisitor);
    }

    public <T extends Formula> T transformRecursively(T f, FormulaTransformationVisitor pFormulaVisitor) {
        Formula out = this.manager.transformRecursively(this.unwrap(f), (org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor)new UnwrappingFormulaTransformationVisitor(pFormulaVisitor));
        return (T)out;
    }

    public BooleanFormula filterLiterals(BooleanFormula input, final Predicate<BooleanFormula> toKeep) throws InterruptedException {
        BooleanFormula nnf = this.applyTactic(input, Tactic.NNF);
        BooleanFormula nnfNotTransformed = this.booleanFormulaManager.transformRecursively(nnf, new BooleanFormulaManagerView.BooleanFormulaTransformationVisitor(this){

            public BooleanFormula visitNot(BooleanFormula pOperand) {
                if (!toKeep.apply((Object)pOperand)) {
                    return FormulaManagerView.this.booleanFormulaManager.makeTrue();
                }
                return super.visitNot(pOperand);
            }
        });
        return this.booleanFormulaManager.transformRecursively(nnfNotTransformed, new BooleanFormulaManagerView.BooleanFormulaTransformationVisitor(this){

            public BooleanFormula visitAtom(BooleanFormula pOperand, FunctionDeclaration<BooleanFormula> decl) {
                if (!toKeep.apply((Object)pOperand)) {
                    return FormulaManagerView.this.booleanFormulaManager.makeTrue();
                }
                return super.visitAtom(pOperand, decl);
            }
        });
    }

    public BooleanFormula translateFrom(BooleanFormula other, FormulaManagerView otherManager) {
        return this.manager.translateFrom(other, otherManager.manager);
    }

    public String dumpArbitraryFormula(Formula f) {
        Formula dummyVar = this.makeVariable(this.getFormulaType(f), DUMMY_VAR);
        return this.dumpFormula(this.makeEqual(dummyVar, f)).toString();
    }

    public Formula parseArbitraryFormula(String s) {
        BooleanFormula f = this.parse(s);
        return (Formula)this.visit((Formula)f, (FormulaVisitor)new DefaultFormulaVisitor<Formula>(){

            protected Formula visitDefault(Formula pF) {
                throw new AssertionError((Object)("Unexpected formula " + pF));
            }

            public Formula visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pDecl) {
                if (pDecl.getKind() != FunctionDeclarationKind.EQ && pArgs.size() != 2) {
                    return this.visitDefault(pF);
                }
                Formula dummyVar = FormulaManagerView.this.makeVariable(FormulaManagerView.this.getFormulaType(pArgs.get(0)), FormulaManagerView.DUMMY_VAR);
                if (pArgs.get(0).equals((Object)dummyVar)) {
                    return pArgs.get(1);
                }
                if (pArgs.get(1).equals((Object)dummyVar)) {
                    return pArgs.get(0);
                }
                return this.visitDefault(pF);
            }
        });
    }

    public BooleanFormula simplifyBooleanFormula(BooleanFormula formula) {
        return this.simplifyBooleanFormula0(formula, new HashMap<BooleanFormula, BooleanFormula>(), this.getBooleanFormulaManager());
    }

    private BooleanFormula simplifyBooleanFormula0(BooleanFormula formula, Map<BooleanFormula, BooleanFormula> cache, BooleanFormulaManager bmgr) {
        Set disjunctionSet = bmgr.toDisjunctionArgs(formula, true);
        if (disjunctionSet.size() <= 1) {
            return formula;
        }
        ArrayList listOfOperands = new ArrayList();
        for (Object subformula : disjunctionSet) {
            Set set = bmgr.toConjunctionArgs((BooleanFormula)subformula, true);
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            listOfOperands.add(linkedHashSet);
            for (BooleanFormula formulaInConjunctionSet : set) {
                BooleanFormula transformedFormula = cache.get(formulaInConjunctionSet);
                if (transformedFormula == null) {
                    transformedFormula = this.simplifyBooleanFormula0(formulaInConjunctionSet, cache, bmgr);
                    cache.put(formulaInConjunctionSet, transformedFormula);
                }
                linkedHashSet.addAll(bmgr.toConjunctionArgs(transformedFormula, true));
            }
        }
        LinkedHashSet mutualOperandsSet = new LinkedHashSet((Collection)listOfOperands.get(0));
        for (Set set : listOfOperands) {
            mutualOperandsSet.retainAll(set);
        }
        ArrayList<BooleanFormula> transformedSubformulas = new ArrayList<BooleanFormula>();
        for (Set set : listOfOperands) {
            set.removeAll(mutualOperandsSet);
            transformedSubformulas.add(bmgr.and((Collection)set));
        }
        return bmgr.and(bmgr.and(mutualOperandsSet), bmgr.or(transformedSubformulas));
    }

    public BigInteger countBooleanOperations(BooleanFormula f) {
        final HashMap<Formula, BigInteger> cache = new HashMap<Formula, BigInteger>();
        final ArrayDeque<BooleanFormula> waitlist = new ArrayDeque<BooleanFormula>();
        DefaultFormulaVisitor<@Nullable BigInteger> countingVisitor = new DefaultFormulaVisitor<BigInteger>(){

            protected BigInteger visitDefault(Formula pF) {
                return BigInteger.ZERO;
            }

            public @Nullable BigInteger visitFunction(Formula pF, List<Formula> args, FunctionDeclaration<?> decl) {
                assert (!args.isEmpty());
                switch (decl.getKind()) {
                    case AND: 
                    case OR: 
                    case NOT: {
                        BigInteger count = BigInteger.valueOf(args.size());
                        for (Formula arg : args) {
                            BigInteger subCount = (BigInteger)cache.get(arg);
                            if (subCount == null) {
                                waitlist.push(pF);
                                waitlist.push(arg);
                                return null;
                            }
                            count = count.add(subCount);
                        }
                        return count;
                    }
                }
                return this.visitDefault(pF);
            }
        };
        waitlist.push(f);
        while (!waitlist.isEmpty()) {
            Formula formula = (Formula)waitlist.pop();
            @Nullable BigInteger count = (BigInteger)this.visit(formula, (FormulaVisitor)countingVisitor);
            if (count == null) continue;
            cache.put(formula, count);
        }
        return (BigInteger)cache.get(f);
    }

    private class UnwrappingFormulaTransformationVisitor
    extends org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor {
        private final FormulaTransformationVisitor delegate;

        protected UnwrappingFormulaTransformationVisitor(FormulaTransformationVisitor pDelegate) {
            super(FormulaManagerView.this.manager);
            this.delegate = Objects.requireNonNull(pDelegate);
        }

        public Formula visitBoundVariable(Formula pF, int pDeBruijnIdx) {
            return FormulaManagerView.this.unwrap(this.delegate.visitBoundVariable(pF, pDeBruijnIdx));
        }

        public Formula visitFreeVariable(Formula pF, String pName) {
            return FormulaManagerView.this.unwrap(this.delegate.visitFreeVariable(pF, pName));
        }

        public Formula visitFunction(Formula pF, List<Formula> pNewArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            return FormulaManagerView.this.unwrap(this.delegate.visitFunction(pF, pNewArgs, pFunctionDeclaration));
        }

        public Formula visitConstant(Formula pF, Object pValue) {
            return FormulaManagerView.this.unwrap(this.delegate.visitConstant(pF, pValue));
        }

        public BooleanFormula visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQuantifier, List<Formula> pBoundVariables, BooleanFormula pTransformedBody) {
            return this.delegate.visitQuantifier(pF, pQuantifier, pBoundVariables, pTransformedBody);
        }
    }

    public static class FormulaTransformationVisitor
    extends org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor {
        protected FormulaTransformationVisitor(FormulaManagerView fmgr) {
            super(fmgr.manager);
        }
    }

    static enum Theory {
        UNSUPPORTED,
        INTEGER,
        RATIONAL,
        BITVECTOR,
        FLOAT;


        String description() {
            if (this == INTEGER) {
                return "unbounded integers";
            }
            return this.name().toLowerCase() + "s";
        }
    }
}

