/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.QuantifiedFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.NumeralFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
public class FormulaManagerViewTest
extends SolverViewBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverToUse;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverToUse;
    }

    private BooleanFormula stripNot(BooleanFormula f) {
        return this.mgrv.stripNegation(f).orElse(f);
    }

    @Test
    public void testExtractAtoms() {
        BooleanFormula atom1 = this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a")), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        BooleanFormula atom2 = this.imgr.greaterThan((NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("b")), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
        BooleanFormula atom3 = this.imgr.greaterOrEquals((NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("c")), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L)));
        BooleanFormula atom4 = this.imgr.lessThan((NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("d")), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L)));
        BooleanFormula atom5 = this.imgr.lessOrEquals((NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("e")), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)));
        BooleanFormula f = this.bmgrv.or(this.bmgrv.and(atom1, atom2), this.bmgrv.and(atom1, atom3), atom4, atom5);
        Truth.assertThat(this.mgrv.extractAtoms(f, false)).containsExactly(new Object[]{this.stripNot(atom1), this.stripNot(atom2), this.stripNot(atom3), this.stripNot(atom4), this.stripNot(atom5)});
    }

    private void testExtractAtoms_SplitEqualities(BooleanFormula atom1, BooleanFormula atom1ineq, BooleanFormula atom2, BooleanFormula atom3, BooleanFormula atom4, BooleanFormula atom5) throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgrv.or(this.bmgrv.and(atom1, atom2), this.bmgrv.and(atom1, atom3), atom4, atom5);
        Sets.SetView atoms = this.mgrv.extractAtoms(f, true);
        ImmutableSet expected = ImmutableSet.of((Object)this.stripNot(atom1), (Object)this.stripNot(atom2), (Object)this.stripNot(atom3), (Object)this.stripNot(atom4), (Object)this.stripNot(atom5));
        Truth.assertThat(atoms).hasSize(6);
        Truth.assertThat(atoms).containsAtLeastElementsIn((Iterable)expected);
        atoms = Sets.difference(atoms, (Set)expected);
        BooleanFormula remainingAtom = (BooleanFormula)Iterables.getOnlyElement((Iterable)atoms);
        this.assertThatFormula(remainingAtom).isEquivalentTo(this.stripNot(atom1ineq));
    }

    private <T extends NumeralFormula> void testExtractAtoms_SplitEqualities_numeral(NumeralFormulaManager<T, ? extends T> nmgr) throws SolverException, InterruptedException {
        BooleanFormula atom1 = nmgr.equal(nmgr.makeVariable("a"), nmgr.makeNumber(1L));
        BooleanFormula atom1ineq = nmgr.lessOrEquals(nmgr.makeVariable("a"), nmgr.makeNumber(1L));
        BooleanFormula atom2 = nmgr.greaterThan(nmgr.makeVariable("b"), nmgr.makeNumber(2L));
        BooleanFormula atom3 = nmgr.greaterOrEquals(nmgr.makeVariable("c"), nmgr.makeNumber(3L));
        BooleanFormula atom4 = nmgr.lessThan(nmgr.makeVariable("d"), nmgr.makeNumber(4L));
        BooleanFormula atom5 = nmgr.lessOrEquals(nmgr.makeVariable("e"), nmgr.makeNumber(5L));
        this.testExtractAtoms_SplitEqualities(atom1, atom1ineq, atom2, atom3, atom4, atom5);
    }

    @Test
    public void testExtractAtoms_SplitEqualities_int() throws SolverException, InterruptedException {
        this.testExtractAtoms_SplitEqualities_numeral((NumeralFormulaManager)this.imgr);
    }

    @Test
    public void testExtractAtoms_SplitEqualities_rat() throws SolverException, InterruptedException {
        this.requireRationals();
        this.testExtractAtoms_SplitEqualities_numeral((NumeralFormulaManager)this.rmgr);
    }

    @Test
    public void testExtractAtoms_SplitEqualities_bitvectors() throws SolverException, InterruptedException {
        this.bvmgr = this.mgrv.getBitvectorFormulaManager();
        BooleanFormula atom1 = this.bvmgr.equal(this.bvmgr.makeVariable(32, "a"), this.bvmgr.makeBitvector(32, 1L));
        BooleanFormula atom1ineq = this.bvmgr.lessOrEquals(this.bvmgr.makeVariable(32, "a"), this.bvmgr.makeBitvector(32, 1L), true);
        BooleanFormula atom2 = this.bvmgr.greaterThan(this.bvmgr.makeVariable(32, "b"), this.bvmgr.makeBitvector(32, 2L), true);
        BooleanFormula atom3 = this.bvmgr.greaterOrEquals(this.bvmgr.makeVariable(32, "c"), this.bvmgr.makeBitvector(32, 3L), true);
        BooleanFormula atom4 = this.bvmgr.lessThan(this.bvmgr.makeVariable(32, "d"), this.bvmgr.makeBitvector(32, 4L), true);
        BooleanFormula atom5 = this.bvmgr.lessOrEquals(this.bvmgr.makeVariable(32, "e"), this.bvmgr.makeBitvector(32, 5L), true);
        this.testExtractAtoms_SplitEqualities(atom1, atom1ineq, atom2, atom3, atom4, atom5);
    }

    private void assertIsConjunctive(BooleanFormula f) {
        Truth.assertWithMessage((String)"formula <%s> detected as purely conjunctive: false", (Object[])new Object[]{f}).that(Boolean.valueOf(this.mgrv.isPurelyConjunctive(f))).isTrue();
    }

    private void assertIsNotConjunctive(BooleanFormula f) {
        Truth.assertWithMessage((String)"formula <%s> detected as purely conjunctive: true", (Object[])new Object[]{f}).that(Boolean.valueOf(this.mgrv.isPurelyConjunctive(f))).isFalse();
    }

    @Test
    public void testIsPurelyConjunctive_Simple() {
        this.assertIsConjunctive(this.bmgrv.makeTrue());
        this.assertIsConjunctive(this.bmgrv.makeFalse());
        this.assertIsConjunctive(this.bmgrv.makeVariable("a"));
        this.assertIsConjunctive(this.bmgrv.not(this.bmgrv.makeVariable("a")));
        this.assertIsConjunctive(this.bmgrv.and(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b")));
        this.assertIsConjunctive(this.bmgrv.and(this.bmgrv.makeVariable("a"), this.bmgrv.not(this.bmgrv.makeVariable("b"))));
    }

    @Test
    public void testIsPurelyConjunctive_Atom() {
        BooleanFormula atom = this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        this.assertIsConjunctive(atom);
        this.assertIsConjunctive(this.bmgrv.not(atom));
        this.assertIsConjunctive(this.bmgrv.and(this.bmgrv.makeVariable("a"), atom));
        this.assertIsConjunctive(this.bmgrv.and(this.bmgrv.makeVariable("a"), this.bmgrv.not(atom)));
    }

    @Test
    public void testIsPurelyConjunctive_Negation() {
        this.assertIsNotConjunctive(this.bmgrv.not(this.bmgrv.and(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b"))));
    }

    @Test
    public void testIsPurelyConjunctive_Disjunction() {
        this.assertIsNotConjunctive(this.bmgrv.or(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b")));
    }

    @Test
    public void testIsPurelyConjunctive_Equivalence() {
        this.assertIsNotConjunctive(this.bmgrv.equivalence(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b")));
        this.assertIsNotConjunctive(this.bmgr.not(this.bmgrv.equivalence(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b"))));
    }

    @Test
    public void testIsPurelyConjunctive_Implication() {
        this.assertIsNotConjunctive(this.bmgrv.implication(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b")));
        this.assertIsNotConjunctive(this.bmgr.not(this.bmgrv.implication(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b"))));
    }

    @Test
    public void testIsPurelyConjunctive_Xor() {
        this.assertIsNotConjunctive(this.bmgrv.xor(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b")));
        this.assertIsNotConjunctive(this.bmgr.not(this.bmgrv.xor(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b"))));
    }

    @Test
    public void testIsPurelyConjunctive_BooleanIfThenElse() {
        this.assertIsNotConjunctive(this.bmgrv.ifThenElse(this.bmgrv.makeVariable("a"), this.bmgrv.makeVariable("b"), this.bmgrv.makeVariable("c")));
    }

    @Test
    public void testIsPurelyConjunctive_IfThenElse() {
        NumeralFormula.IntegerFormula ifThenElse = this.bmgrv.ifThenElse(this.bmgrv.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        BooleanFormula atom = this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")), (NumeralFormula)ifThenElse);
        this.assertIsNotConjunctive(atom);
        this.assertIsNotConjunctive(this.bmgrv.not(atom));
        this.assertIsNotConjunctive(this.bmgrv.and(this.bmgrv.makeVariable("a"), atom));
        this.assertIsNotConjunctive(this.bmgrv.and(this.bmgrv.makeVariable("a"), this.bmgrv.not(atom)));
    }

    @Test
    public void testUnInstantiateQuantifiersAndArrays() throws SolverException, InterruptedException {
        this.requireQuantifiers();
        this.requireArrays();
        NumeralFormula.IntegerFormula _0 = (NumeralFormula.IntegerFormula)this.imgrv.makeNumber(0L);
        NumeralFormula.IntegerFormula _i = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("i");
        NumeralFormula.IntegerFormula _i1 = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("i", 1);
        NumeralFormula.IntegerFormula _j = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("j");
        NumeralFormula.IntegerFormula _j1 = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("j", 1);
        NumeralFormula.IntegerFormula _x = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x");
        ArrayFormulaManagerView amgrv = this.mgrv.getArrayFormulaManager();
        ArrayFormula _b = amgrv.makeArray("b", FormulaType.IntegerType, FormulaType.IntegerType);
        BooleanFormula _b_at_x_NOTEQ_0 = this.bmgrv.not(this.imgrv.equal((NumeralFormula.IntegerFormula)amgrv.select(_b, _x), _0));
        QuantifiedFormulaManagerView qmv = this.mgrv.getQuantifiedFormulaManager();
        BooleanFormula instantiated = qmv.forall((Formula)_x, this.bmgrv.and(_b_at_x_NOTEQ_0, this.imgrv.greaterOrEquals(_x, _j1), this.imgrv.lessOrEquals(_x, _i1)));
        BooleanFormula uninstantiated = qmv.forall((Formula)_x, this.bmgrv.and(_b_at_x_NOTEQ_0, this.imgrv.greaterOrEquals(_x, _j), this.imgrv.lessOrEquals(_x, _i)));
        SSAMap.SSAMapBuilder ssaBuilder = SSAMap.emptySSAMap().builder();
        ssaBuilder.setIndex("i", CNumericTypes.INT, 1);
        ssaBuilder.setIndex("j", CNumericTypes.INT, 1);
        this.testUnInstantiate(instantiated, uninstantiated, ssaBuilder);
    }

    @Test
    public void testUnInstantiate() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula _0 = (NumeralFormula.IntegerFormula)this.imgrv.makeNumber(0L);
        NumeralFormula.IntegerFormula _1 = (NumeralFormula.IntegerFormula)this.imgrv.makeNumber(1L);
        NumeralFormula.IntegerFormula _i = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("i");
        NumeralFormula.IntegerFormula _i1 = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("i", 1);
        NumeralFormula.IntegerFormula _j = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("j");
        NumeralFormula.IntegerFormula _j1 = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("j", 1);
        NumeralFormula.IntegerFormula _x = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x");
        NumeralFormula.IntegerFormula _x1 = (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x", 1);
        BooleanFormula _inst1 = this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.add(_1, _j1), (NumeralFormula.IntegerFormula)this.imgrv.add(_0, _i1));
        BooleanFormula _inst2 = this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.add(_1, (NumeralFormula.IntegerFormula)this.imgrv.subtract(_0, _i1)), (NumeralFormula.IntegerFormula)this.imgrv.add((NumeralFormula.IntegerFormula)this.imgrv.add(_0, _x1), _i1));
        BooleanFormula _inst3 = this.bmgrv.and(_inst1, _inst2, this.bmgrv.not(_inst1));
        BooleanFormula _uinst1 = this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.add(_1, _j), (NumeralFormula.IntegerFormula)this.imgrv.add(_0, _i));
        BooleanFormula _uinst2 = this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.add(_1, (NumeralFormula.IntegerFormula)this.imgrv.subtract(_0, _i)), (NumeralFormula.IntegerFormula)this.imgrv.add((NumeralFormula.IntegerFormula)this.imgrv.add(_0, _x), _i));
        BooleanFormula _uinst3 = this.bmgrv.and(_uinst1, _uinst2, this.bmgrv.not(_uinst1));
        SSAMap.SSAMapBuilder ssaBuilder = SSAMap.emptySSAMap().builder();
        ssaBuilder.setIndex("i", CNumericTypes.INT, 1);
        ssaBuilder.setIndex("j", CNumericTypes.INT, 1);
        ssaBuilder.setIndex("x", CNumericTypes.INT, 1);
        this.testUnInstantiate(_inst3, _uinst3, ssaBuilder);
    }

    private void testUnInstantiate(BooleanFormula pInstantiated, BooleanFormula pUninstantiated, SSAMap.SSAMapBuilder pSsaBuilder) throws SolverException, InterruptedException {
        BooleanFormula r1 = this.mgrv.instantiate(pUninstantiated, pSsaBuilder.build());
        this.assertThatFormula(r1).isEquivalentTo(pInstantiated);
        Truth.assertThat((String)r1.toString()).isEqualTo((Object)pInstantiated.toString());
        BooleanFormula r2 = this.mgrv.uninstantiate(pInstantiated);
        this.assertThatFormula(r2).isEquivalentTo(pUninstantiated);
        Truth.assertThat((String)r2.toString()).isEqualTo((Object)pUninstantiated.toString());
    }
}

