/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;

public class FormulaToCVisitor
implements FormulaVisitor<Boolean> {
    private static final String LLONG_MIN_LITERAL = "9223372036854775808";
    private static final String INT_MIN_LITERAL = "2147483648";
    private final StringBuilder builder = new StringBuilder();
    private final FormulaManagerView fmgr;
    private boolean bvSigned = false;
    private static final ImmutableSet<FunctionDeclarationKind> UNARY_OPS = Sets.immutableEnumSet((Enum)FunctionDeclarationKind.UMINUS, (Enum[])new FunctionDeclarationKind[]{FunctionDeclarationKind.NOT, FunctionDeclarationKind.GTE_ZERO, FunctionDeclarationKind.EQ_ZERO, FunctionDeclarationKind.FP_NEG, FunctionDeclarationKind.BV_NOT, FunctionDeclarationKind.BV_NEG});

    public FormulaToCVisitor(FormulaManagerView fmgr) {
        this.fmgr = fmgr;
    }

    public Boolean visitFreeVariable(Formula pF, String pName) {
        int index = pName.lastIndexOf(":");
        if (index != -1) {
            pName = pName.substring(index + 1);
        }
        this.builder.append(pName);
        return Boolean.TRUE;
    }

    public Boolean visitBoundVariable(Formula pF, int pDeBruijnIdx) {
        return Boolean.TRUE;
    }

    public Boolean visitConstant(Formula pF, Object pValue) {
        FormulaType<Formula> type = this.fmgr.getFormulaType(pF);
        String value = pValue.toString();
        if (type.isBitvectorType()) {
            int size = ((FormulaType.BitvectorType)type).getSize();
            switch (size) {
                case 32: {
                    if (this.appendOverflowGuardForNegativeIntegralLiterals(INT_MIN_LITERAL, pValue)) {
                        return Boolean.TRUE;
                    }
                }
                case 64: {
                    if (!this.appendOverflowGuardForNegativeIntegralLiterals(LLONG_MIN_LITERAL, pValue)) break;
                    return Boolean.TRUE;
                }
            }
            this.builder.append(value);
        } else if (pValue instanceof Boolean) {
            this.builder.append((Boolean)pValue != false ? "1" : "0");
        } else {
            this.builder.append(value);
        }
        return Boolean.TRUE;
    }

    private boolean appendOverflowGuardForNegativeIntegralLiterals(String pGuardString, Object pValue) {
        if (pValue instanceof BigInteger) {
            String valueString = pValue.toString();
            if (valueString.equals("-" + pGuardString)) {
                this.builder.append("( ( ").append(((BigInteger)pValue).add(BigInteger.ONE)).append(" ) - 1 )");
                return true;
            }
            if (this.bvSigned && valueString.equals(pGuardString)) {
                this.builder.append("( ( -").append(((BigInteger)pValue).subtract(BigInteger.ONE)).append(" ) - 1 )");
                return true;
            }
        }
        return false;
    }

    public Boolean visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
        String op = null;
        FunctionDeclarationKind kind = pFunctionDeclaration.getKind();
        boolean signedCarryThrough = false;
        if (this.bvSigned) {
            signedCarryThrough = true;
            this.bvSigned = false;
        }
        switch (kind) {
            case BV_ADD: 
            case FP_ADD: 
            case ADD: {
                op = "+";
                break;
            }
            case BV_SUB: 
            case BV_NEG: 
            case FP_SUB: 
            case FP_NEG: 
            case UMINUS: 
            case SUB: {
                op = "-";
                break;
            }
            case BV_SDIV: {
                this.bvSigned = true;
            }
            case BV_UDIV: 
            case FP_DIV: 
            case DIV: {
                op = "/";
                break;
            }
            case BV_SREM: {
                this.bvSigned = true;
            }
            case BV_UREM: 
            case MODULO: {
                op = "%";
                break;
            }
            case BV_MUL: 
            case FP_MUL: 
            case MUL: {
                op = "*";
                break;
            }
            case BV_EQ: 
            case FP_EQ: 
            case IFF: 
            case EQ: {
                op = "==";
                break;
            }
            case BV_SGT: {
                this.bvSigned = true;
            }
            case BV_UGT: 
            case FP_GT: 
            case GT: {
                op = ">";
                break;
            }
            case BV_SGE: {
                this.bvSigned = true;
            }
            case BV_UGE: 
            case FP_GE: 
            case GTE: {
                op = ">=";
                break;
            }
            case BV_SLT: {
                this.bvSigned = true;
            }
            case BV_ULT: 
            case FP_LT: 
            case LT: {
                op = "<";
                break;
            }
            case BV_SLE: {
                this.bvSigned = true;
            }
            case BV_ULE: 
            case FP_LE: 
            case LTE: {
                op = "<=";
                break;
            }
            case BV_NOT: {
                op = "~";
                break;
            }
            case NOT: {
                op = "!";
                break;
            }
            case BV_XOR: 
            case XOR: {
                op = "^";
                break;
            }
            case BV_AND: {
                op = "&";
                break;
            }
            case AND: {
                op = "&&";
                break;
            }
            case BV_OR: {
                op = "|";
                break;
            }
            case OR: {
                op = "||";
                break;
            }
            case GTE_ZERO: {
                op = "0 <=";
                break;
            }
            case EQ_ZERO: {
                op = "0 ==";
                break;
            }
            case ITE: {
                break;
            }
            case BV_SHL: {
                op = "<<";
                break;
            }
            case BV_LSHR: 
            case BV_ASHR: {
                op = ">>";
                break;
            }
            default: {
                return Boolean.FALSE;
            }
        }
        this.builder.append("( ");
        if (pArgs.size() == 3 && pFunctionDeclaration.getKind() == FunctionDeclarationKind.ITE) {
            if (!this.fmgr.visit(pArgs.get(0), this).booleanValue()) {
                return Boolean.FALSE;
            }
            this.builder.append(" ? ");
            if (!this.fmgr.visit(pArgs.get(1), this).booleanValue()) {
                return Boolean.FALSE;
            }
            this.builder.append(" : ");
            if (!this.fmgr.visit(pArgs.get(2), this).booleanValue()) {
                return Boolean.FALSE;
            }
        } else if (pArgs.size() == 1 && UNARY_OPS.contains((Object)kind)) {
            this.builder.append(op).append(" ");
            if (!this.fmgr.visit(pArgs.get(0), this).booleanValue()) {
                return Boolean.FALSE;
            }
        } else if (kind == FunctionDeclarationKind.AND || kind == FunctionDeclarationKind.OR) {
            for (int i = 0; i < pArgs.size(); ++i) {
                if (!this.fmgr.visit(pArgs.get(i), this).booleanValue()) {
                    return Boolean.FALSE;
                }
                if (i == pArgs.size() - 1) continue;
                this.builder.append(" ").append(op).append(" ");
            }
        } else if (pArgs.size() == 2) {
            if (!this.fmgr.visit(pArgs.get(0), this).booleanValue()) {
                return Boolean.FALSE;
            }
            this.builder.append(" ").append(op).append(" ");
            if (!this.fmgr.visit(pArgs.get(1), this).booleanValue()) {
                return Boolean.FALSE;
            }
        } else {
            throw new AssertionError((Object)String.format("Function call '%s' with unexpected number of arguments: %s", pFunctionDeclaration.getName(), pArgs));
        }
        this.builder.append(" )");
        this.bvSigned = signedCarryThrough;
        return Boolean.TRUE;
    }

    public Boolean visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQuantifier, List<Formula> pBoundVariables, BooleanFormula pBody) {
        return Boolean.TRUE;
    }

    public String getString() {
        String result = this.builder.toString();
        this.builder.setLength(0);
        return result;
    }
}

