/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.ReplaceIntegerWithBitvectorTheory;
import org.sosy_lab.cpachecker.util.predicates.smt.WrappingFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;

final class FormulaWrappingHandler {
    private final FormulaManagerView.Theory encodeBitvectorAs;
    private final FormulaManagerView.Theory encodeFloatAs;
    private final FormulaManagerView.Theory encodeIntegerAs;
    private final ReplaceIntegerWithBitvectorTheory.ReplaceIntegerEncodingOptions intOptions;
    private final FormulaManager manager;

    FormulaWrappingHandler(FormulaManager pRawManager, FormulaManagerView.Theory pEncodeBitvectorAs, FormulaManagerView.Theory pEncodeFloatAs, FormulaManagerView.Theory pEncodeIntegerAs, ReplaceIntegerWithBitvectorTheory.ReplaceIntegerEncodingOptions pIntOptions) {
        this.manager = (FormulaManager)Preconditions.checkNotNull((Object)pRawManager);
        this.encodeBitvectorAs = (FormulaManagerView.Theory)((Object)Preconditions.checkNotNull((Object)((Object)pEncodeBitvectorAs)));
        this.encodeFloatAs = (FormulaManagerView.Theory)((Object)Preconditions.checkNotNull((Object)((Object)pEncodeFloatAs)));
        this.encodeIntegerAs = (FormulaManagerView.Theory)((Object)Preconditions.checkNotNull((Object)((Object)pEncodeIntegerAs)));
        this.intOptions = (ReplaceIntegerWithBitvectorTheory.ReplaceIntegerEncodingOptions)Preconditions.checkNotNull((Object)pIntOptions);
        assert (this.encodeBitvectorAs != FormulaManagerView.Theory.FLOAT) : "can not encode bitvectors as floats";
        assert (this.encodeFloatAs != FormulaManagerView.Theory.BITVECTOR) : "can not encode floats as bitvectors";
    }

    boolean useBitvectors() {
        return this.encodeBitvectorAs == FormulaManagerView.Theory.BITVECTOR;
    }

    <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        Preconditions.checkNotNull(pFormula);
        if (pFormula instanceof WrappingFormula) {
            WrappingFormula castFormula = (WrappingFormula)pFormula;
            return castFormula.getType();
        }
        return this.getRawFormulaType(pFormula);
    }

    <T extends Formula> FormulaType<T> getRawFormulaType(T pFormula) {
        assert (!(pFormula instanceof WrappingFormula));
        return this.manager.getFormulaType(pFormula);
    }

    <T1 extends Formula, T2 extends Formula> T1 wrap(FormulaType<T1> targetType, T2 toWrap) {
        if (toWrap instanceof WrappingFormula) {
            throw new IllegalArgumentException(String.format("Cannot double-wrap a formula %s, which has already been wrapped as %s, as %s.", toWrap, ((WrappingFormula)toWrap).getType(), targetType));
        }
        if (targetType.isIntegerType() && this.encodeIntegerAs != FormulaManagerView.Theory.INTEGER) {
            return (T1)new WrappingFormula.WrappingIntegerFormula<T2>((FormulaType<NumeralFormula.IntegerFormula>)((FormulaType.NumeralType)targetType), toWrap);
        }
        if (targetType.isBitvectorType() && this.encodeBitvectorAs != FormulaManagerView.Theory.BITVECTOR) {
            return (T1)new WrappingFormula.WrappingBitvectorFormula<T2>((FormulaType<BitvectorFormula>)((FormulaType.BitvectorType)targetType), toWrap);
        }
        if (targetType.isFloatingPointType() && this.encodeFloatAs != FormulaManagerView.Theory.FLOAT) {
            return (T1)new WrappingFormula.WrappingFloatingPointFormula<T2>((FormulaType<FloatingPointFormula>)((FormulaType.FloatingPointType)targetType), toWrap);
        }
        if (targetType.isArrayType()) {
            FormulaType.ArrayFormulaType targetArrayType = (FormulaType.ArrayFormulaType)targetType;
            return (T1)new WrappingFormula.WrappingArrayFormula(targetArrayType, toWrap);
        }
        if (targetType.equals((Object)this.manager.getFormulaType(toWrap))) {
            return (T1)toWrap;
        }
        throw new IllegalArgumentException(String.format("Cannot wrap formula %s as %s", toWrap, targetType));
    }

    <T extends Formula> Formula unwrap(T f) {
        if (f instanceof WrappingFormula) {
            return ((WrappingFormula)f).getWrapped();
        }
        return f;
    }

    List<Formula> unwrap(List<? extends Formula> f) {
        return Lists.transform(f, pInput -> this.unwrap(pInput));
    }

    FormulaType<?> unwrapType(FormulaType<?> type) {
        if (type.isArrayType()) {
            FormulaType.ArrayFormulaType arrayType = (FormulaType.ArrayFormulaType)type;
            return FormulaType.getArrayType(this.unwrapType(arrayType.getIndexType()), this.unwrapType(arrayType.getElementType()));
        }
        if (type.isIntegerType()) {
            switch (this.encodeIntegerAs) {
                case BITVECTOR: {
                    return FormulaType.getBitvectorTypeWithSize((int)this.intOptions.getBitsize());
                }
                case INTEGER: {
                    return FormulaType.IntegerType;
                }
                case RATIONAL: {
                    return FormulaType.RationalType;
                }
            }
            throw new AssertionError((Object)("unexpected encoding for integers: " + type));
        }
        if (type.isBitvectorType()) {
            switch (this.encodeBitvectorAs) {
                case BITVECTOR: {
                    return type;
                }
                case INTEGER: {
                    return FormulaType.IntegerType;
                }
                case RATIONAL: {
                    return FormulaType.RationalType;
                }
            }
            throw new AssertionError((Object)("unexpected encoding for bitvectors: " + type));
        }
        if (type.isFloatingPointType()) {
            switch (this.encodeFloatAs) {
                case FLOAT: {
                    return type;
                }
                case INTEGER: {
                    return FormulaType.IntegerType;
                }
                case RATIONAL: {
                    return FormulaType.RationalType;
                }
            }
            throw new AssertionError((Object)("unexpected encoding for floats: " + type));
        }
        return type;
    }

    List<FormulaType<?>> unwrapType(List<? extends FormulaType<?>> pTypes) {
        return Lists.transform(pTypes, pInput -> this.unwrapType((FormulaType<?>)pInput));
    }
}

