/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import java.util.Arrays;
import java.util.List;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.util.predicates.smt.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.UFManager;

public class FunctionFormulaManagerView
extends BaseManagerView
implements UFManager {
    private final UFManager manager;

    FunctionFormulaManagerView(FormulaWrappingHandler pWrappingHandler, UFManager pManager) {
        super(pWrappingHandler);
        this.manager = (UFManager)Preconditions.checkNotNull((Object)pManager);
    }

    public <T extends Formula> FunctionDeclaration<T> declareUF(String pName, FormulaType<T> pReturnType, List<FormulaType<?>> pArgs) {
        List<FormulaType<?>> newArgs = this.unwrapType(pArgs);
        FormulaType<?> ret = this.unwrapType(pReturnType);
        FunctionDeclaration func = this.manager.declareUF(pName, ret, newArgs);
        return new ReplaceUninterpretedFunctionDeclaration<T>(func, pReturnType, pArgs);
    }

    public <T extends Formula> FunctionDeclaration<T> declareUF(String pName, FormulaType<T> pReturnType, FormulaType<?> ... pArgs) {
        return this.declareUF(pName, pReturnType, Arrays.asList(pArgs));
    }

    public <T extends Formula> T declareAndCallUninterpretedFunction(String pName, int idx, FormulaType<T> pReturnType, List<Formula> pArgs) {
        String name = FormulaManagerView.makeName(pName, idx);
        return this.declareAndCallUF(name, pReturnType, pArgs);
    }

    public <T extends Formula> T declareAndCallUninterpretedFunction(String pName, int pIdx, FormulaType<T> pReturnType, Formula ... pArgs) {
        return this.declareAndCallUninterpretedFunction(pName, pIdx, pReturnType, Arrays.asList(pArgs));
    }

    public <T extends Formula> T declareAndCallUF(String name, FormulaType<T> pReturnType, List<Formula> pArgs) {
        ImmutableList argTypes = Collections3.transformedImmutableListCopy(pArgs, this::getFormulaType);
        FunctionDeclaration<T> func = this.declareUF(name, pReturnType, (List<FormulaType<?>>)argTypes);
        return this.callUF(func, pArgs);
    }

    public <T extends Formula> T declareAndCallUF(String pName, FormulaType<T> pReturnType, Formula ... pArgs) {
        return this.declareAndCallUF(pName, pReturnType, Arrays.asList(pArgs));
    }

    public <T extends Formula> T callUF(FunctionDeclaration<T> pFuncType, List<? extends Formula> pArgs) {
        ReplaceUninterpretedFunctionDeclaration rep = (ReplaceUninterpretedFunctionDeclaration)pFuncType;
        Formula f = this.manager.callUF(rep.wrapped, this.unwrap(pArgs));
        return (T)this.wrap(pFuncType.getType(), f);
    }

    public <T extends Formula> T callUF(FunctionDeclaration<T> pFuncType, Formula ... pArgs) {
        return this.callUF(pFuncType, Arrays.asList(pArgs));
    }

    @Immutable
    private static class ReplaceUninterpretedFunctionDeclaration<T extends Formula>
    implements FunctionDeclaration<T> {
        private final FunctionDeclaration<?> wrapped;
        private final FormulaType<T> returnType;
        private final ImmutableList<FormulaType<?>> argumentTypes;

        ReplaceUninterpretedFunctionDeclaration(FunctionDeclaration<?> wrapped, FormulaType<T> pReturnType, List<FormulaType<?>> pArgumentTypes) {
            this.wrapped = (FunctionDeclaration)Preconditions.checkNotNull(wrapped);
            this.returnType = pReturnType;
            this.argumentTypes = ImmutableList.copyOf(pArgumentTypes);
        }

        public int hashCode() {
            return 17 + this.wrapped.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ReplaceUninterpretedFunctionDeclaration)) {
                return false;
            }
            ReplaceUninterpretedFunctionDeclaration other = (ReplaceUninterpretedFunctionDeclaration)obj;
            return this.wrapped.equals(other.wrapped);
        }

        public FunctionDeclarationKind getKind() {
            return FunctionDeclarationKind.UF;
        }

        public String getName() {
            return this.wrapped.getName();
        }

        public FormulaType<T> getType() {
            return this.returnType;
        }

        public ImmutableList<FormulaType<?>> getArgumentTypes() {
            return this.argumentTypes;
        }

        public String toString() {
            return String.format("ReplacementUF(%s :: %s --> %s)", this.wrapped, this.argumentTypes, this.returnType);
        }
    }
}

