/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.StringFormula;

class ModelView
implements Model {
    private static final Pattern Z3_IRRELEVANT_MODEL_TERM_PATTERN = Pattern.compile(".*![0-9]+");
    private final Model delegate;
    private final FormulaWrappingHandler wrappingHandler;

    static boolean isRelevantModelTerm(Model.ValueAssignment valueAssignment) {
        return !Z3_IRRELEVANT_MODEL_TERM_PATTERN.matcher(valueAssignment.getName()).matches();
    }

    ModelView(Model pDelegate, FormulaWrappingHandler pWrappingHandler) {
        this.delegate = pDelegate;
        this.wrappingHandler = pWrappingHandler;
    }

    private @Nullable Object evaluateImpl(Formula f) {
        return this.delegate.evaluate(this.wrappingHandler.unwrap(f));
    }

    public @Nullable Object evaluate(Formula f) {
        return this.evaluateImpl(f);
    }

    public @Nullable BigInteger evaluate(NumeralFormula.IntegerFormula f) {
        return (BigInteger)this.evaluateImpl((Formula)f);
    }

    public @Nullable Rational evaluate(NumeralFormula.RationalFormula f) {
        return (Rational)this.evaluateImpl((Formula)f);
    }

    public @Nullable Boolean evaluate(BooleanFormula f) {
        return (Boolean)this.evaluateImpl((Formula)f);
    }

    public @Nullable BigInteger evaluate(BitvectorFormula f) {
        return (BigInteger)this.evaluateImpl((Formula)f);
    }

    public @Nullable String evaluate(StringFormula f) {
        return (String)this.evaluateImpl((Formula)f);
    }

    public <T extends Formula> @Nullable T eval(T f) {
        return this.wrappingHandler.wrap(this.wrappingHandler.getFormulaType(f), this.delegate.eval(this.wrappingHandler.unwrap(f)));
    }

    public Iterator<Model.ValueAssignment> iterator() {
        return Iterators.filter((Iterator)this.delegate.iterator(), ModelView::isRelevantModelTerm);
    }

    public ImmutableList<Model.ValueAssignment> asList() {
        return FluentIterable.from((Iterable)this.delegate.asList()).filter(ModelView::isRelevantModelTerm).toList();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void close() {
        this.delegate.close();
    }
}

