/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.smt.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

public class QuantifiedFormulaManagerView
extends BaseManagerView
implements QuantifiedFormulaManager {
    private final QuantifiedFormulaManager manager;
    private final BooleanFormulaManagerView bfm;
    private final IntegerFormulaManager ifm;

    QuantifiedFormulaManagerView(FormulaWrappingHandler pWrappingHandler, QuantifiedFormulaManager pManager, BooleanFormulaManagerView pBmgr, IntegerFormulaManager pImgr) {
        super(pWrappingHandler);
        this.manager = pManager;
        this.bfm = pBmgr;
        this.ifm = pImgr;
    }

    public BooleanFormula exists(List<? extends Formula> pVariables, BooleanFormula pBody) {
        return this.manager.exists(this.unwrap(pVariables), pBody);
    }

    public BooleanFormula exists(Formula pVariable, BooleanFormula pBody) {
        return this.manager.exists(this.unwrap(pVariable), pBody);
    }

    public BooleanFormula forall(List<? extends Formula> pVariables, BooleanFormula pBody) {
        return this.manager.forall(this.unwrap(pVariables), pBody);
    }

    public BooleanFormula mkQuantifier(QuantifiedFormulaManager.Quantifier q, List<? extends Formula> pVariables, BooleanFormula pBody) {
        return this.manager.mkQuantifier(q, this.unwrap(pVariables), pBody);
    }

    public BooleanFormula forall(Formula pVariable, BooleanFormula pBody) {
        return this.manager.forall(this.unwrap(pVariable), pBody);
    }

    public BooleanFormula eliminateQuantifiers(BooleanFormula pF) throws InterruptedException, SolverException {
        return this.manager.eliminateQuantifiers(pF);
    }

    public <R extends NumeralFormula.IntegerFormula> BooleanFormula forall(R pVariable, R pLowerBound, R pUpperBound, BooleanFormula pBody) {
        Preconditions.checkNotNull(pVariable);
        Preconditions.checkNotNull(pLowerBound);
        Preconditions.checkNotNull(pUpperBound);
        Preconditions.checkNotNull((Object)pBody);
        List<BooleanFormula> rangeConstraint = this.makeRangeConstraint(pVariable, pLowerBound, pUpperBound);
        return this.manager.forall(Collections.singletonList(pVariable), this.bfm.implication(this.bfm.and(rangeConstraint), pBody));
    }

    public <R extends NumeralFormula.IntegerFormula> BooleanFormula exists(R pVariable, R pLowerBound, R pUpperBound, BooleanFormula pBody) {
        Preconditions.checkNotNull(pVariable);
        Preconditions.checkNotNull(pLowerBound);
        Preconditions.checkNotNull(pUpperBound);
        Preconditions.checkNotNull((Object)pBody);
        List<BooleanFormula> rangeConstraint = this.makeRangeConstraint(pVariable, pLowerBound, pUpperBound);
        ArrayList<BooleanFormula> bodyPredicates = new ArrayList<BooleanFormula>(rangeConstraint.size() + 1);
        bodyPredicates.addAll(rangeConstraint);
        bodyPredicates.add(pBody);
        return this.manager.exists(Collections.singletonList(pVariable), this.bfm.and(bodyPredicates));
    }

    private <R extends NumeralFormula.IntegerFormula> List<BooleanFormula> makeRangeConstraint(R pVariable, R pLowerBound, R pUpperBound) {
        return ImmutableList.of((Object)this.ifm.greaterOrEquals(pVariable, pLowerBound), (Object)this.ifm.lessOrEquals(pVariable, pUpperBound));
    }
}

