/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.smt.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.NumeralFormulaManager;
import org.sosy_lab.java_smt.api.UFManager;

@Options(prefix="cpa.predicate")
class ReplaceBitvectorWithNumeralAndFunctionTheory<T extends NumeralFormula>
extends BaseManagerView
implements BitvectorFormulaManager {
    private final BooleanFormulaManager booleanFormulaManager;
    private final NumeralFormulaManager<? super T, T> numericFormulaManager;
    private final UFManager functionManager;
    private final FunctionDeclaration<T> bitwiseAndUfDecl;
    private final FunctionDeclaration<T> bitwiseOrUfDecl;
    private final FunctionDeclaration<T> bitwiseXorUfDecl;
    private final FunctionDeclaration<T> bitwiseNotUfDecl;
    private final FunctionDeclaration<T> leftShiftUfDecl;
    private final FunctionDeclaration<T> rightShiftUfDecl;
    private final FunctionDeclaration<T> moduloUfDecl;
    private final FormulaType<T> formulaType;
    @Option(secure=true, description="Allows to ignore Concat and Extract Calls when Bitvector theory was replaced with Integer or Rational.")
    private boolean ignoreExtractConcat = true;
    private final Map<Pair<Integer, Integer>, FunctionDeclaration<T>> extractMethods = new HashMap<Pair<Integer, Integer>, FunctionDeclaration<T>>();
    private Map<Pair<Integer, Integer>, FunctionDeclaration<T>> concatMethods = new HashMap<Pair<Integer, Integer>, FunctionDeclaration<T>>();
    private final Map<Triple<String, Boolean, Integer>, FunctionDeclaration<T>> UFDeclarations = new HashMap<Triple<String, Boolean, Integer>, FunctionDeclaration<T>>();

    ReplaceBitvectorWithNumeralAndFunctionTheory(FormulaWrappingHandler pWrappingHandler, BooleanFormulaManager pBooleanFormulaManager, NumeralFormulaManager<? super T, T> rawNumericFormulaManager, UFManager rawFunctionManager, Configuration pConfig) throws InvalidConfigurationException {
        super(pWrappingHandler);
        pConfig.inject((Object)this);
        this.booleanFormulaManager = pBooleanFormulaManager;
        this.numericFormulaManager = rawNumericFormulaManager;
        this.functionManager = rawFunctionManager;
        this.formulaType = this.numericFormulaManager.getFormulaType();
        this.bitwiseAndUfDecl = this.createBinaryFunction("_&_");
        this.bitwiseOrUfDecl = this.createBinaryFunction("_!!_");
        this.bitwiseXorUfDecl = this.createBinaryFunction("_^_");
        this.bitwiseNotUfDecl = this.createUnaryFunction("_~_");
        this.leftShiftUfDecl = this.createBinaryFunction("_<<_");
        this.rightShiftUfDecl = this.createBinaryFunction("_>>_");
        this.moduloUfDecl = this.createBinaryFunction("_%_");
    }

    private T unwrap(BitvectorFormula pNumber) {
        return (T)((NumeralFormula)super.unwrap((Formula)pNumber));
    }

    private FunctionDeclaration<T> createUnaryFunction(String name) {
        return this.functionManager.declareUF(name, this.formulaType, new FormulaType[]{this.formulaType});
    }

    private FunctionDeclaration<T> createBinaryFunction(String name) {
        return this.functionManager.declareUF(name, this.formulaType, new FormulaType[]{this.formulaType, this.formulaType});
    }

    private BitvectorFormula makeUf(FormulaType<BitvectorFormula> realreturn, FunctionDeclaration<T> decl, BitvectorFormula ... t1) {
        List<Formula> args = this.unwrap(Arrays.asList(t1));
        return this.wrap(realreturn, (NumeralFormula)this.functionManager.callUF(decl, args));
    }

    private FunctionDeclaration<T> getExtractDecl(int pMsb, int pLsb) {
        Pair<Integer, Integer> hasKey = Pair.of(pMsb, pLsb);
        FunctionDeclaration<T> value = this.extractMethods.get(hasKey);
        if (value == null) {
            value = this.createUnaryFunction("_extract(" + pMsb + "," + pLsb + ")_");
            this.extractMethods.put(hasKey, value);
        }
        return value;
    }

    private FunctionDeclaration<T> getConcatDecl(int firstSize, int secoundSize) {
        Pair<Integer, Integer> hasKey = Pair.of(firstSize, secoundSize);
        FunctionDeclaration<T> value = this.concatMethods.get(hasKey);
        if (value == null) {
            value = this.createUnaryFunction("_concat(" + firstSize + "," + secoundSize + ")_");
            this.concatMethods.put(hasKey, value);
        }
        return value;
    }

    private FunctionDeclaration<T> getUFDecl(String name, int id, boolean signed) {
        Triple<String, Boolean, Integer> key = Triple.of(name, signed, id);
        FunctionDeclaration<T> value = this.UFDeclarations.get(key);
        if (value == null) {
            String UFname = String.format("_%s%s(%d)_", name, signed ? "Signed" : "Unsigned", id);
            value = this.createUnaryFunction(UFname);
            this.UFDeclarations.put(key, value);
        }
        return value;
    }

    public BitvectorFormula makeBitvector(int pLength, long pI) {
        assert (BigInteger.valueOf(pI).bitLength() <= pLength) : String.format("numeral value %s is too big for bitvector of length %d.", pI, pLength);
        NumeralFormula number = this.numericFormulaManager.makeNumber(pI);
        return (BitvectorFormula)this.wrap(FormulaType.getBitvectorTypeWithSize((int)pLength), number);
    }

    public BitvectorFormula makeBitvector(int pLength, BigInteger pI) {
        assert (pI.bitLength() <= pLength) : String.format("numeral value %s is too big for bitvector of length %d.", pI, pLength);
        NumeralFormula number = this.numericFormulaManager.makeNumber(pI);
        return (BitvectorFormula)this.wrap(FormulaType.getBitvectorTypeWithSize((int)pLength), number);
    }

    public BitvectorFormula makeVariable(int pLength, String pVar) {
        return (BitvectorFormula)this.wrap(FormulaType.getBitvectorTypeWithSize((int)pLength), this.numericFormulaManager.makeVariable(pVar));
    }

    public BitvectorFormula makeVariable(FormulaType.BitvectorType type, String pVar) {
        return (BitvectorFormula)this.wrap(type, this.numericFormulaManager.makeVariable(pVar));
    }

    public int getLength(BitvectorFormula pNumber) {
        return ((FormulaType.BitvectorType)this.getFormulaType(pNumber)).getSize();
    }

    public BitvectorFormula negate(BitvectorFormula pNumber) {
        return this.wrap(this.getFormulaType(pNumber), this.numericFormulaManager.negate(this.unwrap(pNumber)));
    }

    public BitvectorFormula add(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.add(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public BitvectorFormula subtract(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.subtract(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public BitvectorFormula divide(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.wrap(this.getFormulaType(pNumber1), this.getC99ReplacementForSMTlib2Division(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public BitvectorFormula modulo(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        if (this.numericFormulaManager instanceof IntegerFormulaManager) {
            return this.wrap(this.getFormulaType(pNumber1), this.getC99ReplacementForSMTlib2Modulo(this.unwrap(pNumber1), this.unwrap(pNumber2)));
        }
        return this.makeUf(this.getFormulaType(pNumber1), this.moduloUfDecl, pNumber1, pNumber2);
    }

    private Formula getC99ReplacementForSMTlib2Division(T f1, T f2) {
        NumeralFormula zero = this.numericFormulaManager.makeNumber(0L);
        NumeralFormula additionalUnit = (NumeralFormula)this.booleanFormulaManager.ifThenElse(this.numericFormulaManager.greaterOrEquals(f2, zero), (Formula)this.numericFormulaManager.makeNumber(1L), (Formula)this.numericFormulaManager.makeNumber(-1L));
        NumeralFormula div = this.numericFormulaManager.divide(f1, f2);
        return this.booleanFormulaManager.ifThenElse(this.booleanFormulaManager.or(this.numericFormulaManager.greaterOrEquals(f1, zero), this.numericFormulaManager.equal(this.numericFormulaManager.multiply(div, f2), f1)), (Formula)div, (Formula)this.numericFormulaManager.add(div, additionalUnit));
    }

    private Formula getC99ReplacementForSMTlib2Modulo(T f1, T f2) {
        NumeralFormula zero = this.numericFormulaManager.makeNumber(0L);
        NumeralFormula additionalUnit = (NumeralFormula)this.booleanFormulaManager.ifThenElse(this.numericFormulaManager.greaterOrEquals(f2, zero), (Formula)this.numericFormulaManager.negate(f2), f2);
        NumeralFormula.IntegerFormula mod = ((IntegerFormulaManager)this.numericFormulaManager).modulo((NumeralFormula.IntegerFormula)f1, (NumeralFormula.IntegerFormula)f2);
        return this.booleanFormulaManager.ifThenElse(this.booleanFormulaManager.or(this.numericFormulaManager.greaterOrEquals(f1, zero), this.numericFormulaManager.equal((NumeralFormula)mod, zero)), (Formula)mod, (Formula)this.numericFormulaManager.add((NumeralFormula)mod, additionalUnit));
    }

    public BitvectorFormula multiply(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.multiply(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public BooleanFormula equal(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.numericFormulaManager.equal(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula greaterThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.numericFormulaManager.greaterThan(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula greaterOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.numericFormulaManager.greaterOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula lessThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.numericFormulaManager.lessThan(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula lessOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Expect operators to have the same size";
        return this.numericFormulaManager.lessOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BitvectorFormula shiftRight(BitvectorFormula pNumber, BitvectorFormula pToShift, boolean signed) {
        assert (this.getLength(pNumber) == this.getLength(pToShift)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pNumber), this.rightShiftUfDecl, pNumber, pToShift);
    }

    public BitvectorFormula shiftLeft(BitvectorFormula pNumber, BitvectorFormula pToShift) {
        assert (this.getLength(pNumber) == this.getLength(pToShift)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pNumber), this.leftShiftUfDecl, pNumber, pToShift);
    }

    public BitvectorFormula concat(BitvectorFormula pFirst, BitvectorFormula pSecound) {
        int firstLength = this.getLength(pFirst);
        int secoundLength = this.getLength(pSecound);
        FormulaType.BitvectorType returnType = FormulaType.getBitvectorTypeWithSize((int)(firstLength + secoundLength));
        if (this.ignoreExtractConcat) {
            return (BitvectorFormula)this.wrap(returnType, this.unwrap(pSecound));
        }
        FunctionDeclaration<T> concatUfDecl = this.getConcatDecl(firstLength, secoundLength);
        return this.makeUf((FormulaType<BitvectorFormula>)returnType, concatUfDecl, pFirst, pSecound);
    }

    public BitvectorFormula extract(BitvectorFormula pFirst, int pMsb, int pLsb) {
        FormulaType.BitvectorType returnType = FormulaType.getBitvectorTypeWithSize((int)(pMsb + 1 - pLsb));
        if (this.ignoreExtractConcat) {
            return (BitvectorFormula)this.wrap(returnType, this.unwrap(pFirst));
        }
        FunctionDeclaration<T> extractUfDecl = this.getExtractDecl(pMsb, pLsb);
        return this.makeUf((FormulaType<BitvectorFormula>)returnType, extractUfDecl, pFirst);
    }

    public BitvectorFormula extend(BitvectorFormula pNumber, int pExtensionBits, boolean pSigned) {
        FormulaType.BitvectorType returnType = FormulaType.getBitvectorTypeWithSize((int)(this.getLength(pNumber) + pExtensionBits));
        if (this.ignoreExtractConcat) {
            return (BitvectorFormula)this.wrap(returnType, this.unwrap(pNumber));
        }
        FunctionDeclaration<T> extendUfDecl = this.getUFDecl("extend", pExtensionBits, pSigned);
        return this.makeUf((FormulaType<BitvectorFormula>)returnType, extendUfDecl, pNumber);
    }

    public BitvectorFormula not(BitvectorFormula pBits) {
        return this.makeUf(this.getFormulaType(pBits), this.bitwiseNotUfDecl, pBits);
    }

    public BitvectorFormula and(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        assert (this.getLength(pBits1) == this.getLength(pBits2)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pBits1), this.bitwiseAndUfDecl, pBits1, pBits2);
    }

    public BitvectorFormula or(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        assert (this.getLength(pBits1) == this.getLength(pBits2)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pBits1), this.bitwiseOrUfDecl, pBits1, pBits2);
    }

    public BitvectorFormula xor(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        assert (this.getLength(pBits1) == this.getLength(pBits2)) : "Expect operators to have the same size";
        return this.makeUf(this.getFormulaType(pBits1), this.bitwiseXorUfDecl, pBits1, pBits2);
    }

    public BitvectorFormula makeBitvector(int pLength, NumeralFormula.IntegerFormula pI) {
        return (BitvectorFormula)this.wrap(FormulaType.getBitvectorTypeWithSize((int)pLength), this.unwrap((Formula)pI));
    }

    public NumeralFormula.IntegerFormula toIntegerFormula(BitvectorFormula pI, boolean pSigned) {
        T unwrapped = this.unwrap(pI);
        if (this.numericFormulaManager.getFormulaType().equals(FormulaType.IntegerType)) {
            return (NumeralFormula.IntegerFormula)unwrapped;
        }
        return this.numericFormulaManager.floor(unwrapped);
    }

    public BooleanFormula distinct(List<BitvectorFormula> pBits) {
        if (pBits.isEmpty()) {
            return this.booleanFormulaManager.makeTrue();
        }
        int bitsize = this.getLength(pBits.get(0));
        pBits.forEach(bit -> Preconditions.checkArgument((bitsize == this.getLength((BitvectorFormula)bit) ? 1 : 0) != 0, (Object)"Expect operators to have the same size"));
        return this.numericFormulaManager.distinct(Lists.transform(pBits, this::unwrap));
    }
}

