/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.util.predicates.smt.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.cpachecker.util.predicates.smt.WrappingFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.NumeralFormulaManager;
import org.sosy_lab.java_smt.api.UFManager;

class ReplaceFloatingPointWithNumeralAndFunctionTheory<T extends NumeralFormula>
extends BaseManagerView
implements FloatingPointFormulaManager {
    private final BooleanFormulaManager booleanManager;
    private final UFManager functionManager;
    private final NumeralFormulaManager<? super T, T> numericFormulaManager;
    private final FunctionDeclaration<BooleanFormula> isSubnormalUfDecl;
    private final FunctionDeclaration<BooleanFormula> isNormalUfDecl;
    private final FunctionDeclaration<T> sqrtUfDecl;
    private final T zero;
    private final T nanVariable;
    private final T plusInfinityVariable;
    private final T minusInfinityVariable;

    ReplaceFloatingPointWithNumeralAndFunctionTheory(FormulaWrappingHandler pWrappingHandler, NumeralFormulaManager<? super T, T> pReplacementManager, UFManager rawFunctionManager, BooleanFormulaManager pBooleaManager) {
        super(pWrappingHandler);
        this.numericFormulaManager = pReplacementManager;
        this.booleanManager = pBooleaManager;
        this.functionManager = rawFunctionManager;
        FormulaType formulaType = this.numericFormulaManager.getFormulaType();
        this.isSubnormalUfDecl = this.functionManager.declareUF("__isSubnormal__", FormulaType.BooleanType, new FormulaType[]{formulaType});
        this.isNormalUfDecl = this.functionManager.declareUF("__isNormal__", FormulaType.BooleanType, new FormulaType[]{formulaType});
        this.sqrtUfDecl = this.functionManager.declareUF("sqrt", formulaType, new FormulaType[]{formulaType});
        this.zero = this.numericFormulaManager.makeNumber(0L);
        this.nanVariable = this.numericFormulaManager.makeVariable("__NaN__");
        this.plusInfinityVariable = this.numericFormulaManager.makeVariable("__+Infinity__");
        this.minusInfinityVariable = this.numericFormulaManager.makeVariable("__-Infinity__");
    }

    private T unwrap(FloatingPointFormula pNumber) {
        return (T)((NumeralFormula)super.unwrap((Formula)pNumber));
    }

    public <T2 extends Formula> T2 castTo(FloatingPointFormula pNumber, boolean pSigned, FormulaType<T2> pTargetType) {
        return this.genericCast((Formula)this.unwrap(pNumber), pSigned, pTargetType);
    }

    public <T2 extends Formula> T2 castTo(FloatingPointFormula number, boolean pSigned, FormulaType<T2> targetType, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.genericCast((Formula)this.unwrap(number), pSigned, targetType);
    }

    public FloatingPointFormula castFrom(Formula pNumber, boolean pSigned, FormulaType.FloatingPointType pTargetType) {
        return (FloatingPointFormula)this.wrap(pTargetType, this.genericCast(pNumber, pSigned, this.unwrapType((FormulaType<?>)pTargetType)));
    }

    public FloatingPointFormula castFrom(Formula number, boolean pSigned, FormulaType.FloatingPointType targetType, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return (FloatingPointFormula)this.wrap(targetType, this.genericCast(number, pSigned, this.unwrapType((FormulaType<?>)targetType)));
    }

    private <T2 extends Formula> T2 genericCast(Formula pNumber, boolean pSigned, FormulaType<T2> pTargetType) {
        Preconditions.checkArgument((!(pNumber instanceof WrappingFormula) ? 1 : 0) != 0);
        FormulaType<Formula> type = this.getFormulaType(pNumber);
        if (type.equals(pTargetType)) {
            Formula result = pNumber;
            return (T2)result;
        }
        if (type.isIntegerType() && pTargetType.isRationalType()) {
            Formula result = pNumber;
            return (T2)result;
        }
        String ufName = String.format("__cast_%s_to_%s%s__", type, pTargetType.isBitvectorType() && !pSigned ? "unsigned_" : "", pTargetType);
        FunctionDeclaration castFunction = this.functionManager.declareUF(ufName, pTargetType, new FormulaType[]{type});
        return (T2)this.functionManager.callUF(castFunction, (List)ImmutableList.of((Object)pNumber));
    }

    public FloatingPointFormula fromIeeeBitvector(BitvectorFormula pNumber, FormulaType.FloatingPointType pTargetType) {
        return (FloatingPointFormula)ReplaceFloatingPointWithNumeralAndFunctionTheory.createConversionUF((Formula)pNumber, pTargetType, this, this.functionManager);
    }

    public BitvectorFormula toIeeeBitvector(FloatingPointFormula pNumber) {
        FormulaType.FloatingPointType type = (FormulaType.FloatingPointType)this.getFormulaType(pNumber);
        FormulaType.BitvectorType targetType = FormulaType.getBitvectorTypeWithSize((int)type.getTotalSize());
        return (BitvectorFormula)ReplaceFloatingPointWithNumeralAndFunctionTheory.createConversionUF((Formula)pNumber, targetType, this, this.functionManager);
    }

    static <T extends Formula> T createConversionUF(Formula pNumber, FormulaType<T> pToType, BaseManagerView mgr, UFManager functionManager) {
        FormulaType<Formula> fromType = mgr.getFormulaType(pNumber);
        FunctionDeclaration conversionFunction = functionManager.declareUF("__interpret_" + fromType + "_as_" + pToType + "__", mgr.unwrapType(pToType), new FormulaType[]{mgr.unwrapType(fromType)});
        return mgr.wrap(pToType, functionManager.callUF(conversionFunction, new Formula[]{mgr.unwrap(pNumber)}));
    }

    public FloatingPointFormula negate(FloatingPointFormula pNumber) {
        return this.wrap(this.getFormulaType(pNumber), this.numericFormulaManager.negate(this.unwrap(pNumber)));
    }

    public FloatingPointFormula add(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.add(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public FloatingPointFormula add(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.wrap(this.getFormulaType(number1), this.numericFormulaManager.add(this.unwrap(number1), this.unwrap(number2)));
    }

    public FloatingPointFormula subtract(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.subtract(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public FloatingPointFormula subtract(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.wrap(this.getFormulaType(number1), this.numericFormulaManager.subtract(this.unwrap(number1), this.unwrap(number2)));
    }

    public FloatingPointFormula divide(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        T number1 = this.unwrap(pNumber1);
        T number2 = this.unwrap(pNumber2);
        FormulaType<FloatingPointFormula> targetType = this.getFormulaType(pNumber1);
        if (number2.equals(this.zero)) {
            return this.wrap(targetType, (NumeralFormula)this.booleanManager.ifThenElse(this.numericFormulaManager.equal(number1, this.zero), this.nanVariable, (Formula)((NumeralFormula)this.booleanManager.ifThenElse(this.numericFormulaManager.lessThan(number1, this.zero), this.minusInfinityVariable, this.plusInfinityVariable))));
        }
        return this.wrap(targetType, this.numericFormulaManager.divide(number1, number2));
    }

    public FloatingPointFormula divide(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.divide(number1, number2);
    }

    public FloatingPointFormula multiply(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.wrap(this.getFormulaType(pNumber1), this.numericFormulaManager.multiply(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public FloatingPointFormula multiply(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.wrap(this.getFormulaType(number1), this.numericFormulaManager.multiply(this.unwrap(number1), this.unwrap(number2)));
    }

    public BooleanFormula assignment(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.equal(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula equalWithFPSemantics(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.equal(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula greaterThan(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.greaterThan(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula greaterOrEquals(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.greaterOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula lessThan(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.lessThan(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula lessOrEquals(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        return this.numericFormulaManager.lessOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2));
    }

    public BooleanFormula isNaN(FloatingPointFormula pNumber) {
        return this.numericFormulaManager.equal(this.unwrap(pNumber), this.nanVariable);
    }

    public BooleanFormula isInfinity(FloatingPointFormula pNumber) {
        T number = this.unwrap(pNumber);
        return this.booleanManager.or(this.numericFormulaManager.equal(number, this.plusInfinityVariable), this.numericFormulaManager.equal(number, this.minusInfinityVariable));
    }

    public BooleanFormula isZero(FloatingPointFormula pNumber) {
        return this.numericFormulaManager.equal(this.unwrap(pNumber), this.numericFormulaManager.makeNumber(0L));
    }

    public BooleanFormula isNegative(FloatingPointFormula pNumber) {
        return this.numericFormulaManager.lessThan(this.unwrap(pNumber), this.numericFormulaManager.makeNumber(0L));
    }

    public BooleanFormula isSubnormal(FloatingPointFormula pNumber) {
        return (BooleanFormula)this.functionManager.callUF(this.isSubnormalUfDecl, (List)ImmutableList.of(this.unwrap(pNumber)));
    }

    public BooleanFormula isNormal(FloatingPointFormula pNumber) {
        return (BooleanFormula)this.functionManager.callUF(this.isNormalUfDecl, (List)ImmutableList.of(this.unwrap(pNumber)));
    }

    public FloatingPointFormula makeNumber(double pN, FormulaType.FloatingPointType type) {
        return (FloatingPointFormula)this.wrap(type, this.numericFormulaManager.makeNumber(pN));
    }

    public FloatingPointFormula makeNumber(double n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return (FloatingPointFormula)this.wrap(type, this.numericFormulaManager.makeNumber(n));
    }

    public FloatingPointFormula makeNumber(BigDecimal pN, FormulaType.FloatingPointType type) {
        return (FloatingPointFormula)this.wrap(type, this.numericFormulaManager.makeNumber(pN));
    }

    public FloatingPointFormula makeNumber(BigDecimal n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return (FloatingPointFormula)this.wrap(type, this.numericFormulaManager.makeNumber(n));
    }

    public FloatingPointFormula makeNumber(String pN, FormulaType.FloatingPointType type) {
        return (FloatingPointFormula)this.wrap(type, this.numericFormulaManager.makeNumber(pN));
    }

    public FloatingPointFormula makeNumber(String n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return (FloatingPointFormula)this.wrap(type, this.numericFormulaManager.makeNumber(n));
    }

    public FloatingPointFormula makeNumber(Rational n, FormulaType.FloatingPointType type) {
        return (FloatingPointFormula)this.wrap(type, this.numericFormulaManager.makeNumber(n));
    }

    public FloatingPointFormula makeNumber(Rational n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return (FloatingPointFormula)this.wrap(type, this.numericFormulaManager.makeNumber(n));
    }

    public FloatingPointFormula makeVariable(String pVar, FormulaType.FloatingPointType pType) {
        return (FloatingPointFormula)this.wrap(pType, this.numericFormulaManager.makeVariable(pVar));
    }

    public FloatingPointFormula makePlusInfinity(FormulaType.FloatingPointType pType) {
        return (FloatingPointFormula)this.wrap(pType, this.plusInfinityVariable);
    }

    public FloatingPointFormula makeMinusInfinity(FormulaType.FloatingPointType pType) {
        return (FloatingPointFormula)this.wrap(pType, this.minusInfinityVariable);
    }

    public FloatingPointFormula makeNaN(FormulaType.FloatingPointType pType) {
        return (FloatingPointFormula)this.wrap(pType, this.nanVariable);
    }

    public FloatingPointFormula round(FloatingPointFormula pNumber, FloatingPointRoundingMode pRoundingMode) {
        FormulaType type = this.numericFormulaManager.getFormulaType();
        FunctionDeclaration roundFunction = this.functionManager.declareUF("__round_" + pRoundingMode, type, new FormulaType[]{type});
        return this.wrap(this.getFormulaType(pNumber), (NumeralFormula)this.functionManager.callUF(roundFunction, new Formula[]{this.unwrap(pNumber)}));
    }

    public FloatingPointFormula abs(FloatingPointFormula pNumber) {
        T number = this.unwrap(pNumber);
        return this.wrap(this.getFormulaType(pNumber), (NumeralFormula)this.booleanManager.ifThenElse(this.numericFormulaManager.greaterOrEquals(this.numericFormulaManager.makeNumber(0L), number), number, (Formula)this.numericFormulaManager.negate(number)));
    }

    public FloatingPointFormula max(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        T number1 = this.unwrap(pNumber1);
        T number2 = this.unwrap(pNumber2);
        return this.wrap(this.getFormulaType(pNumber1), (NumeralFormula)this.booleanManager.ifThenElse(this.numericFormulaManager.greaterOrEquals(number1, number2), number1, number2));
    }

    public FloatingPointFormula min(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        T number1 = this.unwrap(pNumber1);
        T number2 = this.unwrap(pNumber2);
        return this.wrap(this.getFormulaType(pNumber1), (NumeralFormula)this.booleanManager.ifThenElse(this.numericFormulaManager.greaterOrEquals(number1, number2), number2, number1));
    }

    public FloatingPointFormula sqrt(FloatingPointFormula pNumber) {
        return this.wrap(this.getFormulaType(pNumber), (NumeralFormula)this.functionManager.callUF(this.sqrtUfDecl, (List)ImmutableList.of(this.unwrap(pNumber))));
    }

    public FloatingPointFormula sqrt(FloatingPointFormula pNumber, FloatingPointRoundingMode pRoundingMode) {
        return this.sqrt(pNumber);
    }
}

