/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.util.predicates.smt.BaseManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaWrappingHandler;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;

class ReplaceIntegerWithBitvectorTheory
extends BaseManagerView
implements IntegerFormulaManager {
    private final BitvectorFormulaManager bvFormulaManager;
    private final BooleanFormulaManager booleanFormulaManager;
    private final int bitsize;

    ReplaceIntegerWithBitvectorTheory(FormulaWrappingHandler pWrappingHandler, BitvectorFormulaManager pReplacementManager, BooleanFormulaManager pBooleanFormulaManager, ReplaceIntegerEncodingOptions pOptions) {
        super(pWrappingHandler);
        this.booleanFormulaManager = (BooleanFormulaManager)Preconditions.checkNotNull((Object)pBooleanFormulaManager);
        this.bvFormulaManager = (BitvectorFormulaManager)Preconditions.checkNotNull((Object)pReplacementManager);
        this.bitsize = pOptions.getBitsize();
    }

    private BitvectorFormula unwrap(NumeralFormula.IntegerFormula pNumber) {
        return (BitvectorFormula)super.unwrap((Formula)pNumber);
    }

    public NumeralFormula.IntegerFormula makeNumber(long pNumber) {
        return this.makeNumber(BigInteger.valueOf(pNumber));
    }

    public NumeralFormula.IntegerFormula makeNumber(BigInteger pNumber) {
        return (NumeralFormula.IntegerFormula)this.wrap(FormulaType.IntegerType, this.bvFormulaManager.makeBitvector(this.bitsize, pNumber));
    }

    public NumeralFormula.IntegerFormula makeNumber(double pNumber) {
        return this.makeNumber(BigDecimal.valueOf(pNumber));
    }

    public NumeralFormula.IntegerFormula makeNumber(BigDecimal pNumber) {
        return (NumeralFormula.IntegerFormula)this.wrap(FormulaType.IntegerType, this.bvFormulaManager.makeBitvector(this.bitsize, pNumber.toBigInteger()));
    }

    public NumeralFormula.IntegerFormula makeNumber(String pI) {
        return this.makeNumber(new BigInteger(pI));
    }

    public NumeralFormula.IntegerFormula makeNumber(Rational pRational) {
        return this.makeNumber(pRational.longValue());
    }

    public NumeralFormula.IntegerFormula makeVariable(String pVar) {
        return (NumeralFormula.IntegerFormula)this.wrap(FormulaType.IntegerType, this.bvFormulaManager.makeVariable(this.bitsize, pVar));
    }

    public NumeralFormula.IntegerFormula negate(NumeralFormula.IntegerFormula pNumber) {
        return (NumeralFormula.IntegerFormula)this.wrap(FormulaType.IntegerType, this.bvFormulaManager.negate(this.unwrap(pNumber)));
    }

    public NumeralFormula.IntegerFormula add(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (NumeralFormula.IntegerFormula)this.wrap(FormulaType.IntegerType, this.bvFormulaManager.add(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public NumeralFormula.IntegerFormula sum(List<NumeralFormula.IntegerFormula> pOperands) {
        NumeralFormula.IntegerFormula result = this.makeNumber(0L);
        for (NumeralFormula.IntegerFormula operand : pOperands) {
            result = this.add(result, operand);
        }
        return result;
    }

    public NumeralFormula.IntegerFormula subtract(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (NumeralFormula.IntegerFormula)this.wrap(FormulaType.IntegerType, this.bvFormulaManager.subtract(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public NumeralFormula.IntegerFormula divide(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (NumeralFormula.IntegerFormula)this.wrap(FormulaType.IntegerType, this.bvFormulaManager.divide(this.unwrap(pNumber1), this.unwrap(pNumber2), true));
    }

    public NumeralFormula.IntegerFormula multiply(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (NumeralFormula.IntegerFormula)this.wrap(FormulaType.IntegerType, this.bvFormulaManager.multiply(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public BooleanFormula equal(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (BooleanFormula)this.wrap(FormulaType.BooleanType, this.bvFormulaManager.equal(this.unwrap(pNumber1), this.unwrap(pNumber2)));
    }

    public BooleanFormula distinct(List<NumeralFormula.IntegerFormula> pNumbers) {
        ArrayList<BooleanFormula> r = new ArrayList<BooleanFormula>();
        for (int i = 0; i < pNumbers.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                r.add(this.booleanFormulaManager.not(this.equal(pNumbers.get(i), pNumbers.get(j))));
            }
        }
        return this.booleanFormulaManager.and(r);
    }

    public BooleanFormula greaterThan(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (BooleanFormula)this.wrap(FormulaType.BooleanType, this.bvFormulaManager.greaterThan(this.unwrap(pNumber1), this.unwrap(pNumber2), true));
    }

    public BooleanFormula greaterOrEquals(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (BooleanFormula)this.wrap(FormulaType.BooleanType, this.bvFormulaManager.greaterOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2), true));
    }

    public BooleanFormula lessThan(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (BooleanFormula)this.wrap(FormulaType.BooleanType, this.bvFormulaManager.lessThan(this.unwrap(pNumber1), this.unwrap(pNumber2), true));
    }

    public BooleanFormula lessOrEquals(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (BooleanFormula)this.wrap(FormulaType.BooleanType, this.bvFormulaManager.lessOrEquals(this.unwrap(pNumber1), this.unwrap(pNumber2), true));
    }

    public NumeralFormula.IntegerFormula floor(NumeralFormula.IntegerFormula pFormula) {
        return pFormula;
    }

    public BooleanFormula modularCongruence(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2, BigInteger pModulo) {
        if (BigInteger.ZERO.compareTo(pModulo) < 0) {
            NumeralFormula.IntegerFormula n = this.makeNumber(pModulo);
            NumeralFormula.IntegerFormula x = this.subtract(pNumber1, pNumber2);
            return this.equal(x, this.multiply(n, this.divide(x, n)));
        }
        return this.booleanFormulaManager.makeTrue();
    }

    public BooleanFormula modularCongruence(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2, long pN) {
        return this.modularCongruence(pNumber1, pNumber2, BigInteger.valueOf(pN));
    }

    public NumeralFormula.IntegerFormula modulo(NumeralFormula.IntegerFormula pNumber1, NumeralFormula.IntegerFormula pNumber2) {
        return (NumeralFormula.IntegerFormula)this.wrap(FormulaType.IntegerType, this.bvFormulaManager.modulo(this.unwrap(pNumber1), this.unwrap(pNumber2), true));
    }

    @Options(prefix="cpa.predicate")
    static class ReplaceIntegerEncodingOptions {
        @Option(secure=true, description="The bitsize is used to encode integers as bitvectors.")
        private int bitsize = 32;

        ReplaceIntegerEncodingOptions(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }

        public int getBitsize() {
            return this.bitsize;
        }
    }
}

