/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.util.predicates.interpolation.SeparateInterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.InterpolatingProverEnvironmentView;
import org.sosy_lab.cpachecker.util.predicates.smt.OptimizationProverEnvironmentView;
import org.sosy_lab.cpachecker.util.predicates.smt.ProverEnvironmentView;
import org.sosy_lab.cpachecker.util.predicates.ufCheckingProver.UFCheckingBasicProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.ufCheckingProver.UFCheckingInterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.ufCheckingProver.UFCheckingProverEnvironment;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsSolverContext;

@Options(deprecatedPrefix="cpa.predicate.solver", prefix="solver")
public final class Solver
implements AutoCloseable {
    private static final String SOLVER_OPTION_NON_LINEAR_ARITHMETIC = "solver.nonLinearArithmetic";
    @Option(secure=true, name="checkUFs", description="improve sat-checks with additional constraints for UFs")
    private boolean checkUFs = false;
    @Option(secure=true, description="Which SMT solver to use.")
    private SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.MATHSAT5;
    @Option(secure=true, description="Which solver to use specifically for interpolation (default is to use the main one).")
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable SolverContextFactory.Solvers interpolationSolver = null;
    @Option(secure=true, description="Extract and cache unsat cores for satisfiability checking")
    private boolean cacheUnsatCores = true;
    @Option(secure=true, description="whether CPAchecker's logger should be used as logger for the solver, otherwise nothing is logged from the solver.")
    private boolean enableLoggingInSolver = false;
    private final  @Nullable UFCheckingBasicProverEnvironment.UFCheckingProverOptions ufCheckingProverOptions;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final SolverContext solvingContext;
    private final SolverContext interpolatingContext;
    private final Map<BooleanFormula, Boolean> unsatCache = new HashMap<BooleanFormula, Boolean>();
    private final Map<Object, Map<Set<BooleanFormula>, Boolean>> groupedUnsatCache = new HashMap<Object, Map<Set<BooleanFormula>, Boolean>>();
    private final LogManager logger;
    public final Timer solverTime = new Timer();
    public int satChecks = 0;
    public int trivialSatChecks = 0;
    public int cachedSatChecks = 0;

    private Solver(Configuration config, LogManager pLogger, ShutdownNotifier shutdownNotifier) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = this.enableLoggingInSolver ? pLogger : LogManager.createNullLogManager();
        SolverContextFactory solverFactory = new SolverContextFactory(config, this.logger, shutdownNotifier);
        if (this.solver.equals((Object)this.interpolationSolver)) {
            this.interpolationSolver = null;
        }
        this.solvingContext = solverFactory.generateContext(this.solver);
        this.interpolatingContext = this.interpolationSolver != null ? solverFactory.generateContext(this.interpolationSolver) : this.solvingContext;
        this.fmgr = new FormulaManagerView(this.solvingContext.getFormulaManager(), config, pLogger);
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.ufCheckingProverOptions = this.checkUFs ? new UFCheckingBasicProverEnvironment.UFCheckingProverOptions(config) : null;
    }

    @VisibleForTesting
    Solver(SolverContextFactory pSolverFactory, SolverContextFactory.Solvers pSolver, SolverContext pContext, Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        if (this.solver.equals((Object)this.interpolationSolver)) {
            this.interpolationSolver = null;
        }
        Preconditions.checkArgument((boolean)this.solver.equals((Object)pSolver), (Object)"mismatching configuration");
        this.solvingContext = pContext;
        this.interpolatingContext = this.interpolationSolver != null ? pSolverFactory.generateContext(this.interpolationSolver) : this.solvingContext;
        this.fmgr = new FormulaManagerView(pContext.getFormulaManager(), pConfig, pLogger);
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.logger = pLogger;
        this.ufCheckingProverOptions = this.checkUFs ? new UFCheckingBasicProverEnvironment.UFCheckingProverOptions(pConfig) : null;
    }

    public static Solver create(Configuration config, LogManager logger, ShutdownNotifier shutdownNotifier) throws InvalidConfigurationException {
        return new Solver(Solver.adjustConfigForSolver(config), logger, shutdownNotifier);
    }

    public static Configuration adjustConfigForSolver(Configuration config) throws InvalidConfigurationException {
        if (!config.hasProperty(SOLVER_OPTION_NON_LINEAR_ARITHMETIC)) {
            return Configuration.builder().copyFrom(config).setOption(SOLVER_OPTION_NON_LINEAR_ARITHMETIC, "APPROXIMATE_ALWAYS").build();
        }
        return config;
    }

    public static Solver create(SolverContextFactory pSolverFactory, SolverContextFactory.Solvers pSolver, SolverContext pSolverContext, Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        return new Solver(pSolverFactory, pSolver, pSolverContext, pConfig, pLogger);
    }

    public FormulaManagerView getFormulaManager() {
        return this.fmgr;
    }

    public void printStatistics(PrintStream pOut) {
        if (this.solvingContext instanceof StatisticsSolverContext) {
            SolverStatistics stats = ((StatisticsSolverContext)this.solvingContext).getSolverStatistics();
            pOut.println();
            StatisticsWriter.writingStatisticsTo(pOut).put("Statistics about operations", "").beginLevel().put("Number of boolean operations", stats.getNumberOfBooleanOperations()).put("Number of numeric operations", stats.getNumberOfNumericOperations()).put("Number of FP operations", stats.getNumberOfFPOperations()).put("Number of BV operations", stats.getNumberOfBVOperations()).put("Number of array operations", stats.getNumberOfArrayOperations()).endLevel().put("Statistics about queries", "").beginLevel().put("Number of push queries", stats.getNumberOfPushQueries()).put("Number of addConstraint queries", stats.getNumberOfAddConstraintQueries()).put("Number of pop queries", stats.getNumberOfPopQueries()).put("Number of model queries", stats.getNumberOfModelQueries()).put("Number of isUnsat queries", stats.getNumberOfIsUnsatQueries()).put("Sum time for isUnsat queries", stats.getSumTimeOfIsUnsatQueries().formatAs(TimeUnit.SECONDS)).put("Max time for isUnsat queries", stats.getMaxTimeOfIsUnsatQueries().formatAs(TimeUnit.SECONDS)).put("Number of interpolation queries", stats.getNumberOfInterpolationQueries()).put("Sum time for itp queries", stats.getSumTimeOfInterpolationQueries().formatAs(TimeUnit.SECONDS)).put("Max time for itp queries", stats.getMaxTimeOfInterpolationQueries().formatAs(TimeUnit.SECONDS)).put("Number of allSat queries", stats.getNumberOfAllSatQueries()).put("Sum time for allSat queries", stats.getSumTimeOfAllSatQueries().formatAs(TimeUnit.SECONDS)).put("Max time for allSat queries", stats.getMaxTimeOfAllSatQueries().formatAs(TimeUnit.SECONDS));
        }
    }

    public ProverEnvironment newProverEnvironment(SolverContext.ProverOptions ... options) {
        return this.newProverEnvironment0(options);
    }

    private ProverEnvironment newProverEnvironment0(SolverContext.ProverOptions ... options) {
        ProverEnvironment pe = this.solvingContext.newProverEnvironment(options);
        if (this.checkUFs) {
            pe = new UFCheckingProverEnvironment(this.logger, pe, this.fmgr, this.ufCheckingProverOptions);
        }
        pe = new ProverEnvironmentView(pe, this.fmgr.getFormulaWrappingHandler());
        return pe;
    }

    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation(SolverContext.ProverOptions ... options) {
        Object ipe = this.interpolatingContext.newProverEnvironmentWithInterpolation(options);
        if (this.solvingContext != this.interpolatingContext) {
            ipe = new SeparateInterpolatingProverEnvironment(this.solvingContext.getFormulaManager(), this.interpolatingContext.getFormulaManager(), ipe);
        }
        if (this.checkUFs) {
            ipe = new UFCheckingInterpolatingProverEnvironment(this.logger, ipe, this.fmgr, this.ufCheckingProverOptions);
        }
        ipe = new InterpolatingProverEnvironmentView(ipe, this.fmgr.getFormulaWrappingHandler());
        return ipe;
    }

    public OptimizationProverEnvironment newOptEnvironment() {
        OptimizationProverEnvironment environment = this.solvingContext.newOptimizationProverEnvironment(new SolverContext.ProverOptions[]{SolverContext.ProverOptions.GENERATE_MODELS});
        environment = new OptimizationProverEnvironmentView(environment, this.fmgr);
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnsat(BooleanFormula f) throws SolverException, InterruptedException {
        ++this.satChecks;
        if (this.bfmgr.isTrue(f)) {
            ++this.trivialSatChecks;
            return false;
        }
        if (this.bfmgr.isFalse(f)) {
            ++this.trivialSatChecks;
            return true;
        }
        Boolean result = this.unsatCache.get(f);
        if (result != null) {
            ++this.cachedSatChecks;
            return result;
        }
        this.solverTime.start();
        try {
            result = this.isUnsatUncached(f);
            this.unsatCache.put(f, result);
            boolean bl = result;
            return bl;
        }
        finally {
            this.solverTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnsat(Set<BooleanFormula> constraints, Object cacheKey) throws InterruptedException, SolverException {
        this.solverTime.start();
        try {
            boolean bl = this.isUnsat0(constraints, cacheKey);
            return bl;
        }
        finally {
            this.solverTime.stop();
        }
    }

    private boolean isUnsat0(Set<BooleanFormula> lemmas, Object cacheKey) throws InterruptedException, SolverException {
        ++this.satChecks;
        Map<Set<BooleanFormula>, Boolean> stored = this.groupedUnsatCache.get(cacheKey);
        if (stored != null) {
            for (Map.Entry<Set<BooleanFormula>, Boolean> isUnsatResults : stored.entrySet()) {
                Set<BooleanFormula> cachedConstraints = isUnsatResults.getKey();
                boolean cachedIsUnsat = isUnsatResults.getValue();
                if (cachedIsUnsat && lemmas.containsAll(cachedConstraints)) {
                    ++this.cachedSatChecks;
                    return true;
                }
                if (cachedIsUnsat || !cachedConstraints.containsAll(lemmas)) continue;
                ++this.cachedSatChecks;
                return false;
            }
        }
        stored = stored == null ? new HashMap<Set<BooleanFormula>, Boolean>() : new HashMap<Set<BooleanFormula>, Boolean>(stored);
        SolverContext.ProverOptions[] opts = this.cacheUnsatCores ? new SolverContext.ProverOptions[]{SolverContext.ProverOptions.GENERATE_UNSAT_CORE} : new SolverContext.ProverOptions[]{};
        try {
            boolean bl;
            block19: {
                ProverEnvironment pe;
                block17: {
                    boolean bl2;
                    block18: {
                        pe = this.newProverEnvironment(opts);
                        try {
                            pe.push();
                            for (BooleanFormula lemma : lemmas) {
                                pe.addConstraint(lemma);
                            }
                            if (!pe.isUnsat()) break block17;
                            if (this.cacheUnsatCores) {
                                stored.put((Set<BooleanFormula>)ImmutableSet.copyOf((Collection)pe.getUnsatCore()), true);
                            } else {
                                stored.put((Set<BooleanFormula>)ImmutableSet.copyOf(lemmas), true);
                            }
                            bl2 = true;
                            if (pe == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (pe != null) {
                                try {
                                    pe.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        pe.close();
                    }
                    return bl2;
                }
                stored.put(lemmas, false);
                bl = false;
                if (pe == null) break block19;
                pe.close();
            }
            return bl;
        }
        finally {
            this.groupedUnsatCache.put(cacheKey, (Map<Set<BooleanFormula>, Boolean>)ImmutableMap.copyOf(stored));
        }
    }

    public List<BooleanFormula> unsatCore(BooleanFormula constraints) throws SolverException, InterruptedException {
        return this.unsatCore(this.bfmgr.toConjunctionArgs(constraints, true));
    }

    public List<BooleanFormula> unsatCore(Set<BooleanFormula> constraints) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);){
            for (BooleanFormula constraint : constraints) {
                prover.addConstraint(constraint);
            }
            Verify.verify((boolean)prover.isUnsat());
            List list = prover.getUnsatCore();
            return list;
        }
    }

    private boolean isUnsatUncached(BooleanFormula f) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            prover.push(f);
            boolean bl = prover.isUnsat();
            return bl;
        }
    }

    public boolean implies(BooleanFormula a, BooleanFormula b) throws SolverException, InterruptedException {
        if (this.bfmgr.isFalse(a) || this.bfmgr.isTrue(b)) {
            ++this.satChecks;
            ++this.trivialSatChecks;
            return true;
        }
        if (a.equals(b)) {
            ++this.satChecks;
            ++this.trivialSatChecks;
            return true;
        }
        BooleanFormula f = this.bfmgr.not(this.bfmgr.implication(a, b));
        return this.isUnsat(f);
    }

    @Override
    public void close() {
        Throwable t = null;
        try {
            this.solvingContext.close();
        }
        catch (Throwable t1) {
            t = t1;
            throw t1;
        }
        finally {
            if (this.solvingContext != this.interpolatingContext) {
                if (t != null) {
                    try {
                        this.interpolatingContext.close();
                    }
                    catch (Throwable t2) {
                        t.addSuppressed(t2);
                    }
                } else {
                    this.interpolatingContext.close();
                }
            }
        }
    }

    public String getVersion() {
        return this.solvingContext.getVersion();
    }

    public String getInterpolatingVersion() {
        return this.interpolatingContext.getVersion();
    }
}

