/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.truth.TruthJUnit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.util.predicates.smt.QuantifiedFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
public class SolverQuantifierTest
extends SolverViewBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverUnderTest;
    private QuantifiedFormulaManagerView qfm;
    private NumeralFormula.IntegerFormula _x;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b;
    private BooleanFormula _b_at_x_eq_1;
    private BooleanFormula _b_at_x_eq_0;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverUnderTest;
    }

    @Before
    public void setUp() {
        this.requireArrays();
        this.requireQuantifiers();
        this.qfm = this.mgrv.getQuantifiedFormulaManager();
        this.imgr = this.imgrv;
        this._x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        this._b = this.amgr.makeArray("b", FormulaType.IntegerType, FormulaType.IntegerType);
        this._b_at_x_eq_1 = this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.amgr.select(this._b, (Formula)this._x)), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        this._b_at_x_eq_0 = this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.amgr.select(this._b, (Formula)this._x)), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
    }

    @Test
    public void testExistsRestrictedRange() throws SolverException, InterruptedException {
        BooleanFormula _exists_10_20_bx_1 = this.qfm.exists(this._x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(20L), this._b_at_x_eq_1);
        BooleanFormula _forall_x_bx_0 = this.qfm.forall((Formula)this._x, this._b_at_x_eq_0);
        BooleanFormula f = this.bmgr.and(_exists_10_20_bx_1, _forall_x_bx_0);
        this.assertThatFormula(f).isUnsatisfiable();
        f = this.bmgr.and(_exists_10_20_bx_1, this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.amgr.select(this._b, (Formula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)))), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L))));
        this.assertThatFormula(f).isSatisfiable();
        f = this.bmgr.and(_exists_10_20_bx_1, this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.amgr.select(this._b, (Formula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1000L)))), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L))));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testExistsRestrictedRangeInconclusive() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("Solver %s does not support the complete theory of quantifiers and returns INCONCLUSIVE", new Object[]{this.solverToUse()}).that((Comparable)this.solverUnderTest).isNoneOf((Object)SolverContextFactory.Solvers.PRINCESS, (Object)SolverContextFactory.Solvers.CVC4, new Object[]{SolverContextFactory.Solvers.CVC5});
        BooleanFormula _exists_10_20_bx_0 = this.qfm.exists(this._x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(20L), this._b_at_x_eq_0);
        BooleanFormula _exists_10_20_bx_1 = this.qfm.exists(this._x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(20L), this._b_at_x_eq_1);
        BooleanFormula _forall_x_bx_1 = this.qfm.forall((Formula)this._x, this._b_at_x_eq_1);
        BooleanFormula _forall_x_bx_0 = this.qfm.forall((Formula)this._x, this._b_at_x_eq_0);
        BooleanFormula f = this.bmgr.and(_exists_10_20_bx_0, _forall_x_bx_0);
        this.assertThatFormula(f).isSatisfiable();
        f = this.bmgr.and(_exists_10_20_bx_1, _forall_x_bx_1);
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testForallRestrictedRange() throws SolverException, InterruptedException {
        BooleanFormula _forall_10_20_bx_1 = this.qfm.forall(this._x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(20L), this._b_at_x_eq_1);
        BooleanFormula f = this.bmgr.and(_forall_10_20_bx_1, this.qfm.exists(this._x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(15L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(17L), this._b_at_x_eq_0));
        this.assertThatFormula(f).isUnsatisfiable();
        f = this.bmgr.and(_forall_10_20_bx_1, this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.amgr.select(this._b, (Formula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)))), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L))));
        this.assertThatFormula(f).isUnsatisfiable();
        f = this.bmgr.and(_forall_10_20_bx_1, this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.amgr.select(this._b, (Formula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(20L)))), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L))));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testForallRestrictedRangeInconclusive() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("Solver %s does not support the complete theory of quantifiers and returns INCONCLUSIVE", new Object[]{this.solverToUse()}).that((Comparable)this.solverUnderTest).isNoneOf((Object)SolverContextFactory.Solvers.PRINCESS, (Object)SolverContextFactory.Solvers.CVC4, new Object[]{SolverContextFactory.Solvers.CVC5});
        BooleanFormula _forall_10_20_bx_0 = this.qfm.forall(this._x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(20L), this._b_at_x_eq_0);
        BooleanFormula _forall_10_20_bx_1 = this.qfm.forall(this._x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(20L), this._b_at_x_eq_1);
        BooleanFormula f = this.bmgr.and(_forall_10_20_bx_0, this.qfm.forall((Formula)this._x, this._b_at_x_eq_0));
        this.assertThatFormula(f).isSatisfiable();
        f = this.bmgr.and(_forall_10_20_bx_1, this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.amgr.select(this._b, (Formula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(9L)))), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L))));
        this.assertThatFormula(f).isSatisfiable();
        f = this.bmgr.and(_forall_10_20_bx_1, this.imgr.equal((NumeralFormula)((NumeralFormula.IntegerFormula)this.amgr.select(this._b, (Formula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(21L)))), (NumeralFormula)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L))));
        this.assertThatFormula(f).isSatisfiable();
        f = this.bmgr.and(_forall_10_20_bx_1, this.qfm.forall(this._x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(20L), this._b_at_x_eq_0));
        this.assertThatFormula(f).isUnsatisfiable();
        f = this.bmgr.and(_forall_10_20_bx_1, this.qfm.forall(this._x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(9L), this._b_at_x_eq_0));
        this.assertThatFormula(f).isSatisfiable();
    }
}

