/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.truth.TruthJUnit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.junit.After;
import org.junit.Before;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.IntegerFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
public class SolverViewBasedTest0
extends SolverBasedTest0 {
    protected Solver solver;
    protected FormulaManagerView mgrv;
    protected BooleanFormulaManagerView bmgrv;
    protected IntegerFormulaManagerView imgrv;

    protected ConfigurationBuilder createTestConfigBuilder() {
        ConfigurationBuilder newConfig = super.createTestConfigBuilder();
        switch (this.solverToUse()) {
            case SMTINTERPOL: {
                newConfig.setOption("cpa.predicate.encodeBitvectorAs", "INTEGER");
                newConfig.setOption("cpa.predicate.encodeFloatAs", "RATIONAL");
                break;
            }
            case PRINCESS: {
                newConfig.setOption("cpa.predicate.encodeBitvectorAs", "INTEGER");
                newConfig.setOption("cpa.predicate.encodeFloatAs", "INTEGER");
                break;
            }
            case BOOLECTOR: {
                TruthJUnit.assume().withMessage("Solver %s does not support the tested features", new Object[]{this.solverToUse()}).that((Comparable)this.solverToUse()).isNotEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
                break;
            }
            case YICES2: {
                TruthJUnit.assume().withMessage("Solver %s is not available on all systems, disabling it for CPAchecker", new Object[]{this.solverToUse()}).that((Comparable)this.solverToUse()).isNotEqualTo((Object)SolverContextFactory.Solvers.YICES2);
                break;
            }
            default: {
                newConfig.setOption("cpa.predicate.encodeBitvectorAs", "BITVECTOR");
                newConfig.setOption("cpa.predicate.encodeFloatAs", "FLOAT");
            }
        }
        return newConfig;
    }

    @Before
    public final void initCPAcheckerSolver() throws InvalidConfigurationException {
        this.solver = new Solver(this.factory, this.solverToUse(), this.context, this.config, this.logger);
        this.mgrv = this.solver.getFormulaManager();
        this.bmgrv = this.mgrv.getBooleanFormulaManager();
        this.imgrv = this.mgrv.getIntegerFormulaManager();
    }

    @After
    public final void closeCPAcheckerSolver() {
    }
}

