/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smt;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;

@Immutable
abstract class WrappingFormula<TWrap extends Formula, TOut extends Formula> {
    private final TWrap wrapped;
    private final FormulaType<TOut> type;

    private WrappingFormula(FormulaType<TOut> pType, TWrap pWrapped) {
        this.wrapped = (Formula)Preconditions.checkNotNull(pWrapped);
        this.type = (FormulaType)Preconditions.checkNotNull(pType);
    }

    final TWrap getWrapped() {
        return this.wrapped;
    }

    final FormulaType<TOut> getType() {
        return this.type;
    }

    public final String toString() {
        return this.wrapped.toString();
    }

    public final int hashCode() {
        int prime = 31;
        return (31 + this.type.hashCode()) * 31 + this.wrapped.hashCode();
    }

    public final boolean equals(Object pObj) {
        if (pObj == null || !this.getClass().equals(pObj.getClass())) {
            return false;
        }
        WrappingFormula other = (WrappingFormula)pObj;
        return this.wrapped.equals(other.wrapped) && this.type.equals(other.type);
    }

    @Immutable
    static final class WrappingArrayFormula<TWrap extends Formula, TI extends Formula, TE extends Formula>
    extends WrappingFormula<TWrap, ArrayFormula<TI, TE>>
    implements ArrayFormula<TI, TE> {
        WrappingArrayFormula(FormulaType<ArrayFormula<TI, TE>> type, TWrap pToWrap) {
            super(type, pToWrap);
        }
    }

    @Immutable
    static final class WrappingFloatingPointFormula<TWrap extends Formula>
    extends WrappingFormula<TWrap, FloatingPointFormula>
    implements FloatingPointFormula {
        WrappingFloatingPointFormula(FormulaType<FloatingPointFormula> type, TWrap pToWrap) {
            super(type, pToWrap);
        }
    }

    @Immutable
    static final class WrappingBitvectorFormula<TWrap extends Formula>
    extends WrappingFormula<TWrap, BitvectorFormula>
    implements BitvectorFormula {
        WrappingBitvectorFormula(FormulaType<BitvectorFormula> type, TWrap pToWrap) {
            super(type, pToWrap);
        }
    }

    @Immutable
    static final class WrappingIntegerFormula<TWrap extends Formula>
    extends WrappingFormula<TWrap, NumeralFormula.IntegerFormula>
    implements NumeralFormula.IntegerFormula {
        WrappingIntegerFormula(FormulaType<NumeralFormula.IntegerFormula> type, TWrap pToWrap) {
            super(type, pToWrap);
        }
    }
}

