/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.ufCheckingProver;

import java.math.BigInteger;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.ufCheckingProver.UFCheckingBasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.Model;

public class FunctionApplicationManager {
    private final FormulaManagerView fmgr;
    private final LogManager logger;
    private final UFCheckingBasicProverEnvironment.UFCheckingProverOptions options;
    private final FunctionApplication INTEGER_MULT = new BinaryArithmeticFunctionApplication(){

        @Override
        BigInteger compute(BigInteger p1, BigInteger p2) {
            return p1.multiply(p2);
        }
    };
    private final FunctionApplication INTEGER_DIV = new BinaryArithmeticFunctionApplication(){

        @Override
        BigInteger compute(BigInteger p1, BigInteger p2) {
            if (BigInteger.ZERO.equals(p2)) {
                return null;
            }
            return p1.divide(p2);
        }
    };
    private final FunctionApplication INTEGER_MOD = new BinaryArithmeticFunctionApplication(){

        @Override
        BigInteger compute(BigInteger p1, BigInteger p2) {
            if (BigInteger.ZERO.equals(p2)) {
                return null;
            }
            return p1.remainder(p2);
        }
    };
    private final FunctionApplication INTEGER_SHIFT_LEFT = new BinaryArithmeticFunctionApplication(){

        @Override
        BigInteger compute(BigInteger p1, BigInteger p2) {
            int v = p2.intValue();
            if (v < 0) {
                return null;
            }
            return p1.shiftLeft(v);
        }
    };
    private final FunctionApplication INTEGER_SHIFT_RIGHT = new BinaryArithmeticFunctionApplication(){

        @Override
        BigInteger compute(BigInteger p1, BigInteger p2) {
            int v = p2.intValue();
            if (v < 0) {
                return null;
            }
            return p1.shiftRight(v);
        }
    };
    private final FunctionApplication INTEGER_AND = new BinaryArithmeticFunctionApplication(){

        @Override
        BigInteger compute(BigInteger p1, BigInteger p2) {
            return p1.and(p2);
        }
    };
    private final FunctionApplication INTEGER_OR = new BinaryArithmeticFunctionApplication(){

        @Override
        BigInteger compute(BigInteger p1, BigInteger p2) {
            return p1.or(p2);
        }
    };
    private final FunctionApplication INTEGER_XOR = new BinaryArithmeticFunctionApplication(){

        @Override
        BigInteger compute(BigInteger p1, BigInteger p2) {
            return p1.xor(p2);
        }
    };
    private final FunctionApplication INTEGER_NOT = new UnaryFunctionApplication(){

        @Override
        BigInteger compute(Model.ValueAssignment pFunc, BigInteger p1) {
            return p1.not();
        }
    };
    private final FunctionApplication OVERFLOW = new UnaryFunctionApplication(){

        @Override
        BigInteger compute(Model.ValueAssignment func, BigInteger p1) {
            String name = func.getName();
            assert (name.startsWith("_overflowSigned") || name.startsWith("_overflowUnsigned"));
            boolean signed = name.startsWith("_overflowSigned");
            String length = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
            return this.overflow(signed, Integer.parseInt(length), p1);
        }

        private BigInteger overflow(boolean signed, int bitsize, BigInteger value) {
            if (signed && !FunctionApplicationManager.this.options.isSignedOverflowSafe()) {
                return null;
            }
            BigInteger range = BigInteger.ONE.shiftLeft(bitsize);
            value = value.mod(range);
            BigInteger max = BigInteger.ONE.shiftLeft(bitsize - 1);
            if (signed && value.compareTo(max) >= 0) {
                value = value.subtract(range);
            }
            return value;
        }
    };

    protected FunctionApplicationManager(FormulaManagerView pFmgr, LogManager pLogger, UFCheckingBasicProverEnvironment.UFCheckingProverOptions pOptions) {
        this.fmgr = pFmgr;
        this.logger = pLogger;
        this.options = pOptions;
    }

    public BooleanFormula evaluate(Model.ValueAssignment entry, Object value) {
        String functionName;
        switch (functionName = entry.getName()) {
            case "Integer__*_": {
                return this.INTEGER_MULT.apply(entry, value);
            }
            case "Integer__/_": {
                return this.INTEGER_DIV.apply(entry, value);
            }
            case "Integer__%_": {
                return this.INTEGER_MOD.apply(entry, value);
            }
            case "_<<_": {
                return this.INTEGER_SHIFT_LEFT.apply(entry, value);
            }
            case "_>>_": {
                return this.INTEGER_SHIFT_RIGHT.apply(entry, value);
            }
            case "_&_": {
                return this.INTEGER_AND.apply(entry, value);
            }
            case "_!!_": {
                return this.INTEGER_OR.apply(entry, value);
            }
            case "_^_": {
                return this.INTEGER_XOR.apply(entry, value);
            }
            case "_~_": {
                return this.INTEGER_NOT.apply(entry, value);
            }
        }
        if (functionName.startsWith("_overflow")) {
            return this.OVERFLOW.apply(entry, value);
        }
        this.logger.logf(Level.ALL, "ignoring UF '%s' with value '%s'.", new Object[]{entry, value});
        return this.fmgr.getBooleanFormulaManager().makeTrue();
    }

    private BooleanFormula makeAssignmentOrTrue(Number validResult, Object value, Formula uf, BooleanFormula newAssignment) {
        if (!validResult.equals(value)) {
            this.logger.logf(Level.ALL, "replacing UF '%s' with value '%s' through '%s'.", new Object[]{uf, value, newAssignment});
            return newAssignment;
        }
        return this.fmgr.getBooleanFormulaManager().makeTrue();
    }

    private abstract class UnaryFunctionApplication
    implements FunctionApplication {
        private UnaryFunctionApplication() {
        }

        @Override
        public final BooleanFormula apply(Model.ValueAssignment func, Object value) {
            BigInteger p1 = (BigInteger)func.getArgInterpretation(0);
            BigInteger validResult = this.compute(func, p1);
            if (validResult == null) {
                return FunctionApplicationManager.this.fmgr.getBooleanFormulaManager().makeTrue();
            }
            Object uf = FunctionApplicationManager.this.fmgr.getFunctionFormulaManager().declareAndCallUF(func.getName(), this.getType(), new Formula[]{FunctionApplicationManager.this.fmgr.makeNumber(this.getType(), p1)});
            BooleanFormula newAssignment = FunctionApplicationManager.this.fmgr.makeEqual(uf, FunctionApplicationManager.this.fmgr.makeNumber(this.getType(), validResult));
            return FunctionApplicationManager.this.makeAssignmentOrTrue(validResult, value, (Formula)uf, newAssignment);
        }

        FormulaType<?> getType() {
            return FormulaType.IntegerType;
        }

        abstract BigInteger compute(Model.ValueAssignment var1, BigInteger var2);
    }

    private abstract class BinaryArithmeticFunctionApplication
    implements FunctionApplication {
        private BinaryArithmeticFunctionApplication() {
        }

        @Override
        public final BooleanFormula apply(Model.ValueAssignment func, Object value) {
            BigInteger arg2;
            assert (value instanceof BigInteger);
            BigInteger arg1 = (BigInteger)func.getArgInterpretation(0);
            BigInteger validResult = this.compute(arg1, arg2 = (BigInteger)func.getArgInterpretation(1));
            if (validResult == null) {
                return FunctionApplicationManager.this.fmgr.getBooleanFormulaManager().makeTrue();
            }
            Object uf = FunctionApplicationManager.this.fmgr.getFunctionFormulaManager().declareAndCallUF(func.getName(), this.getType(), new Formula[]{FunctionApplicationManager.this.fmgr.makeNumber(this.getType(), arg1), FunctionApplicationManager.this.fmgr.makeNumber(this.getType(), arg2)});
            BooleanFormula newAssignment = FunctionApplicationManager.this.fmgr.makeEqual(uf, FunctionApplicationManager.this.fmgr.makeNumber(this.getType(), validResult));
            return FunctionApplicationManager.this.makeAssignmentOrTrue(validResult, value, (Formula)uf, newAssignment);
        }

        FormulaType<?> getType() {
            return FormulaType.IntegerType;
        }

        abstract BigInteger compute(BigInteger var1, BigInteger var2);
    }

    private static interface FunctionApplication {
        public BooleanFormula apply(Model.ValueAssignment var1, Object var2);
    }
}

