/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.ufCheckingProver;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.ufCheckingProver.FunctionApplicationManager;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;

public class UFCheckingBasicProverEnvironment<T>
implements BasicProverEnvironment<T> {
    private final BasicProverEnvironment<T> delegate;
    private final LogManager logger;
    private final BooleanFormulaManager bfmgr;
    private final FunctionApplicationManager faMgr;
    private final UFCheckingProverOptions options;
    private final Deque<Integer> pushedConstraints = new ArrayDeque<Integer>();

    public UFCheckingBasicProverEnvironment(LogManager pLogger, BasicProverEnvironment<T> bpe, FormulaManagerView pFmgr, UFCheckingProverOptions options) {
        this.delegate = bpe;
        this.logger = pLogger;
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.faMgr = new FunctionApplicationManager(pFmgr, pLogger, options);
        this.options = options;
    }

    public T push(BooleanFormula f) throws InterruptedException {
        this.pushedConstraints.addLast(0);
        return (T)this.delegate.push(f);
    }

    public void pop() {
        for (int i = 0; i < this.pushedConstraints.getLast(); ++i) {
            this.delegate.pop();
        }
        this.pushedConstraints.removeLast();
        this.delegate.pop();
    }

    public T addConstraint(BooleanFormula constraint) throws InterruptedException {
        return (T)this.delegate.addConstraint(constraint);
    }

    public void push() {
        this.pushedConstraints.addLast(0);
        this.delegate.push();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isUnsat() throws SolverException, InterruptedException {
        boolean unsat = this.delegate.isUnsat();
        int additionalConstraints = 0;
        while (!unsat) {
            ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
            try (Model model = this.getModel();){
                for (Model.ValueAssignment entry : model) {
                    Object value;
                    BooleanFormula newAssignment;
                    if (!entry.isFunction() || this.bfmgr.isTrue(newAssignment = this.faMgr.evaluate(entry, value = entry.getValue()))) continue;
                    constraints.add(newAssignment);
                }
            }
            if (constraints.isEmpty()) {
                this.logger.log(Level.FINE, new Object[]{"no UFs to improve"});
                break;
            }
            if (additionalConstraints > this.options.maxIterationNum) {
                this.logger.log(Level.INFO, new Object[]{"aborting further sat-checks with UF-checking"});
                break;
            }
            ++additionalConstraints;
            this.push(this.bfmgr.and(constraints));
            unsat = this.delegate.isUnsat();
        }
        this.pushedConstraints.addLast(this.pushedConstraints.removeLast() + additionalConstraints);
        return unsat;
    }

    public Model getModel() throws SolverException {
        return this.delegate.getModel();
    }

    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        return this.delegate.getModelAssignments();
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        return this.delegate.isUnsatWithAssumptions(assumptions);
    }

    public List<BooleanFormula> getUnsatCore() {
        return this.delegate.getUnsatCore();
    }

    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        return (R)this.delegate.allSat(callback, important);
    }

    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        return this.delegate.unsatCoreOverAssumptions(assumptions);
    }

    @Options(prefix="cpa.predicate.solver.ufCheckingProver")
    public static class UFCheckingProverOptions {
        @Option(description="How often should we try to get a better evaluation?")
        private int maxIterationNum = 5;
        @Option(description="C99 only defines the overflow of unsigned integer type.")
        private boolean isSignedOverflowSafe = true;

        public UFCheckingProverOptions(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }

        boolean isSignedOverflowSafe() {
            return this.isSignedOverflowSafe;
        }
    }
}

