/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.weakening;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public class CEXWeakeningManager {
    private final BooleanFormulaManager bfmgr;
    private final Solver solver;
    private final InductiveWeakeningManager.InductiveWeakeningStatistics statistics;
    private final Random r = new Random(0L);
    private final ShutdownNotifier shutdownNotifier;
    private final WeakeningOptions options;

    public CEXWeakeningManager(FormulaManagerView pFmgr, Solver pSolver, InductiveWeakeningManager.InductiveWeakeningStatistics pStatistics, WeakeningOptions pOptions, ShutdownNotifier pShutdownNotifier) {
        this.options = pOptions;
        this.solver = pSolver;
        this.statistics = pStatistics;
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.shutdownNotifier = pShutdownNotifier;
    }

    public Set<BooleanFormula> performWeakening(Set<BooleanFormula> selectors, BooleanFormula fromState, PathFormula transition, BooleanFormula toState) throws SolverException, InterruptedException {
        HashSet<BooleanFormula> toAbstract = new HashSet<BooleanFormula>();
        ArrayList<BooleanFormula> selectorConstraints = new ArrayList<BooleanFormula>();
        for (BooleanFormula selector : selectors) {
            selectorConstraints.add(this.bfmgr.not(selector));
        }
        BooleanFormula query = this.bfmgr.and(new BooleanFormula[]{fromState, transition.getFormula(), this.bfmgr.not(toState)});
        int noIterations = 1;
        try (ProverEnvironment env = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            env.push(query);
            while (!env.isUnsatWithAssumptions(selectorConstraints)) {
                ++noIterations;
                this.shutdownNotifier.shutdownIfNecessary();
                try (Model m = env.getModel();){
                    toAbstract.addAll(this.getSelectorsToAbstract((ImmutableSet<BooleanFormula>)ImmutableSet.copyOf(toAbstract), m, selectors, toState, 0));
                }
                selectorConstraints.clear();
                for (BooleanFormula selector : selectors) {
                    if (toAbstract.contains(selector)) {
                        selectorConstraints.add(selector);
                        continue;
                    }
                    selectorConstraints.add(this.bfmgr.not(selector));
                }
            }
        }
        this.statistics.iterationsNo.add((Object)noIterations);
        return toAbstract;
    }

    private List<BooleanFormula> getSelectorsToAbstract(final ImmutableSet<BooleanFormula> toAbstract, final Model m, final Set<BooleanFormula> selectors, BooleanFormula primed, final int depth) {
        final ArrayList<BooleanFormula> newToAbstract = new ArrayList<BooleanFormula>();
        this.bfmgr.visitRecursively(primed, (BooleanFormulaVisitor)new DefaultBooleanFormulaVisitor<TraversalProcess>(){

            protected TraversalProcess visitDefault() {
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitAnd(List<BooleanFormula> operands) {
                HashSet<BooleanFormula> filtered = new HashSet<BooleanFormula>();
                for (BooleanFormula op : operands) {
                    if (!this.shouldAbstract(op)) continue;
                    filtered.add(op);
                }
                return TraversalProcess.custom(filtered);
            }

            public TraversalProcess visitOr(List<BooleanFormula> operands) {
                Optional<BooleanFormula> selector = this.findSelector(operands);
                if (selector.isPresent()) {
                    if (this.shouldAbstract(CEXWeakeningManager.this.bfmgr.or(operands))) {
                        this.handleAnnotatedLiteral(selector.orElseThrow());
                    }
                    return TraversalProcess.SKIP;
                }
                return this.selectChildren(operands);
            }

            private void handleAnnotatedLiteral(BooleanFormula selector) {
                if (!toAbstract.contains((Object)selector)) {
                    newToAbstract.add(selector);
                }
            }

            private boolean shouldAbstract(BooleanFormula f) {
                Boolean out = m.evaluate(CEXWeakeningManager.this.bfmgr.not(f));
                return out != null && out != false;
            }

            private Optional<BooleanFormula> findSelector(List<BooleanFormula> orOperands) {
                for (BooleanFormula operand : orOperands) {
                    if (!selectors.contains(operand)) continue;
                    return Optional.of(operand);
                }
                return Optional.empty();
            }

            private TraversalProcess selectChildren(List<BooleanFormula> operands) {
                switch (CEXWeakeningManager.this.options.getRemovalSelectionStrategy()) {
                    case ALL: {
                        return TraversalProcess.CONTINUE;
                    }
                    case FIRST: {
                        BooleanFormula selected = operands.iterator().next();
                        return TraversalProcess.custom((Formula)selected);
                    }
                    case RANDOM: {
                        int rand = CEXWeakeningManager.this.r.nextInt(operands.size());
                        return TraversalProcess.custom((Formula)((Formula)operands.get(rand)));
                    }
                    case LEAST_REMOVALS: {
                        if (depth >= CEXWeakeningManager.this.options.getLeastRemovalsDepthLimit()) {
                            return TraversalProcess.custom((Formula)((Formula)operands.iterator().next()));
                        }
                        BooleanFormula out = Collections.min(operands, Comparator.comparingInt(f -> this.recursivelyCallSelf((BooleanFormula)f).size()));
                        return TraversalProcess.custom((Formula)out);
                    }
                }
                throw new UnsupportedOperationException("Unexpected strategy");
            }

            private List<BooleanFormula> recursivelyCallSelf(BooleanFormula f) {
                return CEXWeakeningManager.this.getSelectorsToAbstract((ImmutableSet<BooleanFormula>)toAbstract, m, selectors, f, depth + 1);
            }
        });
        return newToAbstract;
    }

    static enum SELECTION_STRATEGY {
        ALL,
        FIRST,
        RANDOM,
        LEAST_REMOVALS;

    }
}

