/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.weakening;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.SyntacticWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class DestructiveWeakeningManager {
    private final Solver solver;
    private final BooleanFormulaManager bfmgr;
    private final SyntacticWeakeningManager swmgr;
    private final InductiveWeakeningManager.InductiveWeakeningStatistics statistics;
    private final WeakeningOptions options;

    public DestructiveWeakeningManager(Solver pSolver, FormulaManagerView pFmgr, WeakeningOptions pOptions, InductiveWeakeningManager.InductiveWeakeningStatistics pStatistics) {
        this.options = pOptions;
        this.solver = pSolver;
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.swmgr = new SyntacticWeakeningManager(pFmgr);
        this.statistics = pStatistics;
    }

    public Set<BooleanFormula> performWeakening(Map<BooleanFormula, BooleanFormula> selectionsVarsInfo, BooleanFormula fromState, PathFormula transition, BooleanFormula toState, SSAMap fromSSA, Set<BooleanFormula> pFromStateLemmas) throws SolverException, InterruptedException {
        Set<BooleanFormula> selectorsToAbstractOverApproximation = this.options.doPreRunSyntacticWeakening() ? this.swmgr.performWeakening(fromSSA, selectionsVarsInfo, transition.getSsa(), pFromStateLemmas) : selectionsVarsInfo.keySet();
        BooleanFormula query = this.bfmgr.and(new BooleanFormula[]{fromState, transition.getFormula(), this.bfmgr.not(toState)});
        return this.destructiveWeakening(selectionsVarsInfo.keySet(), selectorsToAbstractOverApproximation, query);
    }

    private BooleanFormula generateNegations(Set<BooleanFormula> selectors, Set<BooleanFormula> toAbstract) {
        return (BooleanFormula)selectors.stream().filter(sel -> !toAbstract.contains(sel)).map(arg_0 -> ((BooleanFormulaManager)this.bfmgr).not(arg_0)).collect(this.bfmgr.toConjunction());
    }

    public Set<BooleanFormula> destructiveWeakening(Set<BooleanFormula> selectors, Set<BooleanFormula> selectionVars, BooleanFormula query) throws SolverException, InterruptedException {
        HashSet<Object> toAbstract;
        HashSet<BooleanFormula> walked = new HashSet<BooleanFormula>();
        try (ProverEnvironment pe = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS);){
            pe.push();
            pe.addConstraint(query);
            Optional core = pe.unsatCoreOverAssumptions(selectionVars);
            if (!core.isPresent()) {
                throw new IllegalStateException("Unexpected state");
            }
            List unsatCore = (List)core.orElseThrow();
            HashSet toWalk = new HashSet(unsatCore);
            toAbstract = new HashSet<BooleanFormula>(unsatCore);
            int noIterations = 1;
            while (!walked.containsAll(toWalk)) {
                BooleanFormula toTest = (BooleanFormula)toWalk.iterator().next();
                toAbstract.remove(toTest);
                walked.add(toTest);
                pe.push();
                pe.addConstraint(this.generateNegations(selectors, toAbstract));
                core = pe.unsatCoreOverAssumptions(toAbstract);
                ++noIterations;
                if (core.isPresent()) {
                    List unsatCore2 = (List)core.orElseThrow();
                    toWalk = new HashSet(unsatCore2);
                    toAbstract = new HashSet(unsatCore2);
                } else {
                    toAbstract.add(toTest);
                    toWalk.remove(toTest);
                }
                pe.pop();
            }
            this.statistics.iterationsNo.add((Object)noIterations);
        }
        return toAbstract;
    }
}

