/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.weakening;

import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.CEXWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.DestructiveWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.SyntacticWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;

public class InductiveWeakeningManager
implements StatisticsProvider {
    private final WeakeningOptions options;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bfmgr;
    private final LogManager logger;
    private final InductiveWeakeningStatistics statistics;
    private final SyntacticWeakeningManager syntacticWeakeningManager;
    private final DestructiveWeakeningManager destructiveWeakeningManager;
    private final CEXWeakeningManager cexWeakeningManager;
    private final Solver solver;
    private static final String SELECTOR_VAR_TEMPLATE = "_FS_SEL_VAR_";

    public InductiveWeakeningManager(WeakeningOptions pOptions, Solver pSolver, LogManager pLogger, ShutdownNotifier pShutdownNotifier) {
        this.options = pOptions;
        this.statistics = new InductiveWeakeningStatistics();
        this.fmgr = pSolver.getFormulaManager();
        this.logger = pLogger;
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.syntacticWeakeningManager = new SyntacticWeakeningManager(this.fmgr);
        this.destructiveWeakeningManager = new DestructiveWeakeningManager(pSolver, this.fmgr, this.options, this.statistics);
        this.solver = pSolver;
        this.cexWeakeningManager = new CEXWeakeningManager(this.fmgr, pSolver, this.statistics, this.options, pShutdownNotifier);
    }

    public Set<BooleanFormula> findInductiveWeakeningForRCNF(SSAMap startingSSA, Set<BooleanFormula> fromStateLemmas, PathFormula transition, Set<BooleanFormula> toStateLemmas) throws SolverException, InterruptedException {
        BooleanFormula fromStateLemmasInstantiated = (BooleanFormula)fromStateLemmas.stream().map(f -> this.fmgr.instantiate(f, startingSSA)).collect(this.bfmgr.toConjunction());
        BiMap<BooleanFormula, BooleanFormula> selectionInfo = this.annotateConjunctions(toStateLemmas);
        BooleanFormula toStateLemmasAnnotated = (BooleanFormula)Collections3.zipMapEntries(selectionInfo, (selector, f) -> this.bfmgr.or(selector, this.fmgr.instantiate(f, transition.getSsa()))).collect(this.bfmgr.toConjunction());
        Set<BooleanFormula> toAbstract = this.findSelectorsToAbstract((Map<BooleanFormula, BooleanFormula>)selectionInfo, fromStateLemmasInstantiated, transition, toStateLemmasAnnotated, startingSSA, fromStateLemmas);
        ImmutableSet out = FluentIterable.from(toStateLemmas).filter(lemma -> !toAbstract.contains(selectionInfo.inverse().get(lemma))).toSet();
        assert (this.checkAllMapsTo(fromStateLemmas, startingSSA, (Set<BooleanFormula>)out, transition.getSsa(), transition.getFormula()));
        return out;
    }

    public Set<BooleanFormula> findInductiveWeakeningForRCNF(SSAMap startingSSA, PathFormula transition, Set<BooleanFormula> lemmas) throws SolverException, InterruptedException {
        BiMap<BooleanFormula, BooleanFormula> selectionInfo = this.annotateConjunctions(lemmas);
        BooleanFormula fromStateLemmasAnnotated = (BooleanFormula)Collections3.zipMapEntries(selectionInfo, (selector, f) -> this.bfmgr.or(selector, this.fmgr.instantiate(f, startingSSA))).collect(this.bfmgr.toConjunction());
        BooleanFormula toStateLemmasAnnotated = (BooleanFormula)Collections3.zipMapEntries(selectionInfo, (selector, f) -> this.bfmgr.or(selector, this.fmgr.instantiate(f, transition.getSsa()))).collect(this.bfmgr.toConjunction());
        Set<BooleanFormula> toAbstract = this.findSelectorsToAbstract((Map<BooleanFormula, BooleanFormula>)selectionInfo, fromStateLemmasAnnotated, transition, toStateLemmasAnnotated, startingSSA, lemmas);
        ImmutableSet out = FluentIterable.from(lemmas).filter(lemma -> !toAbstract.contains(selectionInfo.inverse().get(lemma))).toSet();
        assert (this.checkAllMapsTo((Set<BooleanFormula>)out, startingSSA, (Set<BooleanFormula>)out, transition.getSsa(), transition.getFormula()));
        return out;
    }

    private boolean checkAllMapsTo(Set<BooleanFormula> from, SSAMap startSSA, Set<BooleanFormula> to, SSAMap finishSSA, BooleanFormula transition) throws SolverException, InterruptedException {
        return this.solver.isUnsat(this.bfmgr.and(new BooleanFormula[]{this.fmgr.instantiate(this.bfmgr.and(from), startSSA), transition, this.fmgr.instantiate(this.bfmgr.not(this.bfmgr.and(to)), finishSSA)}));
    }

    private Set<BooleanFormula> findSelectorsToAbstract(Map<BooleanFormula, BooleanFormula> selectionVarsInfo, BooleanFormula fromState, PathFormula transition, BooleanFormula toState, SSAMap fromSSA, Set<BooleanFormula> pFromStateLemmas) throws SolverException, InterruptedException {
        switch (this.options.getWeakeningStrategy()) {
            case SYNTACTIC: {
                return this.syntacticWeakeningManager.performWeakening(fromSSA, selectionVarsInfo, transition.getSsa(), pFromStateLemmas);
            }
            case DESTRUCTIVE: {
                return this.destructiveWeakeningManager.performWeakening(selectionVarsInfo, fromState, transition, toState, fromSSA, pFromStateLemmas);
            }
            case CEX: {
                return this.cexWeakeningManager.performWeakening(selectionVarsInfo.keySet(), fromState, transition, toState);
            }
        }
        throw new UnsupportedOperationException("Unexpected enum value");
    }

    public BooleanFormula removeRedundancies(BooleanFormula input) throws InterruptedException, SolverException {
        BooleanFormula nnf = this.fmgr.applyTactic(input, Tactic.NNF);
        try {
            return this.bfmgr.transformRecursively(nnf, (BooleanFormulaTransformationVisitor)new BooleanFormulaManagerView.BooleanFormulaTransformationVisitor(this.fmgr){

                public BooleanFormula visitAnd(List<BooleanFormula> processedOperands) {
                    try {
                        return InductiveWeakeningManager.this.bfmgr.and(InductiveWeakeningManager.this.simplifyArgs(processedOperands));
                    }
                    catch (InterruptedException e) {
                        throw new TemporaryException(e);
                    }
                    catch (SolverException e) {
                        throw new TemporaryException(e);
                    }
                }

                public BooleanFormula visitOr(List<BooleanFormula> processedOperands) {
                    try {
                        return InductiveWeakeningManager.this.bfmgr.or(InductiveWeakeningManager.this.simplifyArgs(processedOperands));
                    }
                    catch (InterruptedException e) {
                        throw new TemporaryException(e);
                    }
                    catch (SolverException e) {
                        throw new TemporaryException(e);
                    }
                }
            });
        }
        catch (TemporaryException e) {
            throw e.unwrap();
        }
    }

    private List<BooleanFormula> simplifyArgs(List<BooleanFormula> args) throws SolverException, InterruptedException {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < args.size(); ++i) {
                BooleanFormula f = args.get(i);
                List<BooleanFormula> others = this.others(args, i);
                if (!this.solver.isUnsat(this.bfmgr.not(this.bfmgr.implication(this.bfmgr.and(others), f)))) continue;
                args = others;
                changed = true;
            }
        }
        return args;
    }

    private <T> List<T> others(List<T> l, int i) {
        ArrayList<T> others = new ArrayList<T>(l);
        others.remove(i);
        return others;
    }

    BiMap<BooleanFormula, BooleanFormula> annotateConjunctions(Collection<BooleanFormula> pInput) {
        ImmutableBiMap.Builder result = ImmutableBiMap.builder();
        int i = -1;
        for (BooleanFormula f : pInput) {
            BooleanFormula selector = this.bfmgr.makeVariable(SELECTOR_VAR_TEMPLATE + ++i);
            result.put((Object)selector, (Object)f);
        }
        return result.buildOrThrow();
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.statistics);
    }

    public static class InductiveWeakeningStatistics
    implements Statistics {
        final Multiset<Integer> iterationsNo = HashMultiset.create();

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            out.printf("Histogram of number of iterations required for convergence: %s %n", this.iterationsNo);
        }

        @Override
        public String getName() {
            return "Inductive Weakening";
        }
    }

    private static final class TemporaryException
    extends RuntimeException {
        private static final long serialVersionUID = -7046164286357019183L;

        TemporaryException(InterruptedException e) {
            super(e);
        }

        TemporaryException(SolverException e) {
            super(e);
        }

        AssertionError unwrap() throws InterruptedException, SolverException {
            Throwables.propagateIfPossible((Throwable)this.getCause(), InterruptedException.class, SolverException.class);
            throw new AssertionError((Object)this);
        }
    }

    public static enum WEAKENING_STRATEGY {
        SYNTACTIC,
        DESTRUCTIVE,
        CEX;

    }
}

