/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.weakening;

import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.IntegerFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;

@RunWith(value=Parameterized.class)
public class InductiveWeakeningManagerTest
extends SolverViewBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverToUse;
    private InductiveWeakeningManager inductiveWeakeningManager;
    private IntegerFormulaManagerView ifmgr;
    private BooleanFormulaManagerView bfmgr;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverToUse;
    }

    @Before
    public void setUp() throws Exception {
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        this.inductiveWeakeningManager = new InductiveWeakeningManager(new WeakeningOptions(this.config), this.solver, this.logger, notifier);
        this.ifmgr = this.mgrv.getIntegerFormulaManager();
        this.bfmgr = this.mgrv.getBooleanFormulaManager();
    }

    @Test
    public void testSlicingVerySimple() throws Exception {
        SSAMap startingSsa = SSAMap.emptySSAMap().withDefault(0);
        PathFormula transition = PathFormula.createManually(this.ifmgr.equal((NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("x", 1), (NumeralFormula.IntegerFormula)this.ifmgr.add((NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("x", 0), (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(1L))), startingSsa.builder().setIndex("x", CNumericTypes.INT, 1).build(), PointerTargetSet.emptyPointerTargetSet(), 0);
        ImmutableSet lemmas = ImmutableSet.of((Object)this.ifmgr.equal((NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(1L)), (Object)this.ifmgr.equal((NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(0L)));
        Set<BooleanFormula> weakening = this.inductiveWeakeningManager.findInductiveWeakeningForRCNF(startingSsa, transition, (Set<BooleanFormula>)lemmas);
        Truth.assertThat(weakening).containsExactly(new Object[]{this.ifmgr.equal((NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(0L))});
    }

    @Test
    public void testRemovingRedundancies() throws Exception {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("y");
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(0L);
        BooleanFormula input = this.bfmgr.and(this.ifmgr.greaterThan(x, zero), this.ifmgr.greaterThan(y, zero), this.ifmgr.greaterThan((NumeralFormula.IntegerFormula)this.ifmgr.add(x, y), zero));
        BooleanFormula simplified = this.inductiveWeakeningManager.removeRedundancies(input);
        Truth.assertThat((Object)simplified).isEqualTo((Object)this.bfmgr.and(this.ifmgr.greaterThan(x, zero), this.ifmgr.greaterThan(y, zero)));
    }
}

